/*******************************************************
FAMILY STRENGTH PARENT AND YOUTH RELATIONSHIP SCALES
Program written by Child Trends 

09/02/08
**************************/

libname library 'G:\Parenting and Family Dynamics\Family Strengths - ASPE\Data\Formats\';
libname famstout 'G:\Parenting and Family Dynamics\Family Strengths - ASPE\Data\Formats\Michelles files\Family Strengths';
libname datalib 'G:\Parenting and Family Dynamics\Family Strengths - ASPE\Data';

options nofmterr pagesize=59 linesize=120 nocenter FMTSEARCH=(library); 
options date mprint nofmterr nocenter mprint; 
options nofmterr pagesize=59 linesize=120 nocenter FMTSEARCH=(library);

proc format library=library;   /*Formats*/

value peer
	1 = "1: Almost none (less than 10%)"
	2 = "2: About 25%"
	3 = "3: About half (50%)"
	4 = "4: About 75%"
	5 = "5: Almost all (more than 90%)";

value pinvol
	1 = "1: Often"
	2 = "2: Sometimes"
	3 = "3: Never";

value mombeh
      0 = '0 = As hostile as you can imagine'
      1 = '1 = very unfriendly'
      2 = '2 = unfriendly'
      3 = '3 = mixed - more unfriendly than friendly'
      4 = '4 = neutral'
      5 = '5 = mixed - more friendly than unfriendly'
      6 = '6 = friendly'
      7 = '7 = very friendly';

value dadbeh
      0 = '0 = As hostile as you can imagine'
      1 = '1 = very unfriendly'
      2 = '2 = unfriendly'
      3 = '3 = mixed - more unfriendly than friendly'
      4 = '4 = neutral'
      5 = '5 = mixed - more friendly than unfriendly'
      6 = '6 = friendly'
      7 = '7 = very friendly';

value advice
	1 = '1 = Often'
	2 = '2 = Sometimes'
	3 = '3 = Never'
	4 = '4 = Not Applicable'; /*Apply this format to the following:
	fredu02, frrel02*/

value comm
	1 = '1 = Every Day'
	2 = '2 = Several Times a Week'
	3 = '3 = About Once a Week'
	4 = '4 = About Twice a Month'
	5 = '5 = About Once a Month'
	6 = '6 = Less Than Once a Month'
	7 = '7 = Never'; /*Apply format to the following:
	frcomm02*/

value bstfrnd
	1 = '1 = Mother'
	2 = '2 = Father'
	3 = '3 = Spouse'
	4 = '4 = Cohabitating Partner'
	5 = '5 = Current Dating Partner'
	6 = '6 = Sexual Partner'
	7 = '7 = The Other Parent of Rs Child'
	8 = '8 = Someone Else';  /*Apply format to the following:
	bestfr02*/

value curenroll
	0 = '0 = No'
	1 = '1 = Yes';

value employ
	0 = '0 = No'
	1 = '1 = Yes';

value discon
	0 = '0 = No'
	1 = '1 = Yes';

value advceper
	1 = '1: Biological mother'
	2 = '2: Biological father'
	3 = '3: Step or adoptive parent'
	4 = '4: Brother or sister'
	5 = '5: Another relative'
	6 = '6: Spouse or partner'
	7 = '7: Boyfriend or girlfriend'
	8 = '8: Another friend or coworker'
	9 = '9: Professor or teacher'
	10 = '10: Someone with professional expertise in the field'
	11 = '11: Member of the clergy or other adult from place of worship'
	12 = '12: Someone else'
	13 = '13: No one';

value dechelp
	1 = '1: Often'
	2 = '2: Sometimes'
	3 = '3: Never'
	4 = '4: Have not made any decisions in this domain';

value urban
	0 = '0: rural'
	1 = '1: urban';

value yes10no
	1 = '1: yes'
	0 = '0: no';

value yes01no
	0 = '0: No'
	1 = '1: Yes';

value edulvl
	1= '1: Zero through 11th grade of High school'
	2= '2: Graduated from HS'
	3= '3: Some college'
	4= '4: College degree or higher';

value agefirst
 	.n = '.N = Never used'
	1 = '1: 12 and Under'
	2 = '1: 12 and Under'
	3 = '1: 12 and Under'
	4 = '1: 12 and Under'
	5 = '1: 12 and Under'
	6 = '1: 12 and Under'
	7 = '1: 12 and Under'
	8 = '1: 12 and Under'
	9 = '1: 12 and Under'
	10 = '1: 12 and Under'
	11 = '1: 12 and Under'
	12 = '1: 12 and Under'
	13 = '2: 13'
	14 = '3: 14'
	15 = '4: 15'
	16 = '5: 16'
	17 = '6: 17'
	18 = '8: 18 and up';

value smoke
	0 = "0: Does not smoke/not in last 30 days/less than 1 per day"
	1 = "1:  Smokes 1-5 cigarettes/day"
	2 = "2: Smokes more than 5 cigarettes/day";
	
value smoke_b
	0 = "0: Does not smoke/not in last 30 days/less than 1 per day"
	1 = "1:  Smokes < half a pack/day"
	2 = "2: Smokes half a pack or more/day";

	
value drnkdrv
	1 = "1: 0 times"
	2 = "2: 1 time"
	3 = "3: 2-3 times"
	4 = "4: 4-5 times"
	5 = "5: 6 or more times"
	6 = "6: Did not drive/not been passenger";

value quart
	1 = 'Bottom 25%'
	2 = '26% - 75%'
	3 = 'Highest 25 %';

value age
	0 -<12 = 'Under 12'
	12 = '12'
	13 = '13'
	14 = '14'
	15 = '15'
	16 = '16'
	17 = '17'
	18 = '18'
	18 - HIGH= '19 or older';

value raceth
	0 = '.'
	1 = 'White'
	2 =	'Black'
	3 = 'Hispanic'
	4 = 'American Indian'
	5 = 'Asian'
	6 =  'Other';

value resmomed
	0 -<12 = '1: LT HS Degree'
	12 = '2: HS Degree'
	13 -<16 = '3: Some College'
	16 - HIGH = '4: College Degree or higher';

value pov4cat
	1 = '1: <100% pov level'
	2 = '2: 100-200% pov level'
	3 = '3: 200-400% pov level'
	4 = '4: >400% pov level';

value rems
      0 = '0: Never married'
      1 = '1: Married'
      2 = '2: Separated'
      3 = '3: Divorced'
      4 = '4: Widowed';

value msta
      0 = 'Not married'
      1 = 'Married';

value quart
	1 = 'Bottom 25%'
	2 = '26% - 75%'
	3 = 'Highest 25 %';

value 	age
	0 -<12 = 'Under 12'
	12 = '12'
	13 = '13'
	14 = '14'
	15 = '15'
	16 = '16'
	17 = '17'
	18 = '18'
	18 - HIGH= '19 or older';

value famstrc 
 	1 = '1: 2 bio parents'
 	2 = '2: One bio parent, one step'
 	3 = '3: Adoptive parent(s)'
 	4 = '4: One single bio parent and one adoptive'
	5 = '5: Other family type';

value yes10no
	1 = '1: yes'
	0 = '0: no';

value agefirst
 	.n = '.N = Never used'
	1 = '1: 12 and Under'
	2 = '1: 12 and Under'
	3 = '1: 12 and Under'
	4 = '1: 12 and Under'
	5 = '1: 12 and Under'
	6 = '1: 12 and Under'
	7 = '1: 12 and Under'
	8 = '1: 12 and Under'
	9 = '1: 12 and Under'
	10 = '1: 12 and Under'
	11 = '1: 12 and Under'
	12 = '1: 12 and Under'
	13 = '2: 13'
	14 = '3: 14'
	15 = '4: 15'
	16 = '5: 16'
	17 = '6: 17'
	18 = '8: 18 and up';

value smoke
	0 = "0: Does not smoke/not in last 30 days/less than 1 per day"
	1 = "1:  Smokes 1-5 cigarettes/day"
	2 = "2: Smokes more than 5 cigarettes/day";
	
value smoke_b
	0 = "0: Does not smoke/not in last 30 days/less than 1 per day"
	1 = "1:  Smokes < half a pack/day"
	2 = "2: Smokes half a pack or more/day";
	
value drnkdrv
	1 = "1: 0 times"
	2 = "2: 1 time"
	3 = "3: 2-3 times"
	4 = "4: 4-5 times"
	5 = "5: 6 or more times"
	6 = "6: Did not drive/not been passenger";

value region
	1 = '1:  Northeast'
	2 = '2:  North Central'
	3 = '3:  South'
	4 = '4:  West';

value enroll16age
	1 = '1:  Dropped out, no degree'
	2 = '2:  Dropped out, GED'
	3 = '3:  Enrolled';

value racethnicity
	1 = '1: Hispanic'
	2 = '2: Non-Hispanic Black'
	3 = '3: Non-Black Non-Hispanic'
	4 = '4: Mixed race';

value severity
	0 = '0: Not disabled'
	1 = '1: Mild (Does not limit)'
	2 = '2: Moderate (Limits a little'
	3 = '3: Severe (Limits a lot';

value degree
	1 = '1: No diploma, no GED'
	2 = '2: No diploma, GED'
	3 = '3: High school diploma'
	4 = '4: Enrolled in post-secondary education';

value netwrth
	1 = '1: <= $0 networth'
	2 = '2: $1-25,000'
	3 = '3: $26,000-50,000'
	4 = '4: $51,000-100,000'
	5 = '5: >$100,000';

value health
	1 = '1: Excellent'
	2 = '2: Vey good'
	3 = '3: Good'
	4 = '4: Fair'
	5 = '5: Poor';

value chea
	0 = "0: Not true"
	1 = "1: Sometimes true"
	2 = "2: Often true";

value prelig
	1 = "1: Never"
	2 = "2: Once or twice"
	3 = "3: Less than once a month / 3-12 times"
	4 = "4: About once a month / 12 times"
	5 = "5: About twice a month / 24 times"
	6 = "6: About once a week"
	7 = "7: Several times a week"
	8 = "8: Everyday";

	
value ydyr
1 = '1: high quality dad youth relationship over time'
2 = '2: low quality dad youth relationship increasing over time' 
3 = '3: low quality dad youth relationship over time'
4 = '4: high quality dad youth relationship decreasing over time';

value yrmarqual
1 = '1: high support high conflict marital quality'
2 = '2: high support low conflict marital quality' 
3 = '3: low support low conflict marital quality'
4 = '4: low support high conflict marital quality';

value yrmyr
1 = '1: high quality mom youth relationship over time'
2 = '2: low quality mom youth relationship increasing over time' 
3 = '3: high quality mom youth relationship decreasing over time '
4 = '4: low quality mom youth relationship over time';

value yrpycat
1 = '1: mom and dad high quality over time'
2 = '2: dad only high quality over time' 
3 = '3: mom only high quality over time'
4 = '4: combinations mom and dad low quality over time';


value yrpymqcat
1 = '1: high mq and good py rel with both'
2 = '2: high mq and good py rel with one' 
3 = '3: high supp/high conflict and good py rel'
4 = '4: low mq and good py rel'
5 = '5: high mq and bad py rel'
6 = '6: low mq and bad py rel';


	run;


/****************CREATION OF FINAL DATASET AND VARIABLES**********************************/

data datalib.famstrength2; 
set datalib.famstrraw;

/************safe sex by 16 and from 17-20***********/

%Macro conduse (oldsex, newsex, oldvars, numpart, estnumpart, numsex, estnumsex, numcond, estnumcond, marstat, numparttot, 
numsextot, numcondtot, condrate);

array ar_&oldsex(7) &oldvars;
array ar_&newsex(7) &numpart &estnumpart &numsex &estnumsex &numcond &estnumcond &marstat;

	Do i = 1 to 7;
		ar_&newsex(i) = ar_&oldsex(i);
	End;
	
	If &numpart lt 0 then &numparttot = &estnumpart;
	Else &numparttot = &numpart;
	If &numsex lt 0 then &numsextot = &estnumsex;
	Else &numsextot = &numsex;
	If &numcond lt 0 then &numcondtot = &estnumcond;
	Else &numcondtot = &numcond;

	If (&marstat in (1,3,4,5,7,9)) and (&numparttot in (-4, -3, 0, 1)) then &condrate = .; /*If R married/cohab. & only 1 partner*/
	Else if &numparttot = 0 then &condrate = 100; /*0 partners since DLI*/
	Else do;
		If &numcond lt 0 then do; /*If R said Don't know or refused to # using condom*/
			If &numcondtot lt 0 then &condrate = .; /*If all condom info missing*/
			Else if (&numsextot le 0) and (&numcondtot ge 0) then &condrate = &numcondtot; /*If no sex info/only condom info*/
			Else if &numparttot gt 0 then do; /*Info on % (est) of condom use*/
				If &numcondtot = 0 then &condrate = 0;
				Else &condrate = &numcondtot;
			End;
		End;
		Else if &numcond ge 0 then do; /*If R gave answer for # of condoms*/
			If &numcondtot lt 0 then &condrate = .; /*If all condom info missing*/
			/*Else if (&numsextot le 0) and (&numcondtot ge 0) then &condrate = &numcondtot; /*If no sex info/only condom info*/
			Else if &numparttot gt 0 then do; /*Info on # of times of condom use is positive*/
				If &numcondtot = 0 then &condrate = 0;
				Else if (&numsextot = 1) and (&numcondtot = 1) then &condrate = 100;
				Else if &numcondtot le &numsextot then do;
					&condrate = ((&numcondtot/&numsextot)*100);
				End;
				/*Else &condrate = &numcondtot;*/
			End;
		End;
	End;

%Mend;

/*Round 6*/
/*Slightly different Macro because we have 2 different variables for married or cohabiting for 2002 & 2003*/

%Macro conduse6 (oldsex, newsex, oldvars, numpart, estnumpart, numsex, estnumsex, numcond, estnumcond, marstat1, 
marstat2, numparttot, numsextot, numcondtot, condrate);

array ar_&oldsex(8) &oldvars;
array ar_&newsex(8) &numpart &estnumpart &numsex &estnumsex &numcond &estnumcond &marstat1 &marstat2;

	Do i = 1 to 8;
		ar_&newsex(i) = ar_&oldsex(i);
	End;
	
	If &numpart lt 0 then &numparttot = &estnumpart;
	Else &numparttot = &numpart;
	If &numsex lt 0 then &numsextot = &estnumsex;
	Else &numsextot = &numsex;
	If &numcond lt 0 then &numcondtot = &estnumcond;
	Else &numcondtot = &numcond;

	If ((&marstat1 = 1) or (&marstat2 = 1)) and (&numparttot in (-4, -3, 0, 1)) then &condrate = .; /*If R married/cohab. & only 1 partner*/
	Else if &numparttot = 0 then &condrate = 100; /*0 partners since DLI*/
	Else do;
		If &numcond lt 0 then do; /*If R said Don't know or refused to # using condom*/
			If &numcondtot lt 0 then &condrate = .; /*If all condom info missing*/
			Else if (&numsextot le 0) and (&numcondtot ge 0) then &condrate = &numcondtot; /*If no sex info/only condom info*/
			Else if &numparttot gt 0 then do; /*Info on % (est) of condom use*/
				If &numcondtot = 0 then &condrate = 0;
				Else &condrate = &numcondtot;
			End;
		End;
		Else if &numcond ge 0 then do; /*If R gave answer for # of condoms*/
			If &numcondtot lt 0 then &condrate = .; /*If all condom info missing*/
			/*Else if (&numsextot le 0) and (&numcondtot ge 0) then &condrate = &numcondtot; /*If no sex info/only condom info*/
			Else if &numparttot gt 0 then do; /*Info on # of times of condom use is positive*/
				If &numcondtot = 0 then &condrate = 0;
				Else if (&numsextot = 1) and (&numcondtot = 1) then &condrate = 100;
				Else if &numcondtot le &numsextot then do;
					&condrate = ((&numcondtot/&numsextot)*100);
				End;
				/*Else &condrate = &numcondtot;*/
			End;
		End;
	End;

%Mend;

%conduse (oldsex2, newsex2, R2183900 R2184000 R2184100 R2184300 R2184200 R2184400 R2569300, numpart98, estnumpart98, numsex98, estnumsex98, 
numcond98, estnumcond98, marstat98, numparttot98, numsextot98, numcondtot98, condrate98);

%conduse (oldsex3, newsex3, R3501800 R3501900 R3502000 R3502200 R3502100 R3502300 R3891300, numpart99, estnumpart99, 
numsex99, estnumsex99, numcond99, estnumcond99, marstat99, numparttot99, numsextot99, numcondtot99, condrate99);

%conduse (oldsex4, newsex4, R4898400 R4898500 R4898800 R4899000 R4898900 R4899100 R5473300, numpart00, estnumpart00, 
numsex00, estnumsex00, numcond00, estnumcond00, marstat00, numparttot00, numsextot00, numcondtot00, condrate00);

%conduse (oldsex5, newsex5, R6524500 R6524600 R6524900 R6525100 R6525000 R6525200 R7237000, numpart01, estnumpart01, 
numsex01, estnumsex01, numcond01, estnumcond01, marstat01, numparttot01, numsextot01, numcondtot01, condrate01);

%conduse6 (oldsex6, newsex6, S1204000 S1204100 S1204400 S1204600 S1204500 S1204700 S1200200 S1193400, numpart02, estnumpart02, 
numsex02, estnumsex02, numcond02, estnumcond02, marstat102, marstat202, numparttot02, numsextot02, numcondtot02, condrate02);

%conduse6 (oldsex7, newsex7, S3286800 S3286900 S3287200 S3287400 S3287300 S3287500 S3283000 S3274800, numpart03, 
estnumpart03, numsex03, estnumsex03, numcond03, estnumcond03, marstat103, marstat203, numparttot03, numsextot03, 
numcondtot03, condrate03);

%conduse6 (oldsex8, newsex8, S4909700 S4909800 S4910100 S4910300 S4910200 S4910400 S4905900 S4897700, numpart04, 
estnumpart04, numsex04, estnumsex04, numcond04, estnumcond04, marstat104, marstat204, numparttot04, numsextot04, 
numcondtot04, condrate04);

/***********Sample variable******************************/
/*The sample for this study is 12-14 year old males and females who did not have sex by R1 and 
who reached age 16*/

/*The first step is to look though each round and figure out when R first reported having sex and at 
what age they report this happening.  This will help us create both the sample and the early sex outcome
variable*/

*Recode gender;
M_F=.;
if R0536300 = 1 then M_F=1;
else M_F = 0;
label M_F = 'Gender of Respondent';
format M_F gender.;

/* ROUND 1 */

*CODING WHETHER RESPONDENT HAD SEX AND RECORDING AGE. 1= YES, 0 = NO, -1= REFUSAL, -2= DONT KNOW*;

sxrnd1=.;
if r0349700=1 then sxrnd1=1;	* R0349700=Ever had sex 1997 *;
else if r0349700=0 then sxrnd1=0;
else if r0349700 lt 0 then sxrnd1=r0349700;
label sxrnd1='Did R have sex by Rnd 1 NLSY97?';

agesxrnd1=.;
if sxrnd1=1 then agesxrnd1=r0349800;  * R0349800= Age at 1st sex 1997*;
label agesxrnd1='R^s age @ 1st sex rnd1 answr';

/* ROUND 2 */

sxrnd2=.;
if r2183000=1 or r2182900=1 then sxrnd2=1; *R2182900=R ever had sex 1998*;
else if r2183000=0 or r2182900=0 then sxrnd2=0; *R2183000=R have sex since date of last interview 1998*;
else if r2182900 lt 0 and r2183000 lt 0 then sxrnd2=max(R2182900, R2183000); 
label sxrnd2='Did R have sex by Rnd 2 NLSY97?';

agesxrnd2=.;
if sxrnd2=1 then agesxrnd2=r2183200;  * R2183200=Age at 1st sex 1998*;
label agesxrnd2='R^s age @ 1st sex rnd2 answr';

/* ROUND 3 */
/* NOTE THAT VARIABLE NAMES WERE CHANGED IN THE RND6 EVENT HISTORY CD & ARE REFLECTED HERE*/

sxrnd3=.;
if r3500800=1 or r3500900=1 then sxrnd3=1; *R3500800=R ever had sex 1999*;
else if r3500800=0 or r3500900=0 then sxrnd3=0; *R3500900=R had sex SDLI 1999*;
else if r3500800 lt 0 and r3500900 lt 0 then sxrnd3=max(r3500800, r3500900);
label sxrnd3='Did R have sex by Rnd 3 NLSY97?';

agesxrnd3=.;
if sxrnd3=1 then agesxrnd3=r3501100;  *R3501100=Age at 1st sex 1999*;
label agesxrnd3='R^s age @ 1st sex rnd3 answr';

/* ROUND 4 */

sxrnd4=.;
if R4896400=1 or R4896500=1 then sxrnd4=1; *R4896400=R ever had sex 2000*;
else if R4896400=0 or R4896500=0 then sxrnd4=0; *R4896500=R had sex SDLI 2000*;
else if R4896400 lt 0 and R4896500 lt 0 then sxrnd4=max(R4896400, R4896500);
label sxrnd4='Did R have sex by Rnd 4 NLSY97?';

agesxrnd4=.;
if sxrnd4=1 then agesxrnd4=r4896800;  *R4896800=Age at 1st sex 2000*;
label agesxrnd4='R^s age @ 1st sex rnd4 answr';

/* ROUND 5 */
/* NOTE THAT VARIABLE NAMES WERE CHANGED IN THE RND6 EVENT HISTORY CD & ARE REFLECTED HERE*/

sxrnd5=.;
if R6522500=1 or R6522600=1 then sxrnd5=1; *R6522500=R EVER HAVE SEX? 2001*;
else if R6522500=0 or R6522600=0 then sxrnd5=0; *R6522600=R HAVE SEX SDLI? 2001*;
else if R6522500 lt 0 and R6522600 lt 0 then sxrnd5=max(R6522500, R6522600);
label sxrnd5='Did R have sex by Rnd 5 NLSY97?';

agesxrnd5=.;
if sxrnd5=1 then agesxrnd5=R6522900;  *R6522900=Age at 1st sex 2001*;
label agesxrnd5='R^s age @ 1st sex Rnd5 answr';

/* ROUND 6 */
/* NEW TO OUR PROGRAMMING FROM THE RND6 EVENT HISTORY CD */

sxrnd6=.;
if S1201700=1 or S1201800=1 then sxrnd6=1; *S1201700=R EVER HAVE SEX? 2002*;
else if  S1201500=1 or S1201600=1 then sxrnd6=1; * S1201500=R reported sex in dating or marriage section;
												 * S1201600=R reported sex in dating or marriage section;

else if S1201700=0 or S1201800=0 then sxrnd6=0; *S1201800=R HAVE SEX SDLI? 2002*;
else if S1201700 lt 0 and S1201800 lt 0 then sxrnd6=max(S1201700, S1201800);
label sxrnd6='Did R have sex by Rnd 6 NLSY97?';

/* creating CM (century month) of date of first sex with dating partner */

if S1198500 ge 1 and S1198501 ge 1 then do;      * S1198500=R what month had first sex with partner;
	year_sxr6=S1198501-1900;					 * S1198501=R what year had first sex with partner;
	cmrnd6_sx=(year_sxr6*12)+S1198500;
end;

/* creating CM of date of birth */

if R0536401 ge 1 and R0536402 ge 1 then do;      * R0536401=R month of birth;
	year_r6=R0536402-1900;						 * R0536402=R year of birth;
	cmbirth=(year_r6*12)+R0536401;
end;

age_r6_cm=.;
if cmrnd6_sx le 0 or cmbirth le 0 then age_r6_cm=.;
else age_r6_cm=floor((cmrnd6_sx-cmbirth)/12);
label age_r6_cm='Age at 1st sex R6 with dating partner';

agesxrnd6=.;
if sxrnd6=1 and S1202000 gt 0 then agesxrnd6=S1202000;  *S1202000=Age at 1st sex 2002*;
else if sxrnd6=1 and age_r6_cm gt 0 then agesxrnd6=age_r6_cm;

label agesxrnd6='R^s age @ 1st sex Rnd6 answr';

/*Adding in Round 7 information*/
sxrnd7=.;
if S3284500=1 or S3284600=1 then sxrnd7=1; *S3284500=R EVER HAVE SEX? 2003*;
else if  S3284300=1 or S3284400=1 then sxrnd7=1; * S1201500=R reported sex in dating or marriage section;

else if S3284500=0 or S3284600=0 then sxrnd7=0; *S3284600=R HAVE SEX SDLI? 2003*;
else if S3284500 lt 0 and S3284600 lt 0 then sxrnd7=max(S3284500, S3284600);
label sxrnd7='Did R have sex by Rnd 7 NLSY97?';

/* creating CM of date of first sex with dating partner */

if S3281200 ge 1 and S3281201 ge 1 then do;
	year_sxr7=S3281201-1900;
	cmrnd7_sx=(year_sxr7*12)+S3281200;
end;

age_r7_cm=.;
if cmrnd7_sx le 0 or cmbirth le 0 then age_r7_cm=.;
else age_r7_cm=floor((cmrnd7_sx-cmbirth)/12);
label age_r7_cm='Age at 1st sex R7 with dating partner';

agesxrnd7=.;
if sxrnd7=1 and S3284800 gt 0 then agesxrnd6=S3284800;  *S3284800=Age at 1st sex 2003*;
else if sxrnd7=1 and age_r7_cm gt 0 then agesxrnd7=age_r7_cm;

label agesxrnd7='R^s age @ 1st sex Rnd7 answr';

/*Adding in Round 8 information*/

sxrnd8=.;
if S4907400=1 or S4907500=1 then sxrnd8=1; *S4907500=R EVER HAVE SEX? 2004*;
else if  S4907200=1 or S4907300=1 then sxrnd8=1; * S4907200=R reported sex in dating or marriage section;

else if S4907400=0 or S4907500=0 then sxrnd8=0; *S4907500=R HAVE SEX SDLI? 2004*;
else if S4907400 lt 0 and S4907500 lt 0 then sxrnd8=max(S4907400, S4907500);
label sxrnd8='Did R have sex by Rnd 8 NLSY97?';

/* creating CM of date of first sex with dating partner */

if S4904100 ge 1 and S4904101 ge 1 then do;
	year_sxr8=S4904101-1900;
	cmrnd8_sx=(year_sxr8*12)+S4904100;
end;

age_r8_cm=.;
if cmrnd8_sx le 0 or cmbirth le 0 then age_r8_cm=.;
else age_r8_cm=floor((cmrnd8_sx-cmbirth)/12);
label age_r8_cm='Age at 1st sex R8 with dating partner';

agesxrnd8=.;
if sxrnd8=1 and S4907700 gt 0 then agesxrnd8=S4907700;  *S4907700=Age at 1st sex 2004*;
else if sxrnd8=1 and age_r8_cm gt 0 then agesxrnd8=age_r8_cm;

label agesxrnd8='R^s age @ 1st sex Rnd8 answr';

/* SUM OF 8 ROUNDS */
if sxrnd8=1 then rnd1styes=8;
if sxrnd7=1 then rnd1styes=7;
if sxrnd6=1 then rnd1styes=6;
if sxrnd5=1 then rnd1styes=5;
if sxrnd4=1 then rnd1styes=4;
if sxrnd3=1 then rnd1styes=3;
if sxrnd2=1 then rnd1styes=2;
if sxrnd1=1 then rnd1styes=1;
label rnd1styes='Round 1st reported s/he had sex';

eversex1_8=.;
if rnd1styes ge 1 then eversex1_8=1;
else eversex1_8=0;
label eversex1_8='Ever reported sex btwn R1-R8';

if agesxrnd8 ge 0 then age1stsex=agesxrnd8;
if agesxrnd7 ge 0 then age1stsex=agesxrnd7; *'R^s age @ 1st sex Rnd7 answr' ge 0 then ;
if agesxrnd6 ge 0 then age1stsex=agesxrnd6;
if agesxrnd5 ge 0 then age1stsex=agesxrnd5;
if agesxrnd4 ge 0 then age1stsex=agesxrnd4;
if agesxrnd3 ge 0 then age1stsex=agesxrnd3;
if agesxrnd2 ge 0 then age1stsex=agesxrnd2;
if agesxrnd1 ge 0 then age1stsex=agesxrnd1;
if age1stsex=. then do;
  if agesxrnd1 lt 0 and agesxrnd1 gt -4 then age1stsex=agesxrnd1;
  else if agesxrnd2 lt 0 and agesxrnd2 gt -4 then age1stsex=agesxrnd2;
  else if agesxrnd3 lt 0 and agesxrnd3 gt -4 then age1stsex=agesxrnd3;
  else if agesxrnd4 lt 0 and agesxrnd4 gt -4 then age1stsex=agesxrnd4;
  else if agesxrnd5 lt 0 and agesxrnd5 gt -4 then age1stsex=agesxrnd5;
  else if agesxrnd6 lt 0 and agesxrnd6 gt -4 then age1stsex=agesxrnd6;
  else if agesxrnd7 lt 0 and agesxrnd7 gt -4 then age1stsex=agesxrnd7;
  else if agesxrnd8 lt 0 and agesxrnd8 gt -4 then age1stsex=agesxrnd8;
end;
label age1stsex='Age at 1st sex (from R1-R8)';

/**************************************************************************************************
CREATING VARIABLE THAT CHECKS ROUND IN WHICH RESONDENT WAS AGE 16

****************************************************************************************************/

*Creating age16 variable and tracking sexual activity;
************************;

age16=.;*Round in which R was 16;
if 		R1194100=16 then age16=1;*R2553500 age at DLI 1997 etc.;
else if	R2553500=16 then age16=2;*R2553500 age at DLI 1998 etc.;
else if R3876300=16 then age16=3;
else if R5453700=16 then age16=4;
else if R7216000=16 then age16=5;
else if S1531400=16 then age16=6;
else if S2001000=16 then age16=7;
else if S3801100=16 then age16=8;


if age16=. then do;*;
	if R1194100=15 and R2553500=17 then age16=2;
	if R2553500=15 and R3876300=17 then age16=3;
	if R3876300=15 and R5453700=17 then age16=4;
	if R5453700=15 and R7216000=17 then age16=5;
	if R7216000=15 and S1531400=17 then age16=6;
	if S1531400=15 and S2001000=17 then age16=7;
	if S2001000=15 and S3801100=17 then age16=8;

end;

*Creating age17 variable and tracking sexual activity;
************************;
age17=.;*Round in which R was 17;
if 		R1194100=17 then age17=1;*R2553500 age at DLI 1997 etc.;
else if	R2553500=17 then age17=2;*R2553500 age at DLI 1998 etc.;
else if R3876300=17 then age17=3;
else if R5453700=17 then age17=4;
else if R7216000=17 then age17=5;
else if S1531400=17 then age17=6;
else if S2001000=17 then age17=7;
else if S3801100=17 then age17=8;


if age17=. then do;*;
	if R1194100=16 and R2553500=18 then age17=2;
	if R2553500=16 and R3876300=18 then age17=3;
	if R3876300=16 and R5453700=18 then age17=4;
	if R5453700=16 and R7216000=18 then age17=5;
	if R7216000=16 and S1531400=18 then age17=6;
	if S1531400=16 and S2001000=18 then age17=7;
	if S2001000=16 and S3801100=18 then age17=8;

end;

*Creating age18 variable and tracking sexual activity;
************************;
age18=.;*Round in which R was 18;
if 		R1194100=18 then age18=1;*R2553500 age at DLI 1997 etc.;
else if	R2553500=18 then age18=2;*R2553500 age at DLI 1998 etc.;
else if R3876300=18 then age18=3;
else if R5453700=18 then age18=4;
else if R7216000=18 then age18=5;
else if S1531400=18 then age18=6;
else if S2001000=18 then age18=7;
else if S3801100=18 then age18=8;

if age18=. then do;*;
	if R1194100=17 and R2553500=19 then age18=2;
	if R2553500=17 and R3876300=19 then age18=3;
	if R3876300=17 and R5453700=19 then age18=4;
	if R5453700=17 and R7216000=19 then age18=5;
	if R7216000=17 and S1531400=19 then age18=6;
	if S1531400=17 and S2001000=19 then age18=7;
	if S2001000=17 and S3801100=19 then age18=8;

end;

*Creating age19 variable and tracking sexual activity;
************************;
age19=.;*Round in which R was 19;
if 		R1194100=19 then age19=1;*R2553500 age at DLI 1997 etc.;
else if	R2553500=19 then age19=2;*R2553500 age at DLI 1998 etc.;
else if R3876300=19 then age19=3;
else if R5453700=19 then age19=4;
else if R7216000=19 then age19=5;
else if S1531400=19 then age19=6;
else if S2001000=19 then age19=7;
else if S3801100=19 then age19=8;

if age19=. then do;*;
	if R1194100=18 and R2553500=20 then age19=2;
	if R2553500=18 and R3876300=20 then age19=3;
	if R3876300=18 and R5453700=20 then age19=4;
	if R5453700=18 and R7216000=20 then age19=5;
	if R7216000=18 and S1531400=20 then age19=6;
	if S1531400=18 and S2001000=20 then age19=7;
	if S2001000=18 and S3801100=20 then age19=8;

end;

*Creating age20 variable and tracking sexual activity;
************************;
age20=.;*Round in which R was 20;
if 		R1194100=20 then age20=1;*R2553500 age at DLI 1997 etc.;
else if	R2553500=20 then age20=2;*R2553500 age at DLI 1998 etc.;
else if R3876300=20 then age20=3;
else if R5453700=20 then age20=4;
else if R7216000=20 then age20=5;
else if S1531400=20 then age20=6;
else if S2001000=20 then age20=7;
else if S3801100=20 then age20=8;

if age20=. then do;*;
	if R1194100=19 and R2553500=21 then age20=2;
	if R2553500=19 and R3876300=21 then age20=3;
	if R3876300=19 and R5453700=21 then age20=4;
	if R5453700=19 and R7216000=21 then age20=5;
	if R7216000=19 and S1531400=21 then age20=6;
	if S1531400=19 and S2001000=21 then age20=7;
	if S2001000=19 and S3801100=21 then age20=8;

end;

sexbyage16=.; *Respondent reported having sex by age 16;
if rnd1styes le age16 and rnd1styes ~=. then sexbyage16=1;
if rnd1styes gt age16 then sexbyage16=0;
if rnd1styes = . and age16 ~= . then sexbyage16=0;
label sexbyage16='R reported sex by age 16 rnd?';

array sexrnd(8) sxrnd1 sxrnd2 sxrnd3 sxrnd4 sxrnd5 sxrnd6 sxrnd7 sxrnd8;

countsex=0;

do i = 1 to 8 until (i=age16);
if sexrnd(i)=1 then countsex=countsex+1;
else countsex=countsex;
end;

hadsex16=.;
if countsex ge 1 then hadsex16=1;
else hadsex16=0;

array safesexrnd (8) safesex1 safesex2 safesex3 safesex4 safesex5 safesex6 safesex7 safesex8;
array marrstat(8) R1210200 R2569300 R3891300 R5473300 R7237000 S1552200 S2022000 S3822900;
array condom (8) condrate97 condrate98 condrate99 condrate00 condrate01 condrate02 condrate03 condrate04;
array numpart (8) numparttot97 numparttot98 numparttot99 numparttot00 numparttot01 numparttot02 numparttot03 numparttot04; 

if hadsex16=1 then do;
do i =1 to 8 until (i=age16);
	if sexrnd(i)=0 then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and (numpart(i) in (-4, -3, 0, 1)) then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and numpart(i) gt 1 then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
	else if (marrstat(i) in (2,6,8,10)) or (marrstat(i) lt 0) then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
end;
end;

countunsafe=0;
misscount=0;
count=0;

do i =1 to 8 until (i=age16);
if safesexrnd(i)=0 then countunsafe=countunsafe+1;
else countunsafe=countunsafe;

if safesexrnd(i)=. then misscount=misscount+1;
else misscount=misscount;
count=count+1;
end;

if hadsex16=0 then finalsafe=1;
else if hadsex16=1 then do;
	if misscount=age16 then finalsafe=.;
	else if countunsafe=0 then finalsafe=1;
	else if countunsafe ge 1 then finalsafe=0;
end;
label finalsafe = 'respondent practiced safe sex or abstinence every year age 14 to 16'

/***************determine whether r had sex in age 17 to 20**************/

countsex17=0;
countmiss17=0;

if age17=. then countsex17=.;
do i = 1 to 8;
if i = age17 then do;
if sexrnd(i)=1 then countsex17=countsex17+1;
else countsex17=countsex17;
if sexrnd(i)=. then countmiss17=1;
end;
end; 

countsex18=0;
countmiss18=0;

if age18=. then countsex18=.;
do i = 1 to 8;
if i = age18 then do;
if sexrnd(i)=1 then countsex18=countsex18+1;
else countsex18=countsex18;
if sexrnd(i)=. then countmiss18=1;
end;
end; 

countsex19=0;
countmiss19=0;

if age19=. then countsex19=.;
do i = 1 to 8;
if i = age19 then do;
if sexrnd(i)=1 then countsex19=countsex19+1;
else countsex19=countsex19;
if sexrnd(i)=. then countmiss19=1;
end;
end; 

countsex20=0;
countmiss20=0;
if age20=. then countsex20=.;
do i = 1 to 8;
if i = age20 then do;
if sexrnd(i)=1 then countsex20=countsex20+1;
else countsex20=countsex20;
if sexrnd(i)=. then countmiss20=1;
end;
end; 

summiss= sum(countmiss17, countmiss18, countmiss19, countmiss20);

hadsex20=.;
sexsum = sum (countsex17, countsex18, countsex19, countsex20);
if sexsum ge 1 then hadsex20=1;
else if summiss gt 1 then hadsex20=.;
else if sexsum =0 then hadsex20=0;
else if sexsum=. then hadsex20=.;

/***************determine whether sex was safe from age 17 to 20****************/

if hadsex20=1 then do;
do i = 1 to 8;
if i = age17 then do;
	if sexrnd(i)=0 then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and (numpart(i) in (-4, -3, 0, 1)) then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and numpart(i) gt 1 then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
	else if (marrstat(i) in (2,6,8,10)) or (marrstat(i) lt 0) then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
	end;
end;
end;

if hadsex20=1 then do;
do i = 1 to 8;
if i = age18 then do;
	if sexrnd(i)=0 then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and (numpart(i) in (-4, -3, 0, 1)) then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and numpart(i) gt 1 then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
	else if (marrstat(i) in (2,6,8,10)) or (marrstat(i) lt 0) then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
end;
end;
end;

if hadsex20=1 then do;
do i = 1 to 8;
if i = age19 then do;
	if sexrnd(i)=0 then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and (numpart(i) in (-4, -3, 0, 1)) then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and numpart(i) gt 1 then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
	else if (marrstat(i) in (2,6,8,10)) or (marrstat(i) lt 0) then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
end;
end;
end;

if hadsex20=1 then do;
do i = 1 to 8;
if i= age20 then do;
	if sexrnd(i)=0 then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and (numpart(i) in (-4, -3, 0, 1)) then safesexrnd(i)=1;
	else if (marrstat(i) in (1,3,4,5,7,9)) and numpart(i) gt 1 then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
	else if (marrstat(i) in (2,6,8,10)) or (marrstat(i) lt 0) then do;
		if condom(i)=100 then safesexrnd(i)=1;
		else if condom(i)=. then safesexrnd(i)=.;
		else if condom(i) ne 100 then safesexrnd(i)=0;
	end;
end;
end;
end;

/*************determine whether person had safe or unsafe sex from age 17 to age 20*********/

countunsafe17=0;
misscount17=0;
count17=0;
if age17=. then countunsafe17=.; /*********new change*****/
if age17=. then misscount17=1;
do i = 1 to 8;
if i= age17 then do;
if safesexrnd(i)=0 then countunsafe17=countunsafe17+1;
else if safesexrnd(i) =1 then countunsafe17=countunsafe17;
else if safesexrnd(i)=. then countunsafe17=.;

if safesexrnd(i) lt 0 then misscount17=misscount17+1;
else if safesexrnd(i) ge 0 then misscount17=misscount17;
count17=count17+1;
end;
end;

countunsafe18=0;
misscount18=0;
count18=0;
if age18=. then countunsafe18=.;
if age18=. then misscount18=1;
do i = 1 to 8;
if i= age18 then do;
if safesexrnd(i)=0 then countunsafe18=countunsafe18+1;
else if safesexrnd(i) =1 then countunsafe18=countunsafe18;
else if safesexrnd(i)=. then countunsafe18=.;

if safesexrnd(i) lt 0 then misscount18=misscount18+1;
else if safesexrnd(i) ge 0 then misscount18=misscount18;
count18=count18+1;
end;
end;

countunsafe19=0;
misscount19=0;
count19=0;
if age19=. then countunsafe19=.; /*********new change*****/
if age19=. then misscount19=1;
do i = 1 to 8;
if i= age19 then do;
if safesexrnd(i)=0 then countunsafe19=countunsafe19+1;
else if safesexrnd(i) =1 then countunsafe19=countunsafe19;
else if safesexrnd(i)=. then countunsafe19=.;

if safesexrnd(i) lt 0 then misscount19=misscount19+1;
else if safesexrnd(i) ge 0 then misscount19=misscount19;
count19=count19+1;
end;
end;

countunsafe20=0;
misscount20=0;
count20=0;
if age20=. then countunsafe20=.;
if age20=. then misscount20=1;
do i = 1 to 8;
if i = age20 then do;
if safesexrnd(i)=0 then countunsafe20=countunsafe20+1;
else if safesexrnd(i) =1 then countunsafe20=countunsafe20;
else if safesexrnd(i)=. then countunsafe20=.;

if safesexrnd(i) lt 0 then misscount20=misscount20+1;
else if safesexrnd(i) ge 0 then misscount20=misscount20;
count20=count20+1;

end;
end;

misssum= sum (misscount17, misscount18, misscount19, misscount20);

unsafe1620=.;
unsafesum = sum (countunsafe17, countunsafe18, countunsafe19, countunsafe20);
if countunsafe17 =1 or countunsafe18 =1 or countunsafe19 =1 or countunsafe20=1 then unsafe1620=1;
else if misssum gt 1 then unsafe1620=.;
else if unsafesum=0 then unsafe1620=0;



/************safe sex from age 17 to 20**********/

if hadsex20=0 then finalsafe20=1;
else if hadsex20=. then finalsafe20=.;
else if hadsex20=1 then do;
	if misssum=4 then finalsafe20=.;
	else if misssum ge 1 then do;	
		if unsafe1620=1 then finalsafe20=0;
		if unsafe1620=0 then finalsafe20=1;
		if unsafe1620=. then finalsafe20=.;
	end;
	else if misssum=0 then do;
		if unsafe1620=1 then finalsafe20=0;
		if unsafe1620=0 then finalsafe20=1;
		if unsafe1620=. then finalsafe20=.;
	end;
end;
label finalsafe20 = 'respondent practiced safe sex or abstinence every year age 17 to 20'

/*****parent relgiosity 1997*****/
prelval=1-R0624400;		/****dont need religion to have good values****/
prelobey=R0624900;		/****religion should be obeyed exactly as written***/
preldec=R0625000;		/****ask god to make decisions****/
prelnoth=1-R0625100;		/****god has nothing to do with what happens personally***/
prelpray=R0625200;		/****pray more than once a day***/

array pre{5} prelval prelobey preldec prelnoth prelpray;
prelm=0;
    do i= 1 to 5;
      if pre{i}=. then prelm=prelm+1;
    end;
       if prelm le 1 then do;
        prelig02 = sum (prelval, prelobey, preldec, prelnoth, prelpray)*(5/(5-prelm));
        end;
label prelig02 = '5-item scale of parent religiosity, 5 point scale, 1997';

prelatt=R0552400;
label prelatt = 'how often parent attended a worship service in past 12 months';
Format prelatt prelig.;

relatt97=R0323900;
label relatt97 = 'how many days per week family does something religious together';

/***********lies or cheats************/

cheat=R0356500;
if cheat<0 then cheat=R0357100;
if cheat<0 then cheat=R0690500;
if cheat<0 then cheat=R0691000;
if cheat<0 then cheat=.;
label cheat = 'parent and youth report of youth cheating or lying';
format cheat chea.;

PRcheat=R0690500;
if PRcheat<0 then PRcheat=R0691000;
if PRcheat<0 then PRcheat=.;
label PRcheat = 'parent report of youth cheating or lying';
format PRcheat chea.;

YRcheat=R0356500;
if YRcheat<0 then YRcheat=R0357100;
if YRcheat<0 then YRcheat=.;
label YRcheat = 'youth report of youth cheating or lying';
format YRcheat chea.;

/*estranged parents relationship*/
biospoke=R3498200;
mombeh=R3498300;
dadbeh=R3498400;

label biospoke = "# TIMES BIO PARS SPOKE LAST YR? 1999";
label mombeh = "BEHAVIOR BIO MOTH TO BIO FATH 1999";
label dadbeh = "BEHAVIOR BIO FATH TO BIO MOTH 1999";
format mombeh mombeh.;
format dadbeh dadbeh.;

/*DUMMY MACRO*/
%macro dummy(oldvar, newdums);
array dum_&oldvar(*) &newdums;
do i=1 to dim(dum_&oldvar);
if &oldvar=i then do;
dum_&oldvar(i)=1;
end;
else if &oldvar ne . then dum_&oldvar(i)=0;
end;
%mend;

/**********age***********/
y_age= R0536600;
label y_age='age of youth respondent';
format y_age age.;

/****Sex****/
sex=.;
if R0536300=1 then sex=1;
if R0536300=2 then sex=2;
label sex='sex of respondent male=1 female=2';

/*****race/ethnicity*****/
if R0538600 = 0 and R0538700 = . then race = 0;  /* No information */
if R0538600 = . and R0538700 = . then race = 0;  /* No information */
if R0538600 = 0 and R0538700 = 1 then race = 1;  /* Non Hispanic White */
if R0538600 = . and R0538700 = 1 then race = 1;  /* Non Hispanic White */
if R0538600 = 0 and R0538700 = 2 then race = 2; /* Non Hispanic Black */
if R0538600 = . and R0538700 = 2 then race = 2; /* Non Hispanic Black */
if R0538600 = 0 and R0538700 = 3 then race = 4;  /* Non Hispanic American Indian */
if R0538600 = . and R0538700 = 3 then race = 4;  /* Non Hispanic American Indian */
if R0538600 = 0 and R0538700 = 4 then race = 5;  /* Non Hispanic Asian */
if R0538600 = . and R0538700 = 4 then race = 5;  /* Non Hispanic Asian */
if R0538600 = 0 and R0538700 = 5 then race = 6;  /* Non Hispanic Other */
if R0538600 = . and R0538700 = 5 then race = 6;  /* Non Hispanic Other */
if R0538600 = 1 then race = 3;  /* Hispanic */
format race raceth.;
label race='race/ethnicity of respondent white=1 black=2 Hispanic=3 American Indian=4 Asian=5 Other=6';
%dummy (race, white black hispanic natvamer asian other);

/***********household income R1204500    *************/
income=R1204500;

/*data gdrive.pov;
/*set work.temp8;
/***************ratio of household income to poverty level R1204900  ***************************/
poverty=.;
if 0 <= R1204900 < 100 then poverty = 1;
if 100 <= R1204900 < 200 then poverty = 2;
if 200 <= R1204900 < 400 then poverty = 3;
if 400 <= R1204900 then poverty = 4;
if R1204900 < 0  then poverty = .;        
label poverty = 'hh poverty level, missing = .';
format poverty pov4cat.;

povlt100=0;
if poverty=1 then povlt100=1;
if poverty ne 1 then povlt100=0;
label povlt100 = 'hh poverty level <100%';

povlt200=0;
if poverty=2 then povlt200=1;
if poverty ne 2 then povlt200=0;
label povlt200 = 'hh poverty level 100% 199%';

povlt400=0;
if poverty=3 then povlt400=1;
if poverty ne 3 then povlt400=0;
label povlt400 = 'hh poverty level 200% 399%';

povgt400=0;
if poverty=4 then povgt400=1;
if poverty ne 4 then povgt400=0;
label povgt400 = 'hh poverty level 400+ %';

povmiss=0;
if poverty=. then povmiss=1;
if poverty ne . then povmiss=0;
label povmiss = 'hh poverty level missing';

/**********parent education***********/
if R1302700 in (95) THEN pared=.;
else pared= R1302700;
label pared='residential mothers highest grade completed';
format pared resmomed.;

/*************Parents Marital status ***********************************/;

marstat = .;
nummar = .;
If nummar = . then marstat = 0;
if nummar = 1 and R0567300 = 1 then marstat = 1; /***one continuous marriage**/;
if nummar = 1 and R0567300 = 0 then marstat = 0; /***one discontinued marriage**/; 
if nummar = 2 and R0567400 = 1 then marstat = 1; /***second continuous marriage**/;
if nummar = 2 and R0567400 = 0 then marstat = 0; /***second discontinued marriage**/;
if nummar = 3 and R0567500 = 1 then marstat = 1; /***third continuous marriage**/;
if nummar = 3 and R0567500 = 0 then marstat = 0; /***third discontinued marriage**/;
if nummar = 4 and R0567600 = 1 then marstat = 1; /***fourth continuous marriage**/;
if nummar = 4 and R0567600 = 0 then marstat = 0; /***fourth discontinued marriage**/;
if nummar = 5 and R0567700 = 1 then marstat = 1; /***fifth continuous marriage**/;
if nummar = 5 and R0567700 = 0 then marstat = 0; /***fifth discontinued marriage**/;
if nummar = 6 and R0567800 = 1 then marstat = 1; /***sixth continuous marriage**/;
if nummar = 6 and R0567800 = 0 then marstat = 0; /***sixth discontinued marriage**/;
label marstat = 'current marital status Parent Survey';
format marstat msta.;

marstat2 = .;
if R0567300 = 1 or R0567400 = 1 or R0567500 = 1 or R0567600 = 1 or
R0567700 = 1 or R0567800 = 1 then marstat2 = 1;
else marstat2 = 0;
label marstat2 = 'current marital status 2 Parent Survey';
format marstat2 yes10no.;

/*********parent respondent relationship to youth****/
RESPPARENT=.;
IF R0535300 IN (1,3,5,7,9,11,17,19) THEN RESPPARENT=1;
IF R0535300 IN (2,4,6,8,9,10,18) THEN RESPPARENT=2;


/***************************************************************************************/
/********************************Marital status from HH roster*************************/;

respms = .;
if r0735000 = 1 then respms = r0704600;
if r0735000 = 2 then respms = r0704700;
if r0735000 = 3 then respms = r0704800;
if r0735000 = 4 then respms = r0704900;
if r0735000 = 5 then respms = r0705000;
if r0735000 = 6 then respms = r0705100;
if r0735000 = 7 then respms = r0705200;
if r0735000 = 8 then respms = r0705300;
if r0735000 = 9 then respms = r0705400;
label respms = 'resp parents marital status from HH roster';
format respms rems.;

*****CORRECTING FOR RESPONDING PARENTS WHO STATE THE ROSTER INFORMANT GOT THEIR MARITAL STATUS INCORRECT*;

IF R0542500=1 /*Marital status on HH roster not correct*/ then respms =R0542600;
IF R0542500=1 /*Marital status on HH roster not correct*/ then HHMARINC=1; /*variable
indicating how many people's marital status was incorrect in hh roster*/

respms2c = .;
if respms = 1 then respms2c = 1;
if respms in (0, 2, 3, 4) then respms2c = 0;
if respms = . then respms2c = marstat2;
label respms2c = 'resp marital status cat HH roster';
format respms2c msta.;

/**************FAMILY PROCESS VARIABLES--- PARENT-CHILD RELATIONSHIP YOUTH REPORT *********************/
/***** 1997 8-ITEM SCALE FOR MOTHER, W/NEGATIVE P-Y BEHAVIOR REVERSE-CODED**********/;

/*reverse code*/
R032480R = 4-R0324800;
R032500R = 4-R0325000;
R032510R = 4-R0325100;

label R032480R ='MOM CRITICIZES Y IDEAS, REVERSE-CODED97';
label R032500R ='MOM BLAMES Y FOR PROBL, REVERSE-CODED97';
label R032510R ='MOM CANCELS PLANS, REVERSE-CODED97';

Array supt697{8} R0324700 R032480R R0324900 R032500R R032510R R0324400 R0324500 R0324600;

/*remove missings*/
mis8supt97=0;
    do a= 1 to 8;
      if supt697{a}=. then mis8supt97=mis8supt97+1;
    end;
       if mis8supt97 le 2 then do;
        YMREL97 = sum (R0324700, R032480R, R0324900, R032500R, R032510R, R0324400,
                         R0324500, R0324600)*(8/(8-mis8supt97));
        end;

ym897miss=.;
if YMREL97 =. then ym897miss = 1;
else ym897miss= 0;
label ym897miss= 'Missing for 8-Item M-Y 97 Rel Scale';
	  	
label YMREL97 ='8-Item Mom-Y Relationship Scale 1997';

/*relationship scale - >24 positive, <24 not positive*/
YMPOSREL97 = .;
if YMREL97 ge 24 then YMPOSREL97 = 1;
if YMREL97 ge 0 and YMREL97 lt 24 then YMPOSREL97 = 0;
label YMPOSREL97 = '1997 Y has positive relationship w/Mom (GE 24 on 8-item Scale)';

/********************************************************************************/
/************************1997 7 item scale mother-youth relationship************/
/*******************************************************************************/

/*reverse code*/
R032480R = 4-R0324800;
R032500R = 4-R0325000;

label R032480R ='MOM CRITICIZES Y IDEAS, REVERSE-CODED97';
label R032500R ='MOM BLAMES Y FOR PROBL, REVERSE-CODED97';

Array supt797{7} R0324700 R032480R R0324900 R032500R R0324400 R0324500 R0324600;

/*remove missings*/
mis7supt97=0;
    do a= 1 to 7;
      if supt797{a}=. then mis7supt97=mis7supt97+1;
    end;
       if mis7supt97 le 1 then do;
        YMREL797 = sum (R0324700, R032480R, R0324900, R032500R, R0324400,
                         R0324500, R0324600)*(7/(7-mis7supt97));
        end;

ym797miss=.;
if YMREL797 =. then ym797miss = 1;
else ym797miss= 0;
label ym797miss= 'Missing for 7-Item M-Y 97 Rel Scale';
	  	
label YMREL797 ='7-Item Mom-Y Relationship Scale 1997';

/*relationship scale - >21 positive, <21 not positive*/
POSYM97 = .;
if YMREL797 ge 21 then POSYM97 = 1;
if YMREL797 ge 0 and YMREL797 lt 21 then POSYM97 = 0;
label POSYM97 = '1997 Y has positive relationship w/Mom (GE 21 on 7-item Scale)';

/************** 1997 3-ITEM SCALE FOR MOTHER*********/
Array mom3_97{3} R0324400 R0324500 R0324600;

/*remove missings*/
missmom3_97=0;
    do a= 1 to 3;
      if mom3_97{a}=. then missmom3_97=missmom3_97+1;
    end;
       if missmom3_97 = 0 then do;
        ymomrel3_97 = sum (R0324400, R0324500, R0324600);
        end;
label ymomrel3_97= '1997 Y relationship w/Mom, 3 ITEM';

/***** 1998 8-ITEM SCALE FOR MOTHER, W/NEGATIVE P-Y BEHAVIOR REVERSE-CODED**********/;

/*reverse code*/
R216580R = 4-R2165800;
R216600R = 4-R2166000;
R216610R = 4-R2166100;

label R216580R ='MOM CRITICIZES Y IDEAS, REVERSE-CODED98';
label R216600R ='MOM BLAMES Y FOR PROBL, REVERSE-CODED98';
label R216610R ='MOM CANCELS PLANS, REVERSE-CODED98';

Array supt698{8} R2165400 R216580R R2165500 R216600R R216610R R2165600 R2165700 R2165900;

/* remove missings*/
mis8supt98=0;
    do a= 1 to 8;
      if supt698{a}=. then mis8supt98=mis8supt98+1;
    end;
       if mis8supt98 le 2 then do;
        YMREL98 = sum (R2165400, R216580R, R2165500, R216600R, R216610R, 
                   R2165600, R2165700, R2165900)*(8/(8-mis8supt98));
        end;

label YMREL98  ='8-Item Mom-Y Relationship Scale 1998';

/*relationship scale >24>*/
YMPOSREL98 = .;
if YMREL98  ge 24 then YMPOSREL98 = 1;
if YMREL98  ge 0 and YMREL98  lt 24 then YMPOSREL98 = 0;
label YMPOSREL98 = '1998 Y has positive relationship w/Mom (GE 24 on 8-item Scale)';

/********************************************************************************/
/************************1998 7 item scale mother-youth relationship************/
/*******************************************************************************/

/*reverse code*/
R216580R = 4-R2165800;
R216600R = 4-R2166000;

label R216580R ='MOM CRITICIZES Y IDEAS, REVERSE-CODED98';
label R216600R ='MOM BLAMES Y FOR PROBL, REVERSE-CODED98';

Array supt798{7} R2165400 R216580R R2165500 R216600R R2165600 R2165700 R2165900;

/* remove missings*/
mis7supt98=0;
    do a= 1 to 7;
      if supt798{a}=. then mis7supt98=mis7supt98+1;
    end;
       if mis7supt98 le 1 then do;
        YMREL798 = sum (R2165400, R216580R, R2165500, R216600R,
                   R2165600, R2165700, R2165900)*(7/(7-mis7supt98));
        end;

label YMREL798  ='7-Item Mom-Y Relationship Scale 1998';

/*relationship scale >21>*/
POSYM98 = .;
if YMREL798  ge 21 then POSYM98 = 1;
if YMREL798  ge 0 and YMREL798  lt 21 then POSYM98 = 0;
label POSYM98 = '1998 Y has positive relationship w/Mom (GE 21 on 7-item Scale)';

/************** 1998 3-ITEM SCALE FOR MOTHER*********/
Array mom3_98{3} R2165400 R2165500 R2165600;

/*remove missings*/
missmom3_98=0;
    do a= 1 to 3;
      if mom3_98{a}=. then missmom3_98=missmom3_98+1;
    end;
       if missmom3_98 = 0 then do;
        ymomrel3_98 = sum (R2165400, R2165500, R2165600);
        end;
label ymomrel3_98= '1998 Y relationship w/Mom, 3 ITEM';

/***** 1999 8-ITEM SCALE FOR MOTHER, W/NEGATIVE P-Y BEHAVIOR REVERSE-CODED**********/;

/*reverse code*/
R348370R = 4-R3483700;
R348390R = 4-R3483900;
R348400R = 4-R3484000;

label R348370R ='MOM CRITICIZES Y IDEAS, REVERSE-CODED99';
label R348390R ='MOM BLAMES Y FOR PROBL, REVERSE-CODED99';
label R348400R ='MOM CANCELS PLANS, REVERSE-CODED99';

Array supt699{8} R348370R R348400R R348390R R3483800 R3483600 R3483300 R3483400 R3483500;

/*remove missings*/
mis8supt99=0;
    do a= 1 to 8;
      if supt699{a}=. then mis8supt99=mis8supt99+1;
    end;
       if mis8supt99 le 2 then do;
        YMREL99 = sum (R348370R, R348400R, R348390R, R3483800, R3483600, R3483300, R3483400,
                       R3483500)*(8/(8-mis8supt99));
        end;

label YMREL99 ='8-Item Mom-Y Relationship Scale 1999';

/* relationship scale >24>*/
YMPOSREL98 = .;
if YMREL99 ge 24 then YMPOSREL98 = 1;
if YMREL99 ge 0 and YMREL99 lt 24 then YMPOSREL98 = 0;
label YMPOSREL98 = '1999 Y has positive relationship w/Mom (GE 24 on 8-item Scale)';

/********************************************************************************/
/************************1999 7 item scale mother-youth relationship************/
/*******************************************************************************/

/*reverse code*/
R348370R = 4-R3483700;
R348390R = 4-R3483900;

label R348370R ='MOM CRITICIZES Y IDEAS, REVERSE-CODED99';
label R348390R ='MOM BLAMES Y FOR PROBL, REVERSE-CODED99';

Array supt799{7} R348370R R348390R R3483800 R3483600 R3483300 R3483400 R3483500;

/*remove missings*/
mis7supt99=0;
    do a= 1 to 7;
      if supt799{a}=. then mis7supt99=mis7supt99+1;
    end;
       if mis7supt99 le 1 then do;
        YMREL799 = sum (R348370R, R348390R, R3483800, R3483600, R3483300, R3483400,
                       R3483500)*(7/(7-mis7supt99));
        end;

label YMREL799 ='7-Item Mom-Y Relationship Scale 1999';

/* relationship scale >21>*/
POSYM99 = .;
if YMREL799 ge 21 then POSYM99 = 1;
if YMREL799 ge 0 and YMREL799 lt 21 then POSYM99 = 0;
label POSYM99 = '1999 Y has positive relationship w/Mom (GE 21 on 7-item Scale)';

/************** 1999 3-ITEM SCALE FOR MOTHER*********/
Array mom3_99{3} R3483300 R3483400 R3483500;

/*remove missings*/
missmom3_99=0;
    do a= 1 to 3;
      if mom3_99{a}=. then missmom3_99=missmom3_99+1;
    end;
       if missmom3_99 = 0 then do;
        ymomrel3_99 = sum (R3483300, R3483400, R3483500);
        end;

label ymomrel3_99= '1999 Y relationship w/Mom, 3 ITEM';

/***** 1997 8-ITEM SCALE FOR FATHER, W/NEGATIVE P-Y BEHAVIOR REVERSE-CODED**********/;

/*reverse code*/
R032660R = 4-R0326600;
R032680R = 4-R0326800;
R032690R = 4-R0326900;

label R032660R ='DAD CRITICIZES Y IDEAS, REVERSE-CODED97';
label R032680R ='DAD BLAMES Y FOR PROBL, REVERSE-CODED97';
label R032690R ='DAD CANCELS PLANS, REVERSE-CODED97';

Array supt897{8} R0326500 R032660R R0326700 R032680R R032690R R0326200 R0326300 R0326400;

/*remove missings*/
mis8fathy97=0;
    do a= 1 to 8;
      if supt897{a}=. then mis8fathy97=mis8fathy97+1;
    end;
       if mis8fathy97 le 2 then do;
        YDREL97 = sum (R0326500, R032660R, R0326700, R032680R, R032690R, R0326200,
                         R0326300, R0326400)*(8/(8-mis8fathy97));
        end;

/*relationship scale >24>*/
yf897miss=.;
if YDREL97 =. then yf897miss = 1;
else yf897miss = 0;
label yf897miss = 'Missing for 8-Item D-Y 97 Rel Scale';

YDPOSREL97 = .;
if YDREL97 ge 24 then YDPOSREL97 = 1;
if YDREL97 ge 0 and YDREL97 lt 24 then YDPOSREL97 = 0;
label YDPOSREL97 = '1997 Y has positive relationship w/Dad (GE 24 on 8-item Scale)';

/********************************************************************************/
/************************1997 7 item scale father-youth relationship************/
/*******************************************************************************/

/*reverse code*/
R032660R = 4-R0326600;
R032680R = 4-R0326800;

label R032660R ='DAD CRITICIZES Y IDEAS, REVERSE-CODED97';
label R032680R ='DAD BLAMES Y FOR PROBL, REVERSE-CODED97';

Array suptf797{7} R0326500 R032660R R0326700 R032680R R0326200 R0326300 R0326400;

/*remove missings*/
mis7fathy97=0;
    do a= 1 to 7;
      if suptf797{a}=. then mis7fathy97=mis7fathy97+1;
    end;
       if mis7fathy97 le 1 then do;
        YDREL797 = sum (R0326500, R032660R, R0326700, R032680R, R0326200,
                         R0326300, R0326400)*(7/(7-mis7fathy97));
        end;

/*relationship scale >21>*/
yf797miss=.;
if YDREL797 =. then yf797miss = 1;
else yf797miss = 0;
label yf797miss = 'Missing for 7-Item D-Y 97 Rel Scale';

POSYD97 = .;
if YDREL797 ge 21 then POSYD97 = 1;
if YDREL797 ge 0 and YDREL797 lt 21 then POSYD97 = 0;
label POSYD97 = '1997 Y has positive relationship w/Dad (GE 21 on 7-item Scale)';

/************** 1997 3-ITEM SCALE FOR FaTHER*********/
Array dad3_97{3} R0326200 R0326300 R0326400;

/*remove missings*/
missdad3_97=0;
    do a= 1 to 3;
      if dad3_97{a}=. then missdad3_97=missdad3_97+1;
    end;
       if missdad3_97 = 0 then do;
        ydadrel3_97 = sum (R0326200, R0326300, R0326400);
        end;

label  ydadrel3_97 = '1997 Y relationship w/Dad -- 3 ITEM';

/***** 1998 8-ITEM SCALE FOR FATHER, W/NEGATIVE P-Y BEHAVIOR REVERSE-CODED**********/;

/*reverse code*/
R216740R = 4-R2167400;
R216760R = 4-R2167600;
R216770R = 4-R2167700;

label R216740R ='DAD CRITICIZES Y IDEAS, REVERSE-CODED98';
label R216760R ='DAD BLAMES Y FOR PROBL, REVERSE-CODED98';
label R216770R ='DAD CANCELS PLANS, REVERSE-CODED98';

Array supt898{8} R216740R R216760R R216770R R2167300  R2167500 R2167000 R2167100  R2167200 ;

/*remove missings*/
mis8fathy98=0;
    do a= 1 to 8;
      if supt898{a}=. then mis8fathy98=mis8fathy98+1;
    end;
       if mis8fathy98 le 2 then do;
        YDREL98 = sum (R216740R, R216760R, R216770R, R2167300, R2167500, R2167000, R2167100,
                       R2167200)*(8/(8-mis8fathy98));
        end;

label YDREL98 ='8-Item Dad-Y Relationship Scale 1998';

/* relationship scale >24>*/
YDPOSREL98 = .;
if YDREL98 ge 24 then YDPOSREL98 = 1;
if YDREL98 ge 0 and YDREL98 lt 24 then YDPOSREL98 = 0;
label YDPOSREL98 = '1998 Y has positive relationship w/Dad (GE 24 on 8-item Scale)';

/********************************************************************************/
/************************1998 7 item scale father-youth relationship************/
/*******************************************************************************/

/*reverse code*/
R216740R = 4-R2167400;
R216760R = 4-R2167600;

label R216740R ='DAD CRITICIZES Y IDEAS, REVERSE-CODED98';
label R216760R ='DAD BLAMES Y FOR PROBL, REVERSE-CODED98';

Array suptf798{7} R216740R R216760R R2167300  R2167500 R2167000 R2167100  R2167200 ;

/*remove missings*/
mis7fathy98=0;
    do a= 1 to 7;
      if suptf798{a}=. then mis7fathy98=mis7fathy98+1;
    end;
       if mis7fathy98 le 1 then do;
        YDREL798 = sum (R216740R, R216760R, R2167300, R2167500, R2167000, R2167100,
                       R2167200)*(7/(7-mis7fathy98));
        end;

label YDREL798 ='7-Item Dad-Y Relationship Scale 1998';

/* relationship scale >21>*/
POSYD98 = .;
if YDREL798 ge 21 then POSYD98 = 1;
if YDREL798 ge 0 and YDREL798 lt 21 then YDPOSREL98 = 0;
label POSYD98 = '1998 Y has positive relationship w/Dad (GE 21 on 7-item Scale)';

/************** 1998 3-ITEM SCALE FOR faTHER*********/
Array dad3_98{3} R2167000 R2167100 R2167200;

/*remove missings*/
missdad3_98=0;
    do a= 1 to 3;
      if dad3_98{a}=. then missdad3_98=missdad3_98+1;
    end;
       if missdad3_98 = 0 then do;
        ydadrel3_98 = sum (R2167000, R2167100, R2167200);
        end;

label  ydadrel3_98 = '1998 Y relationship w/Dad -- 3 ITEM';

/***** 1999 8-ITEM SCALE FOR FATHER, W/NEGATIVE P-Y BEHAVIOR REVERSE-CODED**********/;

/*reverse code*/
R348530R = 4-R3485300;
R348550R = 4-R3485500;
R348560R = 4-R3485600;

label R348530R ='DAD CRITICIZES Y IDEAS, REVERSE-CODED99';
label R348550R ='DAD BLAMES Y FOR PROBL, REVERSE-CODED99';
label R348560R ='DAD CANCELS PLANS, REVERSE-CODED99';

Array supt899{8} R348530R R348550R R348560R R3485200 R3485400 R3484900 R3485000 R3485100;

/*remove missings*/
mis8fathy99=0;
    do a= 1 to 8;
      if supt899{a}=. then mis8fathy99=mis8fathy99+1;
    end;
       if mis8fathy99 le 2 then do;
        YDREL99 = sum (R348530R, R348550R, R348560R, R3485200, R3485400, R3484900,
                       R3485000, R3485100)*(8/(8-mis8fathy99));
        end;

label YDREL99 ='8-Item Dad-Y Relationship Scale 1999';

/*relationship scale >24>*/
YDPOSREL99 = .;
if YDREL99 ge 24 then YDPOSREL99 = 1;
if YDREL99 ge 0 and YDREL99 lt 24 then YDPOSREL99 = 0;
label YDPOSREL99 = '1999 Y has positive relationship w/Dad (GE 24 on 8-item Scale)';

/********************************************************************************/
/************************1999 7 item scale father-youth relationship************/
/*******************************************************************************/

/*reverse code*/
R348530R = 4-R3485300;
R348550R = 4-R3485500;

label R348530R ='DAD CRITICIZES Y IDEAS, REVERSE-CODED99';
label R348550R ='DAD BLAMES Y FOR PROBL, REVERSE-CODED99';

Array suptf799{7} R348530R R348550R R3485200 R3485400 R3484900 R3485000 R3485100;

/*remove missings*/
mis7fathy99=0;
    do a= 1 to 7;
      if suptf799{a}=. then mis7fathy99=mis7fathy99+1;
    end;
       if mis7fathy99 le 1 then do;
        YDREL799 = sum (R348530R, R348550R, R3485200, R3485400, R3484900,
                       R3485000, R3485100)*(7/(7-mis7fathy99));
        end;

label YDREL799 ='7-Item Dad-Y Relationship Scale 1999';

/*relationship scale >21>*/
POSYD99 = .;
if YDREL799 ge 21 then POSYD99 = 1;
if YDREL799 ge 0 and YDREL799 lt 21 then POSYD99 = 0;
label POSYD99 = '1999 Y has positive relationship w/Dad (GE 21 on 7-item Scale)';

/************** 1999 3-ITEM SCALE FOR FATHER*********/
Array dad3_99{3} RR3484900 R3485000 R3485100;

/*remove missings*/
missdad3_99=0;
    do a= 1 to 3;
      if dad3_99{a}=. then missdad3_99=missdad3_99+1;
    end;
       if missdad3_99 = 0 then do;
        ydadrel3_99 = sum (RR3484900,R3485000,R3485100);
        end;
label  ydadrel3_99 = '1999 Y relationship w/Dad -- 3 ITEM';

/******1997 youth report of mother rel with father******/

/*reverse code*/
R034590R = 4-R0345900;
R034610R = 4-R0346100;
R034630R = 4-R0346300;

label R034590R ='MOTH SCREAM AT FATH WHEN ANGRY, REVERSE-CODED97';
label R034610R ='MOTH INSULT/CRITICIZE FATH, REVERSE-CODED97';
label R034630R ='MOTH BLAME FATH FOR PROBS, REVERSE-CODED97';

Array mf97{6} R034590R R034610R R034630R R0345800 R0346000 R0346200;

/*remove missings*/
mismf97=0;
    do a= 1 to 6;
      if mf97{a}=. then mismf97=mismf97+1;
    end;
       if mismf97 le 1 then do;
        MMARQ97 = sum (R034590R, R034610R, R034630R, R0345800, R0346000, R0346200)*(6/(6-mismf97));
        end;

label MMARQ97 ='6-Item Mother-Father Relationship Scale 1997';

/*relationship scale >18>*/
POSMMQ97 = .;
if MMARQ97 ge 18 then POSMMQ97 = 1;
if MMARQ97 ge 0 and MMARQ97 lt 18 then POSMMQ97 = 0;
label POSMMQ97 = '1997 Mom has pos rel w/ Dad (GE 18, 6-item Scale)-- youth report';

/******1998 youth report of mother rel with father******/

/*reverse code*/
R217850R = 4-R2178500;
R217870R = 4-R2178700;
R217890R = 4-R2178900;

label R217850R ='MOTH SCREAM AT FATH WHEN ANGRY, REVERSE-CODED98';
label R217870R ='MOTH INSULT/CRITICIZE FATH, REVERSE-CODED98';
label R217890R ='MOTH BLAME FATH FOR PROBS, REVERSE-CODED98';

Array mf98{6} R217850R R217870R R217890R R2178400 R2178600 R2178800;

/*remove missings*/
mismf98=0;
    do a= 1 to 6;
      if mf98{a}=. then mismf98=mismf98+1;
    end;
       if mismf98 le 1 then do;
        MMARQ98 = sum (R217850R, R217870R, R217890R, R2178400, R2178600, R2178800)*(6/(6-mismf98));
        end;

label MMARQ98 ='6-Item Mother-Father Relationship Scale 1998';

/*relationship scale >18>*/
POSMMQ98 = .;
if MMARQ98 ge 18 then POSMMQ98 = 1;
if MMARQ98 ge 0 and MMARQ98 lt 18 then POSMMQ98 = 0;
label POSMMQ98 = '1998 Mom has pos rel w/ Dad (GE 18, 6-item Scale)-- youth report';

/******1999 youth report of mother rel with father******/

/*reverse code*/
R349640R = 4-R3496400;
R349660R = 4-R3496600;
R349680R = 4-R3496800;

label R349640R ='MOTH SCREAM AT FATH WHEN ANGRY, REVERSE-CODED99';
label R349660R ='MOTH INSULT/CRITICIZE FATH, REVERSE-CODED99';
label R349680R ='MOTH BLAME FATH FOR PROBS, REVERSE-CODED99';

Array mf99{6} R349640R R349660R R349680R R3496300 R3496500 R3496700;

/*remove missings*/
mismf99=0;
    do a= 1 to 6;
      if mf99{a}=. then mismf99=mismf99+1;
    end;
       if mismf99 le 1 then do;
        MMARQ99 = sum (R349640R, R349660R, R349680R, R3496300, R3496500, R3496700)*(6/(6-mismf99));
        end;

label MMARQ99 ='6-Item Mother-Father Relationship Scale 1999';

/*relationship scale >18>*/
POSMMQ99 = .;
if MMARQ99 ge 18 then POSMMQ99 = 1;
if MMARQ99 ge 0 and MMARQ99 lt 18 then POSMMQ99 = 0;
label POSMMQ99 = '1999 Mom has pos rel w/ Dad (GE 18, 6-item Scale)-- youth report';

/******1997 youth report of father rel with mother******/

/*reverse code*/
R034650R = 4-R0346500;
R034670R = 4-R0346700;
R034690R = 4-R0346900;

label R034650R ='FATH SCREAM AT MOTH WHEN ANGRY, REVERSE-CODED97';
label R034670R ='FATH INSULT/CRITICIZE MOTH, REVERSE-CODED97';
label R034690R ='FATH BLAME MOTH FOR PROBS, REVERSE-CODED97';

Array fm97{6} R034650R R034670R R034690R R0346400 R0346600 R0346800;

/*reverse code*/
misfm97=0;
    do a= 1 to 6;
      if fm97{a}=. then misfm97=misfm97+1;
    end;
       if misfm97 le 1 then do;
        DMARQ97 = sum (R034650R,R034670R,R034690R,R0346400,R0346600,R0346800)*(6/(6-misfm97));
        end;

label DMARQ97 ='6-Item Father-Mother Relationship Scale (Youth Report) 1997';

/*relationship scale >18>*/
POSDMQ97 = .;
if DMARQ97 ge 18 then POSDMQ97 = 1;
if DMARQ97 ge 0 and DMARQ97 lt 18 then POSDMQ97 = 0;
label POSDMQ97 = '1997 Dad has pos rel w/ Mom (GE 18, 6-item Scale)-- youth report';

/******1998 youth report of father rel with mother******/

/*reverse code*/
R217910R = 4-R2179100;
R217930R = 4-R2179300;
R217950R = 4-R2179500;

label R217910R ='FATH SCREAM AT MOTH WHEN ANGRY, REVERSE-CODED98';
label R217930R ='FATH INSULT/CRITICIZE MOTH, REVERSE-CODED98';
label R217950R ='FATH BLAME MOTH FOR PROBS, REVERSE-CODED98';

Array fm98{6} R217910R R217930R R217950R R2179000 R2179200 R2179400;

/*remove missings*/
misfm98=0;
    do a= 1 to 6;
      if fm98{a}=. then misfm98=misfm98+1;
    end;
       if misfm98 le 1 then do;
        DMARQ98 = sum (R217910R, R217930R, R217950R, R2179000, R2179200, R2179400)*(6/(6-mismf98));
        end;

label DMARQ98 ='6-Item Father-Mother Relationship Scale (Youth Report) 1998';

/*relationship scale >18>*/
POSDMQ98 = .;
if DMARQ98 ge 18 then POSDMQ98 = 1;
if DMARQ98 ge 0 and DMARQ98 lt 18 then POSDMQ98 = 0;
label POSDMQ98 = '1998 Dad has pos rel w/ Mom (GE 18, 6-item Scale)-- youth report';

/******1999 youth report of father rel with mother******/

/*reverse code*/
R349700R = 4-R3497000;
R349720R = 4-R3497200;
R349740R = 4-R3497400;

label R349700R ='FATH SCREAM AT MOTH WHEN ANGRY, REVERSE-CODED99';
label R349720R ='FATH INSULT/CRITICIZE MOTH, REVERSE-CODED99';
label R349740R ='FATH BLAME MOTH FOR PROBS, REVERSE-CODED99';

Array fm99{6} R349700R R349720R R349740R R3496900 R3497100 R3497300;

/*remove missings*/
misfm99=0;
    do a= 1 to 6;
      if fm99{a}=. then misfm99=misfm99+1;
    end;
       if misfm99 le 1 then do;
        DMARQ99 = sum (R217910R, R217930R, R217950R, R2179000, R2179200, R2179400)*(6/(6-mismf99));
        end;

label DMARQ99 ='6-Item Father-Mother Relationship Scale (Youth Report) 1999';

/*relationship scale >18>*/
POSDMQ99 = .;
if DMARQ99 ge 18 then POSDMQ99 = 1;
if DMARQ99 ge 0 and DMARQ99 lt 18 then POSDMQ99 = 0;
label POSDMQ99 = '1999 Dad has pos rel w/ Mom (GE 18, 6-item Scale)-- youth report';

/******1997 parent report of parents' marital relationship******/

/*reverse code*/
R062630R = 4-R0626300;
R062640R = 4-R0626400;
R062670R = 4-R0626700;

label R062630R ='SP/PART SCREAM AT PR WHEN ANGRY? 1997, REVERSE-CODED97';
label R062640R ='SP/PART INSULT/CRITICIZE PR? 1997, REVERSE-CODED97';
label R062670R ='SP/PART BLAME PR FOR PROBS? 1997, REVERSE-CODED97';

Array part97{6} R062630R R062640R R062670R R0626100 R0626500 R0626600;

/*remove missings*/
misparrel97=0;
    do a= 1 to 6;
      if part97{a}=. then misparrel97=misparrel97+1;
    end;
       if misparrel97 le 1 then do;
        MARQ_PR = sum (R062630R, R062640R, R062670R, R0626100, R0626500, R0626600)*(6/(6-misparrel97));
        end;

label MARQ_PR ='6-Item Father-Mother Relationship Scale (parent report) 1997';

/*relationship scale >18>*/
POSMARQP = .;
if MARQ_PR ge 18 then POSMARQP = 1;
if MARQ_PR ge 0 and MARQ_PR lt 18 then POSMARQP = 0;
label POSMARQP = '1997 Parents have pos rel (GE 18 6-item Scale)--parent report';

IF MARQ_PR =. THEN ydREL_QSUM=.;
ELSE IF MARQ_PR LT 15 THEN parREL_QSUM=1;
ELSE IF (MARQ_PR GE 15) AND (MARQ_PR LT 21) THEN parREL_QSUM=2;
ELSE IF MARQ_PR GE 21 THEN parREL_QSUM=3;
format parREL_QSUM quart.;
LABEL parREL_QSUM = 'Quartile of parent marital rel (cont scale r1)';


/*******************************COMPOSITE VARIABLES*****************************/


/********************************P-Y RELATIONSHIP********************************/
/*********Mother*********/
/*sum of continuous scale*/
SUMYMREL=.;
SUMYMREL=sum(of YMREL797 YMREL798  YMREL799);
label SUMYMREL = 'Sum of continuous scale from rounds 1-3 -- P-Y rel, mother';

/*Quartile of scale across 3 rounds*/
ymrel_QSUM=.;
IF SUMYMREL =. THEN ymrel_QSUM=.;
ELSE IF SUMYMREL LT 48 THEN ymrel_QSUM=1;
ELSE IF (SUMYMREL GE 48) AND (SUMYMREL LT 70) THEN ymrel_QSUM=2;
ELSE IF SUMYMREL GE 70 THEN ymrel_QSUM=3;
format ymrel_QSUM quart.;
LABEL ymrel_QSUM = 'Quartile of sum of cont scale (r1-3) -- P-Y rel, mother';

/*AVG of score across three rounds*/
ymrel_AVG=.;
ymrel_AVG=SUMYMREL/3;
label ymrel_AVG = 'Average of Y-mother rel (cont scale r1-3)';

/*proc univariate;
var SUMYMREL;
run;*/
/*SUM of positive relationship -- only includes cases with data at 2 time points or more*/
Array rel1{3} POSYM97 POSYM98 POSYM99;
ymrelmiss=0;
    do a= 1 to 3;
      if rel1{a}=. then ymrelmiss=ymrelmiss+1;
	  end;
       if ymrelmiss LE 1 then do;
	    MYPOSRELSUM  = sum (POSYM97,POSYM98,POSYM99)*(3/3-ymrelmiss);
		end;
	   else if ymrelmiss GT 1 then MYPOSRELSUM =.;
label MYPOSRELSUM = 'Sum of positive cut-off from rounds 1-3 -- P-Y rel, mother';

/*********Father*********/
/*sum of continuous scale*/
SUMYFREL=.; 
SUMYFREL=sum(of YDREL797 YDREL798 YDREL799);
label SUMYFREL = 'Sum of Y-father rel (cont scale r1-3)';

IF SUMYFREL =. THEN ydREL_QSUM=.;
ELSE IF SUMYFREL LT 37 THEN ydREL_QSUM=1;
ELSE IF (SUMYFREL GE 37) AND (SUMYFREL LT 69) THEN ydREL_QSUM=2;
ELSE IF SUMYFREL GE 69 THEN ydREL_QSUM=3;
format ydREL_QSUM quart.;
LABEL ydREL_QSUM = 'Quartile of sum of Y-father rel (cont scale r1-3)';

/*SUM of positive relationship -- only includes cases with data at 2 time points or more*/
Array ydrel1{3} POSYD97 POSYD98 POSYD99;
ydrelmiss=0;
    do a= 1 to 3;
      if ydrel1{a}=. then ydrelmiss=ydrelmiss+1;
	  end;
       if ydrelmiss LE 1 then do;
	    ydPOSRELSUM  = sum (POSYD97,POSYD98,POSYD99)*(3/3-ydrelmiss);
		end;
	   else if ydrelmiss GT 1 then ydPOSRELSUM =.;
label ydPOSRELSUM  = 'Sum of positive cut-off from rounds 1-3 -- P-Y rel, father';

/*AVG of scale score across 3 rounds*/
ydREL_AVG=.;
ydREL_AVG=SUMYFREL/3;
label ydREL_AVG = 'Average of Y-father rel (cont scale r1-3)';

/*********************PARENT RELATIONSHIP (YOUTH REPORT)********************/
/*Mother*/

/*sum of continuous scale*/
SUMYMFREL=.;
SUMYMFREL=sum(of MMARQ97 MMARQ98 MMARQ99);
label SUMYMFREL = 'Sum of continuous scale from rounds 1-3 -- Parent rel (mother->father) --y rep';

MFRELY_QSUM=.;
IF SUMYMFREL =. THEN MFRELY_QSUM=.;
ELSE IF SUMYMFREL LT 20 THEN MFRELY_QSUM=1;
ELSE IF (SUMYMFREL GE 20) AND (SUMYMFREL LT 57) THEN MFRELY_QSUM=2;
ELSE IF SUMYMFREL GE 57 THEN MFRELY_QSUM=3;
format MFRELY_QSUM quart.;
LABEL MFRELY_QSUM = 'Quartile of sum of cont scale (r1-3) -- Parent rel (mother->father) --y rep';
   
/*AVG of scale score across 3 rounds*/
MFRELY_AVG=.;
MFRELY_AVG=SUMYMFREL/3;
label MFRELY_AVG = 'Average of Parent rel (mother->father) --cont scale r1-3 y rep';
 
/*SUM of positive relationship -- only includes cases with data at 2 time points or more*/
Array mdrel1{3} POSMMQ97 POSMMQ98 POSMMQ99;
mfrelyrmiss=0;
    do a= 1 to 3;
      if mdrel1{a}=. then mfrelyrmiss=mfrelyrmiss+1;
	  end;
       if mfrelyrmiss LE 1 then do;
	    MMARPOSRELSUM  = sum (POSMMQ97,POSMMQ98,POSMMQ99)*(3/3-mfrelyrmiss);
		end;
	   else if mfrelyrmiss GT 1 then MMARPOSRELSUM =.;
label MMARPOSRELSUM  = 'Sum of positive cut-off from rounds 1-3 -- Mother-Father rel, youth report';
     
/**************Father****************/

/*sum of continuous scale*/
SUMYFMREL=.; 
SUMYFMREL=sum(of DMARQ97  DMARQ98 DMARQ99 );
label SUMYFMREL = 'Sum of continuous scale from rounds 1-3 -- Parent rel (father) --y rep';

/*Quartile of continuous scale*/
IF SUMYFMREL =. THEN DMRELY_QSUM=.;
ELSE IF SUMYFMREL LT 20 THEN DMRELY_QSUM=1;
ELSE IF (SUMYFMREL GE 20) AND (SUMYFMREL LT 59) THEN DMRELY_QSUM=2;
ELSE IF SUMYFMREL GE 59 THEN DMRELY_QSUM=3;
format DMRELY_QSUM quart.;
LABEL DMRELY_QSUM = 'Quartile of sum of cont scale (r1-3) -- Parent rel (father) --y rep';

/*AVG of relationship scale score across rounds*/
DMRELYAVG=.;
DMRELYAVG=SUMYFMREL/3;
label DMRELYAVG = 'Average of Parent rel (father) --cont scale r1-3 y rep';


/*SUM of positive relationship -- only includes cases with data at 2 time points or more*/
Array dmrel1{3} POSDMQ97 POSDMQ98 POSDMQ99;
dfrelyrmiss=0;
    do a= 1 to 3;
      if dmrel1{a}=. then dfrelyrmiss=dfrelyrmiss+1;
	  end;
       if dfrelyrmiss LE 1 then do;
	    DMARPOSRELSUM  = sum (POSDMQ97,POSDMQ98,POSDMQ99)*(3/3-dfrelyrmiss);
		end;
	   else if dfrelyrmiss GT 1 then DMARPOSRELSUM =.;
label DMARPOSRELSUM  = 'Sum of positive cut-off from rounds 1-3 -- Father-Mother rel, youth report';

/*********************************************************************************/
/*******************************MACROS********************************************/

%macro everuse (inround, noanswer, crndev, evvar,dlivar,newvar, year, label= );
	If &noanswer = 1 then do; /*R didn't answer q in previous round*/
		If &inround = 0 then &newvar = .; /*Did not complete current round*/
		Else if (&crndev = 0) then &newvar = 0; /*Never used...*/
		Else if (&crndev = 1) then &newvar = 1; /* Ever used...*/
		End;
	Else If (&noanswer = 0) or (&noanswer = .C) then do; /*Had answered questions*/
		If &inround = 0 then &newvar = .; /*Did not complete Round*/
		Else If &evvar = 1 then &newvar = 1; /*Said ever in prev round*/
		Else If (&evvar = 0) and (&dlivar = .) then &newvar = .; /*Coding never from prev round and miss on dli current round as missing*/
		Else if (&evvar = 0) and (&dlivar = 0) then &newvar = 0; /*Never used ...*/
		Else if (&evvar = 0) and (&dlivar = 1) then &newvar= 1; /*Started since dli*/
		Else If (&evvar = .) and (&dlivar = 1) then &newvar = 1; /*Missing from prev round but yes to DLI*/
End;
	Label &newvar = "R has &label, &year";
%mend;

%macro everusem (inround, noanswer, crndev, evvar,dlivar,newvar, year, label= );
	If &inround = 0 then &newvar = .; /*Did not complete Round*/
	Else If &inround = 1 then do; 
		If &evvar = 1 then &newvar = 1; /*Ever used from prev round*/
		If &noanswer = 1  then do;/*R didn't answer q in previous round*/
			If (&crndev = 0) then &newvar = 0; /*Never used...*/
			Else if (&crndev = 1) then &newvar = 1; /* Ever used...*/
			End;	
		If (&evvar = 0) and (&dlivar = .) then &newvar = .; /*Coding never from prev round and miss on dli current round as missing*/
		Else if (&evvar = 0) and (&dlivar = 0) then &newvar = 0; /*Never used ...*/
		Else if (&evvar = 0) and (&dlivar = 1) then &newvar= 1; /*Started since dli*/
		Else If (&evvar = .) and (&dlivar = 1) then &newvar = 1; /*Missing from prev round but yes to DLI*/
End;
	Label &newvar = "R has &label, &year";
%mend;

%macro everusej (inround, crndev, evvar, dlivar,newvar, year, label= );
	If &inround = 0 then &newvar = .; /*Did not complete Round*/
	If &evvar = 1 then &newvar = 1; /*Ever used from prev round*/
		If &evvar = . then do;/*Ever missing from prev round*/
			If (&crndev = 1) then &newvar = 1; /* Ever used...*/
			Else If (&crndev = 0) then &newvar = 0; /*Never used...*/
			Else If (&crndev = .) then &newvar = &dlivar; /*Missing from prev & current round, defer to DLI*/
		End;	
		If (&evvar = 0) and (&dlivar = .) then &newvar = .; /*Coding never from prev round and miss on dli current round as missing*/
		Else if (&evvar = 0) and (&dlivar = 0) then &newvar = 0; /*Never used ...*/
		Else if (&evvar = 0) and (&dlivar = 1) then &newvar= 1; /*Started since dli*/
	Label &newvar = "R has &label, &year";
%mend;

%macro everusez (crndev, evvar, dlivar,newvar, year, label= );
		If &evvar = 1 then &newvar = 1; /*Ever used from prev round*/
		If &evvar = . then do;/*Ever missing from prev round*/
			If (&crndev = 1) then &newvar = 1; /* Ever used...*/
			Else If (&crndev = 0) then &newvar = 0; /*Never used...*/
			Else If (&crndev = .) then &newvar = &dlivar; /*Missing from prev round but yes to DLI*/
		End;	
		If (&evvar = 0) and (&dlivar = .) then &newvar = .; /*Coding never from prev round and miss on dli current round as missing*/
		Else if (&evvar = 0) and (&dlivar = 0) then &newvar = 0; /*Never used ...*/
		Else if (&evvar = 0) and (&dlivar = 1) then &newvar= 1; /*Started since dli*/
	Label &newvar = "R has &label, &year";
%mend;

/*2nd version of corrected ever macro for use in rounds without current ever use question*/
%macro everuse2 (inround,lastrnd, dlivar, newvar, year, label= );
		If &inround = 0 then &newvar = .; /*Did not complete current round*/
		If &inround = 1 then do; /*Did complete Round*/
				If (&lastrnd = 1) or (&dlivar = 1) then &newvar = 1; /*ever last round or said yes to dli*/
				Else if (&lastrnd = 0) and (&dlivar = 0) then &newvar = 0; /*never last round and no to dli*/
				Else if (&lastrnd = .) then &newvar = &dlivar;
			end;
		Label &newvar = "R has &label, &year";
%mend;

%macro everusez2 (lastrnd, dlivar, newvar, year, label= );
			If (&lastrnd = 1) or (&dlivar = 1) then &newvar = 1; /*ever last round or said yes to dli*/
			Else if (&lastrnd = 0) and (&dlivar = 0) then &newvar = 0; /*never last round and no to dli*/
			Else if (&lastrnd = .) then &newvar = &dlivar;
		Label &newvar = "R has &label, &year";
%mend;

/*Since DLI Only*/
%macro delinqdli (inround, noanswer, evvar, dlivar, newvar, year, label= );
	If &noanswer = 1 then do;
		If &inround = 0 then &newvar = .; /*Did not complete R2*/
		Else if (&evvar = 0) then &newvar = 0; /*Has never done ...*/
		Else if &evvar = 1 then do;
			If &dlivar = . then &newvar = .;
			Else if &dlivar = 0 then &newvar = 0; /*Has never done ...*/
			Else if &dlivar = 1 then &newvar  = 1; /*Had done ... since dli*/
		End;
	End;
	If (&noanswer = 0) or (&noanswer = -3) then do;
		If &inround = 0 then &newvar = .; /*Did not complete R2*/
		Else if &dlivar = . then &newvar = .;
		Else if &dlivar = 0 then &newvar = 0; /*Has never done ...*/
		Else if &dlivar = 1 then &newvar  = 1; /*Had done ... since dli*/
	End;
	Label &newvar = "R has &label since DLI, &year";
	Format &newvar yes10no.;
%mend;

%macro delinqdli2 (inround, dlivar, newvar, year, label= );
	If &inround = 0 then &newvar = .; /*Did not complete R2*/
	Else if &dlivar = . then &newvar = .;
	Else if &dlivar = 0 then &newvar = 0; /*Has never done ...*/
	Else if &dlivar = 1 then &newvar  = 1; /*Had done ... since dli*/
	Label &newvar = "R has &label since DLI, &year";
	Format &newvar yes10no.;
%mend;

%macro howold (lstrndage, crndev, crndage, ever, lastev, agevar, newvar, year, label=);
If &lstrndage GT 0 then &newvar = &lstrndage ; /*Reported age in first round or round prev reported*/
	Else if &lastev = 0 then do; /*never as of last round*/
		If &ever = 1 then &newvar = &agevar; /*people who have begun since last round*/
		If &ever = 0 then &newvar = .n; /*still never*/
		If &ever = . then &newvar = .; /*missing*/
		end;
	Else if &lastev = . then do; /*missing as of last round*/
		If &ever = 1 then &newvar = &agevar; /*people who have begun since last round*/
		If &ever = 0 then &newvar = .n; /*never*/
		If &ever = . then &newvar = .; /*missing*/
		end;
	Else If &lstrndage =. then do;
		If &crndage GT 0 then &newvar = &crndage; /*Agevar reported at current round*/
		Else if &crndev = 0 then &newvar =.n; /*never*/
		End;
Else &newvar =.;
Label &newvar = "Age of first &label, &year";
%mend;

%macro howold2 (lstrndage, ever, lastev, agevar, newvar, year, label=);
If &lstrndage GT 0 then &newvar = &lstrndage ; /*Reported age in first round or round prev reported*/
	Else if &lastev = 0 then do; /*never as of last round*/
		If &ever = 1 then &newvar = &agevar; /*people who have begun since last round*/
		If &ever = 0 then &newvar = .n; /*still never*/
		If &ever = . then &newvar = .; /*missing*/
		end;
	Else if &lastev = . then do; /*missing as of last round*/
		If &ever = 1 then &newvar = &agevar; /*people who have begun since last round*/
		If &ever = 0 then &newvar = .n; /*never*/
		If &ever = . then &newvar = .; /*missing*/
		end;
Else &newvar =.;
Label &newvar = "Age of first &label, &year";
%mend;

/*Heavy/light daily smoking - 10 or more*/
%macro halfpack (smokedli, daysmoked, cigsmoked, newvar, year);
If (&smokedli = .) and (&daysmoked = .) then &newvar = .;
Else if &smokedli = 0 then &newvar = 0;
Else if (&smokedli = 1) and (&daysmoked = 0) then &newvar = 0;
Else if (&smokedli = 1) and (&cigsmoked = 0) then &newvar = 0;
Else if  &cigsmoked = . then &newvar = .;
Else if (&smokedli = 1) and (1 le &cigsmoked le 9) then &newvar = 1;
Else if (&smokedli = 1) and ( &cigsmoked ge 10) then &newvar = 2;
Label &newvar = "R is heavy/light smoker, &year";
Format &newvar smoke_b.;
%mend;

/*Number of days in the past 30 days R drank 5+ drinks*/
%macro bingedays (drinkdli, newvar, drink30, bingeddays, year);
If &drinkdli= 0 then &newvar = 0;
Else if (&drinkdli= 1) and (&drink30 = 0) then &newvar = 0; /*Hasn't drank in last 30 days*/
Else if  &bingeddays = 0 then &newvar = 0;
Else if &bingeddays gt 0 then &newvar = &bingeddays;
Label &newvar = "Number of days R has had 5+ drinks at least one day in past 30 days, &year";
%mend;

/*Any binge drinking in the past 30 days*/
%macro anybinge (drinkdli, bingedays, drink30, newvar, year);
If &drinkdli = 0 then &newvar = 0;
Else if (&drinkdli = 1) and (&drink30 = 0) then &newvar = 0; /*Hasn't drank in last 30 days*/
Else if  &bingedays = 0 then &newvar = 0;
Else if &bingedays gt 0 then &newvar = 1;
Label &newvar = "R has had 5+ drinks at least one day in past 30 days, &year";
format &newvar yes10no.;
%mend;

/******************AGE AT ROUND**********/
/*Used in substance use variables*/
/*Used for Age by variables*/

Array ageold(8) R1194100 R2553500 R3876300 R5453700 R7216000 S1531400 S2001000 S3801100;
Array agenew(8) ager1 ager2 ager3 ager4 ager5 ager6 ager7 ager8;

Do i =  1 to 8;
	If ageold(i) lt 0 then agenew(i) = .;
	Else agenew(i) = ageold(i);
End;

/**********************************************************************************/
/********************************Substance Abuse Index*****************************/
/**********************************************************************************/

/******************************************************************************************/
/*1997*/
/*Note: Added a question about cocaine in 1998, so the index goes from 3-item to 4-item index in'98*/
/*Currently after 1997 the "ever" variables are coded such that if a responded said yes in any round they automatically get
a "yes" on the "ever" variable. If they said no in a round and a missing in other rounds they are coded as "no".*/

Array oldvar1(9) R0357900 R0358100 R0358300 R0358900 R0358700 R0358200 R0358000 R0358400 R0359000;
Array newvar1(9) smoke1 smoke301 drink/*1*/ pot1 /*bngdrnk1*/ bngdrnkd numcig1 frstsmk1 frstdrk1 frstpot1;

Do i = 1 to 9;
	If oldvar1(i) lt 0 then newvar1(i) = .;
	Else newvar1(i) = oldvar1(i);
End;

Label smoke1 = "R has ever smoked, 1997";
Label smoke301 = "# of days smoked cigarettes  in last 30 days, 1997";
Label drink1 = "R has ever drank alcohol, 1997";
Label pot1 = "R had ever used marijuana, 1997";
Label bngdrnkd = "# of days R had 5+ drinks per day in last 30 days, 1997";
Label numcig1 = "Number of cigarettes/day in last 30 days, 1997";
Label frstsmk1 = "Age of first cigarette, reported 1997";
Label frstdrk1 = "Age of first drink, reported 1997";
Label frstpot1 = "Age of first marijuana use, reported 1997";

/*Index*/
/*3-Item index (For DISCONNECTED) with smoking, drinking, and marijuana*/
%let subscl1a = smoke1, drink1, pot1;
	If nmiss(&subscl1a) le 0 then subscl3_1= sum (&subscl1a);
	Label subscl3_1 = "3-Item Substance Use Index (self created), 1997";

/*Any binge drinking*/
If drink1 = 0 then bngdrnk1d = 0;
Else if (drink1 = 1) and (R0358500 = 0) then bngdrnk1d = 0; /*Hasn't drank in last 30 days*/
Else if  bngdrnkd = 0 then bngdrnk1d = 0;
Else if bngdrnkd gt 0 then bngdrnk1d = 1;
Label bngdrnk1d = "R has had 5+ drinks at least one day in past 30 days, 1997";
Format bngdrnk1d yes10no.;

%bingedays (drink1, bingedays1, R0358500, bngdrnkd, 1997);
%halfpack (smoke1, smoke301, numcig1, hvysmk97, 1997);

/*No cocaine in R1 but create coke1variable to keep consistent when turning it in to ages*/
coke1 = .;
subscl2_1 = .;

/*1998*/
array saold2(14) R2189100 R2189900 R2190900 R2191500 R2189400 R2189500 R2190200 
R2191200 R2190500 R2189600 R2189300 R2190100 R2191100 R2191600;
array sanew2(14) smokeev2 drinkev2 potev2 cokeev2 smokedli2 smoke302 drinkdli2 
potdli2 bngdrnk2 numcig2 smkage2 drkage2 potage2 frstcoke2;

Do i = 1 to 14;
	If saold2(i) lt 0 then sanew2(i) = .;
	Else sanew2(i) = saold2(i);
End;

Label smokeev2 = "R has ever smoked, 1998";
Label drinkev2 = "R has ever drank alcohol, 1998";
Label potev2 = "R had ever used marijuana, 1998";
Label cokeev2 = "R had ever used hard drugs, 1998";
Label bngdrnk2 = "# of days R had 5+ drinks per day in last 30 days, 1998";
Label smokedli2 = "R has smoked since DLI, 1998";
Label smoke302 = "# of days smoked cig. in last 30 days, 1998";
Label drinkdli2 = "R has drank alcohol since DLI, 1998";
Label potdli2 = "R had used marijuana since DLI, 1998";
Label numcig2 = "# cigarettes/day in last 30 days, 1998";
label smkage2 = 'Age of first cigarette reported 1998';
label potage2 = 'Age of first marijuana use reported 1998';
label drkage2 = 'Age of first drink reported 1998';
label frstcoke2 = 'Age of first coke use reported 1998';

%delinqdli (S1529901, R2188900, smokeev2, smokedli2, smokedli98, 1998, label= smoked cigarette);
%delinqdli (S1529901, R2189700, drinkev2, drinkdli2, drinkdli98, 1998, label= drank alcohol);
%delinqdli (S1529901, R2190700, potev2, potdli2, potdli98, 1998, label= used marijuana);

If S1529901 = 0 then cokedli98 = .;
Else if cokeev2 = 0 then cokedli98 = 0;
Else if R2191700 = 0 then cokedli98 = 0; 
Else if R2191700 gt 0 then cokedli98 = 1;
Label cokedli98 = "R used cocaine/hard drugs since DLI, 1998";
Format cokedli98 yes10no.;

/*EVER (by round 2)*/
%everusez (smokeev2, smoke1, smokedli98, smoke98ever, 1998, label=ever smoked a cigarette );
%everusez (drinkev2, drink1, drinkdli98, drink98ever, 1998, label = ever drank alcohol);
%everusez (potev2, pot1, potdli98, pot98ever, 1998, label= ever used marijuana);

/*AGE AT FIRST USE*/

%howold (frstsmk1, smokeev2, smkage2, smoke98ever, smoke1, ager2, frstsmk2, 1998, label=cigarette);
%howold (frstdrk1, drinkev2, drkage2, drink98ever, drink1, ager2, frstdrk2, 1998, label=alcohol use);
%howold (frstpot1, potev2, potage2, pot98ever, pot1, ager2, frstpot2, 1998, label=marijuana use);

/*Illegal-substance Index*/
%let subscl2a = potdli98, cokedli98;
	If nmiss(&subscl2a) le 0 then subscl2_2 = sum (&subscl2a);
	Label subscl2_2 = "2-Item Illegal-Substance Use Index (pot & hard drugs - DLI), 1998";

/*binge drinking and heavy smoking vars*/
%anybinge (drinkdli2, bngdrnk2, R2190300, anybnge98, 1998); 
%bingedays (drinkdli2, bingedays2, R2190300, bngdrnk2, 1998);
%halfpack (smokedli2, smoke302, numcig2, hvysmk98, 1998);


/******************************************************************************************/

/*1999*/
array saold3(16) R3508200 R3509000 R3510000 R3510800 R3508500 R3508600 R3509300 R3510300 R3511100 
R3511200 R3509600 R3508700 R3508400 R3509200 R3510200 R3511000;
array sanew3(16) smokeev3 drinkev3 potev3 cokeev3 smokedli3 smoke303 drinkdli3 potdli3 cokedli3 
cokenum3 bngdrnk3 numcig3 smkage3 drkage3 potage3 cokeage3;

Do i = 1 to 16;
	If saold3(i) lt 0 then sanew3(i) = .;
	Else sanew3(i) = saold3(i);
End;

Label smokeev3 = "R has ever smoked, 1999";
Label drinkev3 = "R has ever drank alcohol, 1999";
Label potev3 = "R had ever used marijuana, 1999";
Label cokeev3 = "R had ever used hard drugs, 1999";
Label cokenum3 = "Numer dof times R used hard drugs since DLI, 1999";
Label bngdrnk3 = "# of days R had 5+ drinks per day in last 30 days, 1999";
Label smokedli3 = "R has smoked since DLI, 1999";
Label smoke303 = "# days smoked cig. in last 30 days, 1999";
Label drinkdli3 = "R has drank alcohol since DLI, 1999";
Label potdli3 = "R had used marijuana since DLI, 1999";
Label cokedli3 = "R had used hard drugs since DLI, 1999";
Label numcig3 = "# cigarettes/day in last 30 days, 1999";
label smkage3 = 'Age of first cigarette reported 1999';
label potage3 = 'Age of first marijuana use reported 1999';
label drkage3 = 'Age of first drink reported 1999';
label cokeage3 = 'Age of first coke use reported 1999';

%delinqdli (S1529902, R3508000, smokeev3, smokedli3, smokedli99, 1999, label= smoked cigarette);
%delinqdli (S1529902, R3508800, drinkev3, drinkdli3, drinkdli99, 1999, label= drank alcohol);
%delinqdli (S1529902, R3509800, potev3, potdli3, potdli99, 1999, label= used marijuana since);

/*Hard drugs skip pattern was slightly different - If they didn't answer in previous round and they then answered 
"yes" to the EVER question, rather than being asked whether they had done drugs SDLI they were asked how many
times SDLI, so this has to be recoded to a yes/no variable*/

If (R3510600 = 0) or (R3510600 = -3) then do;
	If S1529902 = 0 then cokedli99 = .;
	Else if (cokedli3 = 0) or (cokenum3 = 0) then cokedli99 = 0;
	Else if cokedli3 = 1 then cokedli99 = 1;
End;
Else if R3510600 = 1 then do;
	If S1529902 = 0 then cokedli99 = .;
	Else if cokeev3 = 0 then cokedli99 = 0;
	Else if cokeev3 = 1 then do;
		If cokenum3 lt 0 then cokedli99 = .;
		Else if cokenum3 = 0 then cokedli99 = 0;
		Else if cokenum3 gt 0 then cokedli99 = 1;
	End;
End;
Label cokedli99 = "R had used hard drugs since DLI, 1999";
Format cokedli99 yes10no.;

/*EVER (by round 3)*/         		    
%everusez (smokeev3, smoke98ever, smokedli99,smoke99ever,1999, label = ever smoked a cigarette);
%everusez (drinkev3, drink98ever, drinkdli99, drink99ever, 1999, label = ever drank alcohol);
%everusez (potev3, pot98ever, potdli99, pot99ever, 1999, label = ever used marijuana);
%everusez (cokeev3, cokeev2, cokedli99, coke99ever, 1999, label = ever used hard drugs);

%howold (frstsmk2, smokeev3, smkage3, smoke99ever, smoke98ever, ager3, frstsmk3, 1999, label=cigarette);
%howold (frstdrk2, drinkev3, drkage3, drink99ever, drink98ever, ager3, frstdrk3, 1999, label=alcohol use);
%howold (frstpot2, potev3, potage3, pot99ever, pot98ever, ager3, frstpot3, 1999, label=marijuana use);
%howold (frstcoke2, cokeev3, cokeage3, coke99ever, cokeev2, ager3, frstcoke3, 1999, label=coke/hard drug use);

/*Illegal-substance Index*/
%let subscl3a = potdli99, cokedli99;
	If nmiss(&subscl3a) le 0 then subscl2_3 = sum (&subscl3a);
	Label subscl2_3 = "2-Item Illegal-Substance Use Index (pot & hard drugs - DLI), 1999";

/*binge drinking and heavy smoking vars*/
%anybinge (drinkdli3, bngdrnk3, R3509400, anybnge99, 1999); 
%bingedays (drinkdli3, bingedays3, R3509400, bngdrnk3, 1999);
%halfpack (smokedli3, smoke303, numcig3, hvysmk99, 1999);

/******************************************************************************************/

/*2000*/

array saold4(15) R4906400 R4907100 R4908100 R4908900 R4906600 R4906700 R4907400 
R4908400 R4909200 R4909300 R4907700 R4906800 R4907300 R4908300 R4909100 ;

array sanew4(15) smokeev4 drinkev4 potev4 cokeev4 smokedli4 smoke304 drinkdli4 
potdli4 cokedli4 cokenum4 bngdrnk4 numcig4 drkage4 potage4 cokeage4;

Do i = 1 to 15;
	If saold4(i) lt 0 then sanew4(i) = .;
	Else sanew4(i) = saold4(i);
End;

Label smokeev4 = "R has ever smoked, 2000";
Label drinkev4 = "R has ever drank alcohol, 2000";
Label potev4 = "R had ever used marijuana, 2000";
Label cokeev4 = "R had ever used hard drugs, 2000";
Label bngdrnk4 = "# of days R had 5+ drinks per day in last 30 days, 2000";
Label smokedli4 = "R has smoked since DLI, 2000";
Label smoke304 = "# days smoked cig. in last 30 days";
Label drinkdli4 = "R has drank alcohol since DLI, 2000";
Label potdli4 = "R had used marijuana since DLI, 2000";
Label cokedli4 = "R had used hard drugs since DLI, 2000";
Label cokenum4 = "Numer dof times R used hard drugs since DLI, 2000";
Label numcig4 = "# cigarettes/day in last 30 day, 2000";
label potage4 = 'Age of first marijuana use reported 2000';
label drkage4 = 'Age of first drink reported 2000';
label cokeage4 = 'Age of first coke use reported 2000';

%delinqdli (S1529903, R4906200, smokeev4, smokedli4, smokedli00, 2000, label= smoked cigarette);
%delinqdli (S1529903, R4906900, drinkev4, drinkdli4, drinkdli00, 2000, label= drank alcohol);
%delinqdli (S1529903, R4907900, potev4, potdli4, potdli00, 2000, label= used marijuana);

If (R4908700 = 0) or (R4908700 = -3) then do;
	If S1529903 = 0 then cokedli00 = .;
	Else if (cokedli4 = 0) or (cokenum4 = 0) then cokedli00 = 0;
	Else if cokedli4 = 1 then cokedli00 = 1;
End;
Else if R4908700 = 1 then do;
	If S1529903 = 0 then cokedli00 = .;
	Else if cokeev4 = 0 then cokedli00 = 0;
	Else if cokeev4 = 1 then do;
		If cokenum4 lt 0 then cokedli00 = .;
		Else if cokenum4 = 0 then cokedli00 = 0;
		Else if cokenum4 gt 0 then cokedli00 = 1;
	End;
End;
Label cokedli00 = "R had used hard drugs since DLI, 2000";
Format cokedli00 yes10no.;

/*EVER (by round 4)*/
%everusez (drinkev4, drink99ever, drinkdli00, drink00ever, 2000, label = ever used alcohol);
%everusez (potev4, pot99ever, potdli00, pot00ever, 2000, label = ever used marijuana);
%everusez (cokeev4, coke99ever, cokedli00, coke00ever, 2000, label = ever used hard drugs);
%everusez2 (smoke99ever, smokedli00, smoke00ever, 2000, label= ever smoked a cigarette);

%howold (frstdrk3, drinkev4, drkage4, drink00ever, drink99ever, ager4, frstdrk4, 2000, label=alcohol use);
%howold (frstpot3, potev4, potage4, pot00ever, pot99ever, ager4, frstpot4, 2000, label=marijuana use);
%howold (frstcoke3, cokeev4, cokeage4, coke00ever, coke99ever, ager4, frstcoke4, 2000, label=coke/hard drug use);
%howold2 (frstsmk3, smoke00ever, smoke99ever, ager4, frstsmk4, 2000, label= cigarette);

/*Illegal-substance Index*/
%let subscl4a = potdli00, cokedli00;
	If nmiss(&subscl4a) le 0 then subscl2_4 = sum (&subscl4a);
	Label subscl2_4 = "2-Item Illegal-Substance Use Index (pot & hard drugs - DLI), 2000";

/*binge drinking and heavy smoking vars*/
%anybinge (drinkdli4, bngdrnk4, R4907500, anybnge00, 2000); 
%bingedays (drinkdli4, bingedays4, R4907500, bngdrnk4, 2000);
%halfpack (smokedli4, smoke304, numcig4, hvysmk00, 2000);

/******************************************************************************************/

/*2001*/
/*In 2001, the only "ever question asked was about cocaine and other hard drugs, all other questions were DLI*/

array saold5(11) R6536100 R6534100 R6534200 R6534700 R6535600 R6536400 R6536500 R6535000 R6534300
R6535500 R6536300;
array sanew5(11) cokeev5 smokedli5 smoke305 drinkdli5 potdli5 cokedli5 cokenum5 bngdrnk5 numcig5
potage5 cokeage5;

Do i = 1 to 11;
	If saold5(i) lt 0 then sanew5(i) = .;
	Else sanew5(i) = saold5(i);
End;

Label cokeev5 = "R had ever used hard drugs, 2001";
Label bngdrnk5 = "# of days R had 5+ drinks per day in last 30 days, 2001";
Label smokedli5 = "R has smoked since DLI, 2001";
Label smoke305 = "# days smoked cig. in last 30 days, 2001";
Label drinkdli5 = "R has drank alcohol since DLI, 2001";
Label potdli5 = "R had used marijuana since DLI, 2001";
Label cokedli5 = "R had used hard drugs since DLI, 2001";
Label cokenum5 = "Numer dof times R used hard drugs since DLI, 2001";
Label numcig5 = "# cig/day in last 30 days, 2001";
label potage5 = 'Age of first marijuana use reported 2001';
label cokeage5 = 'Age of first hard drug use reported 2001';

%delinqdli2 (S1529904, smokedli5, smokedli01, 2001, label=smoked cigarette);
%delinqdli2 (S1529904, drinkdli5, drinkdli01, 2001, label=drank alcohol);
%delinqdli2 (S1529904, potdli5, potdli01, 2001, label=used marijuana );

If (R6535900 = 0) or (R6535900 = -3) then do;
	If S1529904 = 0 then cokedli01 = .;
	Else if (cokedli5 = 0) or (cokenum5 = 0) then cokedli01 = 0;
	Else if cokedli5 = 1 then cokedli01 = 1;
End;
Else if R6535900 = 1 then do;
	If S1529904 = 0 then cokedli01 = .;
	Else if cokeev5 = 0 then cokedli01 = 0;
	Else if cokeev5 = 1 then do;
		If cokenum5 lt 0 then cokedli01 = .;
		Else if cokenum5 = 0 then cokedli01 = 0;
		Else if cokenum5 gt 0 then cokedli01 = 1;
	End;
End;
Label cokedli01 = "R had used hard drugs since DLI, 2001";
Format cokedli01 yes10no.;

/*Age at first use*/

/*EVER (by round 5)*/ 
%everusez (cokeev5, coke00ever, cokedli01, coke01ever, 2001, label = ever used hard drugs);
%everusez2 (smoke00ever, smokedli01, smoke01ever, 2001, label= ever smoked a cigarette);
%everusez2 (drink00ever, drinkdli01, drink01ever, 2001, label = ever used alcohol);
%everusez2 (pot00ever, potdli01, pot01ever, 2001, label = ever used marijuana);

/*Age at first use*/
/*%howold (frstcoke4, cokeev5, cokeage5, cokedli01, coke00ever, ager5, frstcoke5, 2001, label=coke/hard drug use);
%howold2 (frstdrk4, drinkdli01, drink00ever, ager5, frstdrk5, 2001, label=alcohol use);
%howold2 (frstsmk4, smokedli01, smoke00ever, ager5, frstsmk5, 2001, label= cigarette);
%howold2 (frstpot4, potdli01, pot00ever, ager5, frstpot5, 2001, label=marijuana use);
*/
%howold (frstcoke4, cokeev5, cokeage5, coke01ever, coke00ever, ager5, frstcoke5, 2001, label=coke/hard drug use);
%howold2 (frstdrk4, drink01ever, drink00ever, ager5, frstdrk5, 2001, label=alcohol use);
%howold2 (frstsmk4, smoke01ever, smoke00ever, ager5, frstsmk5, 2001, label= cigarette);
%howold2 (frstpot4, pot01ever, pot00ever, ager5, frstpot5, 2001, label=marijuana use);


/*Illegal-substance Index*/
%let subscl5a = potdli01, cokedli01;
	If nmiss(&subscl5a) le 0 then subscl2_5 = sum (&subscl5a);
	Label subscl2_5 = "2-Item Illegal-Substance Use Index (pot & hard drugs - DLI), 2001";
	
/*binge drinking and heavy smoking vars*/
%anybinge (drinkdli5, bngdrnk5, R6534800, anybnge01, 2001); 
%bingedays (drinkdli5, bingedays5, R6534800, bngdrnk5, 2001);
%halfpack (smokedli5, smoke305, numcig5, hvysmk01, 2001);

/******************************************************************************************/
/*2002*/
/*In 2002, the  "ever" question was asked about marijuana and about cocaine and other hard drugs, all other questions were DLI*/

array saold6(13) S0922900 S0923700 S0921600 S0921700 S0922200 S0923200 S0924000 S0924100 S0922500 S0921800 
S0923300 S0923900 S0923100;
array sanew6(13) potev6 cokeev6 smokedli6 smoke306 drinkdli6 potdli6 cokedli6 cokenum6 bngdrnk6 numcig6 
potnum6 cokeage6 potage6;

Do i = 1 to 13;
	If saold6(i) lt 0 then sanew6(i) = .;
	Else sanew6(i) = saold6(i);
End;

Label potev6 = "R had ever marijuana, 2002";
Label cokeev6 = "R had ever used hard drugs, 2002";
Label bngdrnk6 = "# of days R had 5+ drinks per day in last 30 days, 2002";
Label smokedli6 = "R has smoked since DLI, 2002";
Label smoke306 = "# of days smoked cig. in last 30 days, 2002";
Label drinkdli6 = "R has drank alcohol since DLI, 2002";
Label potdli6 = "R had used marijuana since DLI, 2002";
Label cokedli6 = "R had used hard drugs since DLI, 2002";
Label cokenum6 = "Number of times R used hard drugs since DLI, 2002";
Label numcig6 = "# of cigarettes/day in last 30 days, 2002";
Label potnum6 = "# of days R used marijuana in the last 30 days, 2002";
label potage6 = 'Age of first marijuana use reported 2002';
label cokeage6 = 'Age of first coke use reported 2002';

%delinqdli (S1529905, S0922700, potev6, potdli6, potdli02, 2002, label= used marijuana);
%delinqdli2 (S1529905, smokedli6, smokedli02, 2002, label=smoked cigarette);
%delinqdli2 (S1529905, drinkdli6, drinkdli02, 2002, label=drank alcohol);

If (S0923500 = 0) or (S0923500 = -3) then do;
	If S1529905 = 0 then cokedli02 = .;
	Else if (cokedli6 = 0) or (cokenum6 = 0) then cokedli02 = 0;
	Else if cokedli6 = 1 then cokedli02 = 1;
End;
Else if S0923500 = 1 then do;
	If S1529905 = 0 then cokedli02 = .;
	Else if cokeev6 = 0 then cokedli02 = 0;
	Else if cokeev6 = 1 then do;
		If cokenum6 lt 0 then cokedli02 = .;
		Else if cokenum6 = 0 then cokedli02 = 0;
		Else if cokenum6 gt 0 then cokedli02 = 1;
	End;
End;
Label cokedli02 = "R had used hard drugs since DLI, 2002";
Format cokedli02 yes10no.;

/*EVER (by round 6)*/ 
%everusez (cokeev5, coke01ever, cokedli02, coke02ever, 2002, label = ever used hard drugs);
%everusez2 (smoke01ever, smokedli02, smoke02ever, 2002, label= ever smoked a cigarette);
%everusez2 (drink01ever, drinkdli02, drink02ever, 2002, label = ever used alcohol);
%everusez2 (pot01ever, potdli02, pot02ever, 2002, label = ever used marijuana);

/*Age at first use*/

%howold (frstcoke5, cokeev6, cokeage6, coke02ever, coke01ever, ager6, frstcoke6, 2002, label=coke/hard drug use);
%howold2 (frstdrk5, drink02ever, drink01ever, ager6, frstdrk6, 2002, label=alcohol use);
%howold2 (frstsmk5, smoke02ever, smoke01ever, ager6, frstsmk6, 2002, label= cigarette);
%howold2 (frstpot5, pot02ever, pot01ever, ager6, frstpot6, 2002, label=marijuana use);

/*Illegal-substance Index*/
%let subscl6a = potdli02, cokedli02;
	If nmiss(&subscl6a) le 0 then subscl2_6 = sum (&subscl6a);
	Label subscl2_6 = "2-Item Illegal-Substance Use Index (pot & hard drugs - DLI), 2002";

%anybinge (drinkdli6, bngdrnk6, S0922300, anybnge02, 2002); 
%bingedays (drinkdli6, bingedays6, S0922300, bngdrnk6, 2002);
%halfpack (smokedli6, smoke306, numcig6, hvysmk02, 2002);

/*2003*/
/*In 2003, the  "ever" question was not asked because there were no R's who refused to answer in previous year*/
/*There is also no Round identifying variable as yet in the data set*/

array saold7(8) S2988300 S2988400 S2988900 S2989700 S2990300 S2990400 S2989200 S2988500;
array sanew7(8) smokedli7 smoke307 drinkdli7 potdli7 cokedli7 cokenum7 bngdrnk7 numcig7;

Do i = 1 to 8;
	If saold7(i) lt 0 then sanew7(i) = .;
	Else sanew7(i) = saold7(i);
End;

Label bngdrnk7 = "# of days R had 5+ drinks per day in last 30 days, 2003";
Label smokedli7 = "R has smoked since DLI, 2003";
Label smoke307 = "# days smoked cig. in last 30 days, 2003";
Label drinkdli7 = "R has drank alcohol since DLI, 2003";
Label potdli7 = "R had used marijuana since DLI, 2003";
Label cokedli7 = "R had used hard drugs since DLI, 2003";
Label cokenum7 = "Numer dof times R used hard drugs since DLI, 2003";
Label numcig7 = "# cigarettes/day in last 30 days, 2003";

%delinqdli2 (S1529906, smokedli7, smokedli03, 2003, label= smoke cigarettes);
%delinqdli2 (S1529906, drinkdli7, drinkdli03, 2003, label= drink alcohol);
%delinqdli2 (S1529906, potdli7, potdli03, 2003, label= used marijuana);

If (cokedli7 = 0) or (cokenum7 = 0) then cokedli03 = 0;
Else if (cokedli7 = 1) or (cokenum7 gt 0)  then cokedli03 = 1;
Else if (cokedli7 = .) and (cokenum7 lt 0) then cokedli03 = .;
Label cokedli03 = "R had used hard drugs since DLI, 2003";
Format cokedli03 yes10no.;

/*EVER (by round 7)*/

%everusez2 (smoke02ever, smokedli03, smoke03ever, 2003, label = ever smoked a cigarette);
%everusez2 (drink02ever, drinkdli03, drink03ever, 2003, label = ever drank alcohol);
%everusez2 (pot02ever, potdli03, pot03ever, 2003, label = ever used marijuana);
%everusez2 (coke02ever, cokedli03, coke03ever, 2003, label = ever used hard drugs);

/*Age at first use*/
%howold2 (frstcoke6, coke03ever, coke02ever, ager7, frstcoke7, 2003, label=coke/hard drug use);
%howold2 (frstdrk6, drink03ever, drink02ever, ager7, frstdrk7, 2003, label=alcohol use);
%howold2 (frstsmk6, smoke03ever, smoke02ever, ager7, frstsmk7, 2003, label= cigarette);
%howold2 (frstpot6, pot03ever, pot02ever, ager7, frstpot7, 2003, label=marijuana use);

/*Illegal-substance Index*/
%let subscl7a = potdli03, cokedli03;
	If nmiss(&subscl7a) le 0 then subscl2_7 = sum (&subscl7a);
	Label subscl2_7 = "2-Item Illegal-Substance Use Index (pot & hard drugs - DLI), 2003";

%anybinge (drinkdli7, bngdrnk7, S2989000, anybnge03, 2003); 
%bingedays (drinkdli7, bingedays7, S2989000, bngdrnk7, 2003);
%halfpack (smokedli7, smoke307, numcig7, hvysmk03, 2003);

/*2004*/

array saold8(12) S4682900 S4683000 S4683700 S4684700 S4684400 S4685500 S4685200 S4685600 S4684000 S4683100 S4684600 S4685400;
array sanew8(12) smokedli8 smoke308 drinkdli8 potdli8 potev8 cokedli8 cokeev8 cokenum8 bngdrnk8 numcig8 potage8 cokeage8;

Do i = 1 to 12;
	If saold8(i) lt 0 then sanew8(i) = .;
	Else sanew8(i) = saold8(i);
End;

Label potev8 = "R had ever marijuana, 2004";
Label cokeev8 = "R had ever used hard drugs, 2004";
Label bngdrnk8 = "# of days R had 5+ drinks per day in last 30 days, 2004";
Label smokedli8 = "R has smoked since DLI, 2004";
Label smoke308 = "# days smoked cig. in last 30 days, 2004";
Label drinkdli8 = "R has drank alcohol since DLI, 2004";
Label potdli8 = "R had used marijuana since DLI, 2004";
Label cokedli8 = "R had used hard drugs since DLI, 2004";
Label cokenum8 = "Numer dof times R used hard drugs since DLI, 2004";
Label numcig8 = "# cigarettes/day in last 30 days, 2004";
label potage8 = 'Age of first marijuana use reported 2004';
label cokeage8 = 'Age of first coke use reported 2004';

%delinqdli2 (S1529907, smokedli8, smokedli04, 2004, label= smoke cigarettes);
%delinqdli2 (S1529907, drinkdli8, drinkdli04, 2004, label= drink alcohol);
%delinqdli2 (S1529907, potdli8, potdli04, 2004, label= used marijuana);

If (cokedli8 = 0) or (cokenum8 = 0) then cokedli04 = 0;
Else if (cokedli8 = 1) or (cokenum8 gt 0)  then cokedli04 = 1;
Else if (cokedli8 = .) and (cokenum8 lt 0) then cokedli04 = .;
Label cokedli04 = "R had used hard drugs since DLI, 2004";
Format cokedli04 yes10no.;

/*EVER (by round 8)*/

%everusez2 (smoke03ever, smokedli04, smoke04ever, 2004, label = ever smoked a cigarette);
%everusez2 (drink03ever, drinkdli04, drink04ever, 2004, label = ever drank alcohol);
%everusez (potev8, pot03ever, potdli04, pot04ever, 2004, label = ever used marijuana);
%everusez (cokeev8, coke03ever, cokedli04, coke04ever, 2004, label = ever used hard drugs);

/*Age at first use*/
%howold (frstcoke7, cokeev8, cokeage8, coke04ever, coke03ever, ager8, frstcoke8, 2004, label=coke/hard drug use);
%howold2 (frstdrk7, drink04ever, drink03ever, ager8, frstdrk8, 2004, label=alcohol use);
%howold2 (frstsmk7, smoke04ever, smoke03ever, ager8, frstsmk8, 2004, label= cigarette);
%howold (frstpot7, potev8, potage8, pot04ever, pot03ever, ager8, frstpot8, 2004, label=marijuana use);

/*Illegal-substance Index*/
%let subscl8a = potdli04, cokedli04;
	If nmiss(&subscl8a) le 0 then subscl2_8 = sum (&subscl8a);
	Label subscl2_8 = "2-Item Illegal-Substance Use Index (pot & hard drugs - DLI), 2004";

%anybinge (drinkdli8, bngdrnk8, S4683800, anybnge04, 2004); 
%bingedays (drinkdli8, bingedays8, S4683800, bngdrnk8, 2004);
%halfpack (smokedli8, smoke308, numcig8, hvysmk04, 2004);

/*drinking under 21*/
drkund21 =.;
If frstdrk8 LT 0 then drkund21 = .;
if frstdrk8 LT 21 then drkund21 = 1;
if frstdrk8 GE 21 then drkund21 = 0;
label drkund21 = 'Underage drinking 1= R drank while underage 0= no underage drinking';

/*Early use variables*/
erlydrnk = .;
If frstdrk8 LT 0 then erlydrnk = .;
else if frstdrk8 LE 17 then erlydrnk = 1;
else erlydrnk = 0;
label erlydrnk = 'Drinking before age 17: 1= R ever drank before 17';

erlysmke = .;
If frstsmk8 LT 0 then erlysmke = .;
else if frstsmk8 LE 17 then erlysmke = 1;
else erlysmke = 0;
label erlysmke = 'Smoking before age 17: 1= R ever smoked before 17';

erlypot = .;
If frstpot8 LT 0 then erlypot = .;
else if frstpot8 LE 17 then erlypot = 1;
else erlypot = 0;
label erlypot = 'Marijuana use before age 17: 1= R ever used marijuana before 17';

erlycoke = .;
If frstcoke8 LT 0 then erlycoke = .;
else if frstcoke8  LE 17 then erlycoke = 1;
else erlycoke = 0;
label erlycoke = 'Hard drug use before age 17: 1= R ever used hard drugs before 17';

erly_idx = .;
%let erly_idx = erlycoke, erlypot, erlysmke, erlydrnk;
	If nmiss(&erly_idx) le 1 then erly_idx= Round((sum (&erly_idx)*4)/(4-(nmiss(&erly_idx))));
	Label erly_idx = "4-Item Early Substance Use Index";

/******Substance variables by age @ interview******/
Array subvars_rnd1(8) smoke1 drink1 pot1 coke1 bingedays1 anybnge97 hvysmk97 subscl2_1;
Array subvars_rnd2(8) smokedli98 drinkdli98 potdli98 cokedli98 bingedays2 anybnge98 hvysmk98 subscl2_2;
Array subvars_rnd3(8) smokedli99 drinkdli99 potdli99 cokedli99 bingedays3 anybnge99 hvysmk99 subscl2_3;
Array subvars_rnd4(8) smokedli00 drinkdli00 potdli00 cokedli00 bingedays4 anybnge00 hvysmk00 subscl2_4;
Array subvars_rnd5(8) smokedli01 drinkdli01 potdli01 cokedli01 bingedays5 anybnge01 hvysmk01 subscl2_5;
Array subvars_rnd6(8) smokedli02 drinkdli02 potdli02 cokedli02 bingedays6 anybnge02 hvysmk02 subscl2_6;
Array subvars_rnd7(8) smokedli03 drinkdli03 potdli03 cokedli03 bingedays7 anybnge03 hvysmk03 subscl2_7;
Array subvars_rnd8(8) smokedli04 drinkdli04 potdli04 cokedli04 bingedays8 anybnge04 hvysmk04 subscl2_8;

Array subvars_12(8) smoke12 drink12 pot12 coke12 bngdrnk12 anybng12 hvysmk12 subscl2_12;
Array subvars_13(8) smoke13 drink13 pot13 coke13 bngdrnk13 anybng13 hvysmk13 subscl2_13;
Array subvars_14(8) smoke14 drink14 pot14 coke14 bngdrnk14 anybng14 hvysmk14 subscl2_14;
Array subvars_15(8) smoke15 drink15 pot15 coke15 bngdrnk15 anybng15 hvysmk15 subscl2_15;
Array subvars_16(8) smoke16 drink16 pot16 coke16 bngdrnk16 anybng16 hvysmk16 subscl2_16;
Array subvars_17(8) smoke17 drink17 pot17 coke17 bngdrnk17 anybng17 hvysmk17 subscl2_17;
Array subvars_18(8) smoke18 drink18 pot18 coke18 bngdrnk18 anybng18 hvysmk18 subscl2_18;
Array subvars_19(8) smoke19 drink19 pot19 coke19 bngdrnk19 anybng19 hvysmk19 subscl2_19;
Array subvars_20(8) smoke20 drink20 pot20 coke20 bngdrnk20 anybng20 hvysmk20 subscl2_20;
Array subvars_21(8) smoke21 drink21 pot21 coke21 bngdrnk21 anybng21 hvysmk21 subscl2_21;
Array subvars_22(8) smoke22 drink22 pot22 coke22 bngdrnk22 anybng22 hvysmk22 subscl2_22;
Array subvars_23(8) smoke23 drink23 pot23 coke23 bngdrnk23 anybng23 hvysmk23 subscl2_23;
Array subvars_24(8) smoke24 drink24 pot24 coke24 bngdrnk24 anybng24 hvysmk24 subscl2_24;

%macro ageyrs (agevar, age, subagearray);
	Do i = 1 to 8 until (agenew(i) = &age);
		If agenew(i) = &age then &agevar = i;
	End;
	
	Do i = 1 to 8;
		If &agevar = 1 then &subagearray(i) = subvars_rnd1(i);
		If &agevar = 2 then &subagearray(i) = subvars_rnd2(i);
		If &agevar = 3 then &subagearray(i) = subvars_rnd3(i);
		If &agevar = 4 then &subagearray(i) = subvars_rnd4(i);
		If &agevar = 5 then &subagearray(i) = subvars_rnd5(i);
		If &agevar = 6 then &subagearray(i) = subvars_rnd6(i);
		If &agevar = 7 then &subagearray(i) = subvars_rnd7(i);
		If &agevar = 8 then &subagearray(i) = subvars_rnd8(i);
	End;
%mend;

%ageyrs (a12, 12, subvars_12);
%ageyrs (a13, 13, subvars_13);
%ageyrs (a14, 14, subvars_14);
%ageyrs (a15, 15, subvars_15);
%ageyrs (a16, 16, subvars_16);
%ageyrs (a17, 17, subvars_17);
%ageyrs (a18, 18, subvars_18);
%ageyrs (a19, 19, subvars_19);
%ageyrs (a20, 20, subvars_20);
%ageyrs (a21, 21, subvars_21);
%ageyrs (a22, 22, subvars_22);
%ageyrs (a23, 23, subvars_23);
%ageyrs (a24, 24, subvars_24);

label hvysmk16 = 'R is heavy/light smoker at age 16';
label hvysmk20 = 'R is heavy/light smoker at age 20';
label bngdrnk16 = "Number of days R has had 5+ drinks at least one day in past 30 days at age 16";
label bngdrnk20 = "Number of days R has had 5+ drinks at least one day in past 30 days at age 20";
Label anybng16 = "R has had 5+ drinks at least one day in past 30 days at age 16";
Label anybng20 = "R has had 5+ drinks at least one day in past 30 days at age 20";
label subscl2_16 = '2-Item Illegal-Substance Use Index (pot & hard drugs - DLI)at age 16';
label subscl2_20 = '2-Item Illegal-Substance Use Index (pot & hard drugs - DLI)at age 20';
label smoke16 = 'R has smoked since DLI at age 16';
label smoke20 = 'R has smoked since DLI at age 20';
label drink16 = 'R has drank alcohol since DLI at age 16';
label drink20 = 'R has drank alcohol since DLI at age 20';
label pot16  = 'R had used marijuana since DLI at age 16';
label pot20  = 'R had used marijuana since DLI at age 20';
label coke16 = "R had used hard drugs since DLI at age 16";
label coke20 = "R had used hard drugs since DLI at age 16";

format hvysmk16 hvysmk20 smoke_b.;
format smoke16 drink16 pot16 coke16 anybng16 
smoke20 drink20 pot20 coke20 anybng20 yes10no.;

/***********************************************************************************/
/************************************Delinquency Index*******************************/
/**********************************************************************************/
/*NOTE: FOR THE PURPOSES OF THE FAMILY STRENGTHS PAPER, ONLY THE 9-ITEM AND 8-ITEM (MINUS RUNAWAY) DLI
SCALES WERE USED. EVER SCALES ARE NOT BEING USED.*/
/*Note: There is a CT created delinquency index variable on dataset for R1-4. Was not created after that, 
need to create it.*/
/*Note, created delinq. index scores for R2-4 are DLI. I think I want ones creates with cumulative "ever"s*/
/*Note Fore 1998-2002, currently if there was a value for a "since DLI of "NO" but other years were missing, the "ever" value was
set to "No"*/

delinq97 = R1487700;
if R1487700 lt 0 then delinq97 = .;
label delinq97 = "Delinquency Index score, 1997";

delinq98dli = R2602000;
if R2602000 lt 0 then delinq98 = .;
label delinq98 = "Delinquency Index score, 1998, Since DLI";

delinq99dli = R3925200;
if R3925200 lt 0 then delinq99 = .;
label delinq99 = "Delinquency Index score, 1999, Since DLI";

delinq00dli = R5511500;
if R5511500 lt 0 then delinq00dli = .;
label delinq00dli = "Delinquency Index score, 2000, SInce DLI";

/*1997*/
array dlnqold(10) R0359500 R0359800 R0360500 R0360900 R0361000 R0361100 R0361200 R0361300 R0361400 R0365900;
array dlnqnew(10) runawy1 gun1 gang1 destprop1 steal50less1 steal50plus1 othprop1 attack1 selldrgs1 arrest1;

Do i = 1 to 10;
	If dlnqold(i) lt 0 then dlnqnew(i) = .;
	Else dlnqnew(i) = dlnqold(i);
End;

Label runawy1 = "R has run away, 1997";
Label gun1 = "R has carried a gun, 1997";
Label gang1 = "R has belonged to a gang, 1997";
Label destprop1 = "R has destroyed property, 1997";
Label steal50less1 = "R has stolen something worth less than $50, 1997";
Label steal50plus1 = "R has stolen something worth more than $50, 1997";
Label othprop1 = "R has coimmitted other property crimes, 1997";
Label attack1 = "R has attacked someone, 1997";
Label selldrgs1 = "R has sold drugs, 1997";
Label arrest1 = "R has been arrested, 1997";

/*9-Item Delinquency Index (With Runaway)*/
%let dlnqscl1b = gun1, gang1, destprop1, steal50less1, steal50plus1, othprop1, attack1, selldrgs1, runawy1;
	If nmiss(&dlnqscl1b) le 2 then dlnqscl9_1= Round((sum (&dlnqscl1b)*9)/(9-(nmiss(&dlnqscl1b))));
	Label dlnqscl9_1 = "9-Item Delinquency Index (With Runaway), 1997";

/*8-Item Delinquency Index (Without Runaway)*/
%let dlnqscl1c = gun1, gang1, steal50less1, steal50plus1, othprop1, attack1, selldrgs1, destprop1;
	If nmiss(&dlnqscl1c) le 2 then dlnqscl8a_1= Round((sum (&dlnqscl1c)*8)/(8-(nmiss(&dlnqscl1c))));
	Label dlnqscl8a_1 = "8-Item Delinquency Index (No runaway), 1997";

/*1998*/
/*The first thing we have to do is change all the DLI's to Evers*/
/*For all questions (except possibly gang questions) check was run to see if respondents answered the "ever"
	question. If no, then they were asked "ever". If they respond no to "ever" the loop ends for this item. If they 
	say yes at this point to "ever" they are asked "DLI" question. If the respondednt answered the "ever" question 
	in the previous round they are only asked the "DLI" question.*/

/*Run away from home - only asked if R was under 17*/
Array oldvar2(21) R2192100 R2192400 R2193100 R2194100 R2194800 R2195100 R2195400 R2195700 R2196000 R2196300 R2200100 
R2192700 R2193400 R2194400 R2194900 R2195200 R2195500 R2195800 R2196100 R2196400 R2200300;
Array newvar2(21) over17r2 runev2 gunev2 gangev2 propev2 stl50lsev2 stl50plev2 othprpev2 attackev2 drugsev2 arrestev2
rundlir2 gundli2 gangdli2 propdli2 stl50lsdli2 stl50pldli2 othprpdli2 attackdli2 drugsdli2 arrestdli2;

Do i = 1 to 21;
	If oldvar2(i) lt 0 then newvar2(i) = .;
	Else newvar2(i) = oldvar2(i);
End;
Label runev2 = "R has ever run away, 1998";
Label gunev2 = "R has ever carried a gun, 1998";
Label gangev2 = "R has ever belonged to a gang, 1998";
Label propev2 = "R has ever destroyed property, 1998";
Label stl50lsev2 = "R has stolen ever something worth less than $50, 1998";
Label stl50plev2 = "R hasever stolen something worth more than $50, 1998";
Label othprpev2 = "R has ever coimmitted other property crimesI, 1998";
Label attackev2 = "R has ever attacked someone, 1998";
Label drugsev2 = "R has ever sold drugs, 1998";
Label arrestev2 = "R has ever been arrested, 1998";
Label over17r2 = "R was 17 or over at interview, 1998";
Label rundlir2 = "R has run away since DLI, 1998";
Label gundli2 = "R has carried a gun since DLI, 1998";
Label gangdli2 = "R has belonged to a gang since DLI, 1998";
Label propdli2 = "R has destroyed property since DLI, 1998";
Label stl50lsdli2 = "R has stolen something worth less than $50 since DLI, 1998";
Label stl50pldli2 = "R hasstolen something worth more than $50 since DLI, 1998";
Label othprpdli2 = "R has coimmitted other property crimes since DLI, 1998";
Label attackdli2 = "R has attacked someone since DLI, 1998";
Label drugsdli2 = "R has sold drugs since DLI, 1998";
Label arrestdli2 = "R has been arrested since DLI, 1998";

%delinqdli (S1529901, R2192200, runev2, rundlir2, rundli98, 1998, label=run away);
%delinqdli (S1529901, R2192900, gunev2, gundli2, gundli98, 1998, label=carried a gun);
%delinqdli (S1529901, R2194700, propev2, propdli2, despropdli98, 1998, label=destroyed property);
%delinqdli (S1529901, R2195000, stl50lsev2, stl50lsdli2, stl50lsdli98, 1998, label=stolen less than fifty);
%delinqdli (S1529901, R2195300, stl50plev2, stl50pldli2, stl50pldli98, 1998, label=stolen more than fifty);
%delinqdli (S1529901, R2195600, othprpev2,othprpdli2, othprpdli98, 1998, label=commited other prop crimes);
%delinqdli (S1529901, R2195900, attackev2, attackdli2, attackdli98, 1998, label=attacked someone);
%delinqdli (S1529901, R2196200, drugsev2, drugsdli2, drugsdli98, 1998, label=sold drugs);
%delinqdli (S1529901, R2200000, arrestev2, arrestdli2, arrestdli98, 1998, label=been arrested);

If S1529901 = 0 then gangdli98 = .; /*Did not complete R2*/
Else if gangev2 = 0 then gangdli98 = 0; /*Has never done ...*/
Else if gangdli2 = 0 then gangdli98 = 0; /*Has never done ...*/
Else if gangdli2 = 1 then gangdli98 = 1;  /*Had done ... since dli*/
Label gangdli98 = "R has been a member of a gang sinse DLI, 1998";
Format gangdli98 yes10no.;

/*Index*/
/*9-Item Delinquency Index (With Runaway)*/
%let dlnqscl2b = gundli98, gangdli98, despropdli98, stl50lsdli98, stl50pldli98, othprpdli98, attackdli98, drugsdli98, rundli98;
	If nmiss(&dlnqscl2b) le 2 then dlnqscl9_2= Round((sum (&dlnqscl2b)*9)/(9-(nmiss(&dlnqscl2b))));
	Label dlnqscl9_2 = "9-Item Delinquency Index (DLI), (with runaway), 1998";

/*8-Item Delinquency Index (Without Runaway)*/
%let dlnqscl2c = gundli98, gangdli98, stl50lsdli98, stl50pldli98, othprpdli98, attackdli98, drugsdli98, propdli2;
	If nmiss(&dlnqscl2c) le 2 then dlnqscl8a_2= Round((sum (&dlnqscl2c)*8)/(8-(nmiss(&dlnqscl2c))));
	Label dlnqscl8a_2 = "8-Item Delinquency Index (DLI), (without runaway), 1998";

%everusez (runev2,runawy1, rundli98, everrun2, 1998, label=run away);
%everusez (runev2,runawy1, rundli98, everrun2, 1998, label=run away);
%everusez (gunev2, gun1, gundli98, evergun2, 1998, label=carry a gun);
%everusez (gangev2, gang1, gangdli98, evergang2, 1998, label=belonged to a gang);
%everusez (propev2, destprop1, despropdli98, everdesprp2, 1998, label=destroy property);
%everusez (stl50lsev2, steal50less1, stl50lsdli98, evstl50ls2, 1998, label=steal less than fifty);
%everusez (stl50plev2, steal50plus1, stl50pldli98, evstl50pl2, 1998, label=steal more than fifty);
%everusez (othprpev2, othprop1, othprpdli98, evothprp2, 1998, label=commit other prop crimes);
%everusez (attackev2, attack1, attackdli98, evattack2, 1998, label=attack someone);
%everusez (drugsev2, selldrgs1, drugsdli98, evdrugs2, 1998, label=sell drugs);
%everusez (arrestev2, arrest1, arrestdli98, evarrest2, 1998, label=been arrested);

/*Index*/
/*10-Item Delinquency Index (Includes all)*/
%let dlnqscl2d = everrun2, evergun2, evergang2, everdesprp2, evstl50ls2, evstl50pl2, evothprp2, evattack2, evdrugs2, evarrest2;
	If nmiss(&dlnqscl2d) le 2 then dlnqscl10_2b= Round((sum (&dlnqscl2d)*10)/(10-(nmiss(&dlnqscl2d))));
	Label dlnqscl10_2b = "10-Item Delinquency Index (EVER by R2), 1998";

/*9-Item Delinquency Index (without runaway)*/
%let dlnqscl2e = evergun2, evergang2, everdesprp2, evstl50ls2, evstl50pl2, evothprp2, evattack2, evdrugs2, evarrest2;
	If nmiss(&dlnqscl2e) le 2 then dlnqscl9_2b= Round((sum (&dlnqscl2e)*9)/(9-(nmiss(&dlnqscl2e))));
	Label dlnqscl9_2b = "9-Item Delinquency Index (EVER by R2) (without runaway), 1998";

/*8-Item Delinquency Index (without runaway & arrest)*/
%let dlnqscl2f = evergun2, evergang2, evstl50ls2, evstl50pl2, evothprp2, evattack2, evdrugs2, everdesprp2;
	If nmiss(&dlnqscl2f) le 2 then dlnqscl8a_2b= Round((sum (&dlnqscl2f)*8)/(8-(nmiss(&dlnqscl2f))));
	Label dlnqscl8a_2b = "8-Item Delinquency Index (EVER by R2) (without runaway & arrests), 1998";

/*8-Item Delinquency Index (without runaway & gangs)*/
%let dlnqscl2ff = evergun2, everdesprp2, evstl50ls2, evstl50pl2, evothprp2, evattack2, evdrugs2, evarrest2;
	If nmiss(&dlnqscl2ff) le 2 then dlnqscl8b_2b= Round((sum (&dlnqscl2ff)*8)/(8-(nmiss(&dlnqscl2ff))));
	Label dlnqscl8b_2b = "8-Item Delinquency Index (EVER by R2) (without runaway & gangs), 1998";

/*1999*/
/*The first thing we have to do is change all the DLI's to Evers*/

/*Run away from home - only asked if R was under 17*/
Array oldvar(21) R3511600 R3511900 R3512700 R3513700 R3514400 R3514700 R3515000 R3515300 R3515600 R3515900 R3519700 
R3512300 R3513000 R3514000 R3514500 R3514800 R3515100 R3515400 R3515700 R3516000 R3519900;
Array newvar(21) over17r3 runev3 gunev3 gangev3 propev3 stl50lsev3 stl50plev3 othprpev3 attackev3 drugsev3 arrestev3 
rundlir3 gundli3 gangdli3 propdli3 stl50lsdli3 stl50pldli3 othprpdli3 attackdli3 drugsdli3 arrestdli3;

Do i = 1 to 21;
	If oldvar(i) lt 0 then newvar(i) = .;
	Else newvar(i) = oldvar(i);
End;
Label runev3 = "R has ever run away, 1999";
Label gunev3 = "R has ever carried a gun, 1999";
Label gangev3 = "R has ever belonged to a gang , 1999";
Label propev3 = "R has ever destroyed property, 1999";
Label stl50lsev3 = "R has ever stolen something worth less than $50, 1999";
Label stl50plev3 = "R has ever stolen something worth more than $50, 1999";
Label othprpev3 = "R has ever coimmitted other property crimes, 1999";
Label attackev3 = "R has ever attacked someone, 1999";
Label drugsev3 = "R has ever sold drugs, 1999";
Label arrestev3 = "R has ever been arrested, 1999";
Label over17r3 = "R was 17 or over at interview, 1999";
Label rundlir3 = "R has run away since DLI, 1999";
Label gundli3 = "R has carried a gun since DLI, 1999";
Label gangdli3 = "R has belonged to a gang since DLI, 1999";
Label propdli3 = "R has destroyed property since DLI, 1999";
Label stl50lsdli3 = "R has stolen something worth less than $50 since DLI, 1999";
Label stl50pldli3 = "R hasstolen something worth more than $50 since DLI, 1999";
Label othprpdli3 = "R has coimmitted other property crimes since DLI, 1999";
Label attackdli3 = "R has attacked someone since DLI, 1999";
Label drugsdli3 = "R has sold drugs since DLI, 1999";
Label arrestdli3 = "R has been arrested since DLI, 1999";

/*Since DLI Only*/

%delinqdli (S1529902, R3511700, runev3, rundlir3, rundli99, 1999, label=run away);
%delinqdli (S1529902, R3512500, gunev3, gundli3, gundli99, 1999, label=carried a gun);
%delinqdli (S1529902, R3514300, propev3, propdli3, despropdli99, 1999, label=destroyed property);
%delinqdli (S1529902, R3514600, stl50lsev3, stl50lsdli3, stl50lsdli99, 1999, label=stolen less than fifty);
%delinqdli (S1529902, R3514900, stl50plev3, stl50pldli3, stl50pldli99, 1999, label=stolen more than fifty);
%delinqdli (S1529902, R3515200, othprpev3,othprpdli3, othprpdli99, 1999, label=commited other prop crimes);
%delinqdli (S1529902, R3515500, attackev3, attackdli3, attackdli99, 1999, label=attacked someone);
%delinqdli (S1529902, R3515800, drugsev3, drugsdli3, drugsdli99, 1999, label=sold drugs);
%delinqdli (S1529902, R3519600, arrestev3, arrestdli3, arrestdli99, 1999, label=been arrested);

If S1529902 = 0 then gangdli99 = .; /*Did not complete R3*/
Else if gangev3 = 0 then gangdli99 = 0; /*Has never done ...*/
Else if gangdli3 = 0 then gangdli99 = 0; /*Has never done ...*/
Else if gangdli3 = 1 then gangdli99 = 1;  /*Had done ... since dli*/
Label gangdli99 = "R has been a member of a gang sinse DLI, 1999";
Format gangdli99 yes10no.;

/*Index*/
/*9-Item Delinquency Index (With Runaway)*/
%let dlnqscl3b = gundli99, gangdli99, despropdli99, stl50lsdli99, stl50pldli99, othprpdli99, attackdli99, drugsdli99, rundli99;
	If nmiss(&dlnqscl3b) le 2 then dlnqscl9_3= Round((sum (&dlnqscl3b)*9)/(9-(nmiss(&dlnqscl3b))));
	Label dlnqscl9_3 = "9-Item Delinquency Index (DLI), (with runaway), 1999";

/*8-Item Delinquency Index (Without Runaway)*/
%let dlnqscl3c = gundli99, gangdli99, stl50lsdli99, stl50pldli99, othprpdli99, attackdli99, drugsdli99, despropdli99;
	If nmiss(&dlnqscl3c) le 2 then dlnqscl8a_3= Round((sum (&dlnqscl3c)*8)/(8-(nmiss(&dlnqscl3c))));
	Label dlnqscl8a_3 = "8-Item Delinquency Index (DLI), (without runaway), 1999";

%everusez (runev3, everrun2, rundli99, everrun3, 1999, label=run away);
%everusez (gunev3, evergun2, gundli99, evergun3, 1999, label=carry a gun);
%everusez (gangev3, evergang2, gangdli99, evergang3, 1999, label=belong to a gang);
%everusez (propev3, everdesprp2, despropdli99, everdesprp3, 1999, label=destroy property);
%everusez (stl50lsev3, evstl50ls2, stl50lsdli99, evstl50ls3, 1999, label=steal less than fifty);
%everusez (stl50plev3, evstl50pl2, stl50pldli99, evstl50pl3, 1999, label=steal more than fifty);
%everusez (othprpev3, evothprp2, othprpdli99, evothprp3, 1999, label=commit other prop crimes);
%everusez (attackev3, evattack2, attackdli99, evattack3, 1999, label=attack someone);
%everusez (drugsev3, evdrugs2, drugsdli99, evdrugs3, 1999, label=sell drugs);
%everusez (arrestev3, evarrest2, arrestdli99, evarrest3, 1999, label=been arrested);

/*Index*/
/*10-Item Delinquency Index (Includes all)*/
%let dlnqscl3d = everrun3, evergun3, evergang3, everdesprp3, evstl50ls3, evstl50pl3, evothprp3, evattack3, evdrugs3, evarrest3;
	If nmiss(&dlnqscl3d) le 2 then dlnqscl10_3b= Round((sum (&dlnqscl3d)*10)/(10-(nmiss(&dlnqscl3d))));
	Label dlnqscl10_3b = "10-Item Delinquency Index (EVER by R3), 1999";

/*9-Item Delinquency Index (without runaway)*/
%let dlnqscl3e = evergun3, evergang3, everdesprp3, evstl50ls3, evstl50pl3, evothprp3, evattack3, evdrugs3, evarrest3;
	If nmiss(&dlnqscl3e) le 2 then dlnqscl9_3b= Round((sum (&dlnqscl3e)*9)/(9-(nmiss(&dlnqscl3e))));
	Label dlnqscl9_3b = "9-Item Delinquency Index (EVER by R3) (without runaway), 1999";

/*8-Item Delinquency Index (without runaway & arrest)*/
%let dlnqscl3f = evergun3, evergang3, evstl50ls3, evstl50pl3, evothprp3, evattack3, evdrugs3, everdesprp3;
	If nmiss(&dlnqscl3f) le 2 then dlnqscl8a_3b= Round((sum (&dlnqscl3f)*8)/(8-(nmiss(&dlnqscl3f))));
	Label dlnqscl8a_3b = "8-Item Delinquency Index (EVER by R3) (without runaway & arrest), 1999";

/*8-Item Delinquency Index (without runaway & gangs)*/
%let dlnqscl3ff = evergun3, everdesprp3, evstl50ls3, evstl50pl3, evothprp3, evattack3, evdrugs3, evarrest3;
	If nmiss(&dlnqscl3ff) le 2 then dlnqscl8b_3b= Round((sum (&dlnqscl3ff)*8)/(8-(nmiss(&dlnqscl3ff))));
	Label dlnqscl8b_3b = "8-Item Delinquency Index (EVER by R3) (without runaway & gangs), 1999";

/*2000*/
/*The first thing we have to do is change all the DLI's to Evers*/

/*Run away from home - only asked if R was under 17*/
Array old4(21) R4909700 R4910000 R4910700 R4911700 R4912400 R4912700 R4913000 R4913300 R4913600 R4913900 R4917700
R4910300 R4911000 R4912000 R4912500 R4912800 R4913100 R4913400 R4913700 R4914000 R4917800;
Array new4(21) over17r4 runev4 gunev4 gangev4 propev4 stl50lsev4 stl50plev4 othprpev4 attackev4 drugsev4 arrestev4 
rundlir4 gundli4 gangdli4 propdli4 stl50lsdli4 stl50pldli4 othprpdli4 attackdli4 drugsdli4 arrestdli4;

Do i = 1 to 21;
	If old4(i) lt 0 then new4(i) = .;
	Else new4(i) = old4(i);
End;
Label runev4 = "R has ever run away, 2000";
Label gunev4 = "R has ever carried a gun, 2000";
Label gangev4 = "R has ever belonged to a gang , 2000";
Label propev4 = "R has ever destroyed property, 2000";
Label stl50lsev4 = "R has ever stolen something worth less than $50, 2000";
Label stl50plev4 = "R has ever stolen something worth more than $50, 2000";
Label othprpev4 = "R has ever coimmitted other property crimes, 2000";
Label attackev4 = "R has ever attacked someone, 2000";
Label drugsev4 = "R has ever sold drugs, 2000";
Label arrestev4 = "R has ever been arrested, 2000";
Label over17r4 = "R was 17 or over at interview, 2000";
Label rundlir4 = "R has run away since DLI, 2000";
Label gundli4 = "R has carried a gun since DLI, 2000";
Label gangdli4 = "R has belonged to a gang since DLI, 2000";
Label propdli4 = "R has destroyed property since DLI, 2000";
Label stl50lsdli4 = "R has stolen something worth less than $50 since DLI, 2000";
Label stl50pldli4 = "R hasstolen something worth more than $50 since DLI, 2000";
Label othprpdli4 = "R has coimmitted other property crimes since DLI, 2000";
Label attackdli4 = "R has attacked someone since DLI, 2000";
Label drugsdli4 = "R has sold drugs since DLI, 2000";
Label arrestdli4 = "R has been arrested since DLI, 2000";

/*Since DLI Only*/

%delinqdli (S1529903, R4909800, runev4, rundlir4, rundli00, 2000, label=run away);
%delinqdli (S1529903, R4910500, gunev4, gundli4, gundli00, 2000, label=carried a gun);
%delinqdli (S1529903, R4912300, propev4, propdli4, despropdli00, 2000, label=destroyed property);
%delinqdli (S1529903, R4912600, stl50lsev4, stl50lsdli4, stl50lsdli00, 2000, label=stolen less than fifty);
%delinqdli (S1529903, R4912900, stl50plev4, stl50pldli4, stl50pldli00, 2000, label=stolen more than fifty);
%delinqdli (S1529903, R4913200, othprpev4,othprpdli4, othprpdli00, 2000, label=commited other prop crimes);
%delinqdli (S1529903, R4913500, attackev4, attackdli4, attackdli00, 2000, label=attacked someone);
%delinqdli (S1529903, R4913800, drugsev4, drugsdli4, drugsdli00, 2000, label=sold drugs);
%delinqdli (S1529903, R4917600, arrestev4, arrestdli4, arrestdli00, 2000, label=been arrested);

If S1529903 = 0 then gangdli00 = .; /*Did not complete R4*/
Else if gangev4 = 0 then gangdli00 = 0; /*Has never done ...*/
Else if gangdli4 = 0 then gangdli00 = 0; /*Has never done ...*/
Else if gangdli4 = 1 then gangdli00 = 1;  /*Had done ... since dli*/
Label gangdli00 = "R has been a member of a gang sinse DLI, 2000";
Format gangdli00 yes10no.;

/*Index*/
/*9-Item Delinquency Index (With Runaway)*/
%let dlnqscl4b = gundli00, gangdli00, despropdli00, stl50lsdli00, stl50pldli00, othprpdli00, attackdli00, drugsdli00, rundli00;
	If nmiss(&dlnqscl4b) le 2 then dlnqscl9_4= Round((sum (&dlnqscl4b)*9)/(9-(nmiss(&dlnqscl4b))));
	Label dlnqscl9_4 = "9-Item Delinquency Index (DLI), (with runaway), 2000";

/*8-Item Delinquency Index (Without Runaway)*/
%let dlnqscl4c = gundli00, gangdli00, stl50lsdli00, stl50pldli00, othprpdli00, attackdli00, drugsdli00, despropdli00;
	If nmiss(&dlnqscl4c) le 2 then dlnqscl8a_4= Round((sum (&dlnqscl4c)*8)/(8-(nmiss(&dlnqscl4c))));
	Label dlnqscl8a_4 = "8-Item Delinquency Index (DLI), (without runaway), 2000";

%everusez (runev4, everrun3, rundli00, everrun4, 2000, label=run away);
%everusez (gunev4, evergun3, gundli00, evergun4, 2000, label=carry a gun);
%everusez (gangev4, evergang3, gangdli00, evergang4, 2000, label=belong to a gang);
%everusez (propev4, everdesprp3, despropdli00, everdesprp4, 2000, label=destroy property);
%everusez (stl50lsev4,evstl50ls3, stl50lsdli00, evstl50ls4, 2000, label=steal less than fifty);
%everusez (stl50plev4, evstl50pl3, stl50pldli00, evstl50pl4, 2000, label=steal more than fifty);
%everusez (othprpev4, evothprp3, othprpdli00, evothprp4, 2000, label=commit other prop crimes);
%everusez (attackev4, evattack3, attackdli00, evattack4, 2000, label=attack someone);
%everusez (drugsev4, evdrugs3, drugsdli00, evdrugs4, 2000, label=sell drugs);
%everusez (arrestev4, evarrest3, arrestdli00, evarrest4, 2000, label=been arrested);

/*Index*/
/*10-Item Delinquency Index (Includes all)*/
%let dlnqscl4d = everrun4, evergun4, evergang4, everdesprp4, evstl50ls4, evstl50pl4, evothprp4, evattack4, evdrugs4, evarrest4;
	If nmiss(&dlnqscl4d) le 2 then dlnqscl10_4b= Round((sum (&dlnqscl4d)*10)/(10-(nmiss(&dlnqscl4d))));
	Label dlnqscl10_4b = "10-Item Delinquency Index (EVER by R4), 2000";

/*9-Item Delinquency Index (without runaway)*/
%let dlnqscl4e = evergun4, evergang4, everdesprp4, evstl50ls4, evstl50pl4, evothprp4, evattack4, evdrugs4, evarrest4;
	If nmiss(&dlnqscl4e) le 2 then dlnqscl9_4b= Round((sum (&dlnqscl4e)*9)/(9-(nmiss(&dlnqscl4e))));
	Label dlnqscl9_4b = "9-Item Delinquency Index (EVER by R4) (without runaway), 2000";

/*8-Item Delinquency Index (without runaway & arrest)*/
%let dlnqscl4f = evergun4, evergang4, evstl50ls4, evstl50pl4, evothprp4, evattack4, evdrugs4, everdesprp4;
	If nmiss(&dlnqscl4f) le 2 then dlnqscl8a_4b= Round((sum (&dlnqscl4f)*8)/(8-(nmiss(&dlnqscl4f))));
	Label dlnqscl8a_4b = "8-Item Delinquency Index (EVER by R4) (without runaway & arrest), 2000";

/*8-Item Delinquency Index (without runaway & gangs)*/
%let dlnqscl4ff = evergun4, everdesprp4, evstl50ls4, evstl50pl4, evothprp4, evattack4, evdrugs4, evarrest4;
	If nmiss(&dlnqscl4ff) le 2 then dlnqscl8b_4b= Round((sum (&dlnqscl4ff)*8)/(8-(nmiss(&dlnqscl4ff))));
	Label dlnqscl8b_4b = "8-Item Delinquency Index (EVER by R4) (without runaway & gangs), 2000";

/*2001*/
/*The first thing we have to do is change all the DLI's to Evers*/
/*Run away from home - only asked if R was under 17*/
/*Starting in 2001, except for gang membership respondents were not asked, "ever". 
They were only asked the "DLI" question.This is actually because there were 0 resp.
who were missing data from previous year.*/

Array old5(12) R6536900 R6537400 R6538100 R6539100 R6539500 R6539700 R6539900 R6540100 R6540300 R6540500 R6544700 R6538800;
Array new5(12) over17r5 rundlir5 gundli5 gangdli5 propdli5 stl50lsdli5 stl50pldli5 othprpdli5 attackdli5 drugsdli5 arrestdli5 gangev5;

Do i = 1 to 12;
	If old5(i) lt 0 then new5(i) = .;
	Else new5(i) = old5(i);
End;
Label gangev5 = "R has ever belonged to a gang , 2001";
Label over17r5 = "R was 17 or over at interview, 2001";
Label rundlir5 = "R has run away since DLI, 2001";
Label gundli5 = "R has carried a gun since DLI, 2001";
Label gangdli5 = "R has belonged to a gang since DLI, 2001";
Label propdli5 = "R has destroyed property since DLI, 2001";
Label stl50lsdli5 = "R has stolen something worth less than $50 since DLI, 2001";
Label stl50pldli5 = "R hasstolen something worth more than $50 since DLI, 2001";
Label othprpdli5 = "R has coimmitted other property crimes since DLI, 2001";
Label attackdli5 = "R has attacked someone since DLI, 2001";
Label drugsdli5 = "R has sold drugs since DLI, 2001";
Label arrestdli5 = "R has been arrested since DLI, 2001";

%delinqdli2 (S1529904, rundlir5, rundli01, 2001, label=run away);
%delinqdli2 (S1529904, gundli5, gundli01, 2001, label=carried a gun);
%delinqdli2 (S1529904, propdli5, despropdli01, 2001, label=destroyed property);
%delinqdli2 (S1529904, stl50lsdli5, stl50lsdli01, 2001, label=stolen less than fifty);
%delinqdli2 (S1529904, stl50pldli5, stl50pldli01, 2001, label=stolen more than fifty);
%delinqdli2 (S1529904,othprpdli5, othprpdli01, 2001, label=commited other prop crimes);
%delinqdli2 (S1529904, attackdli5, attackdli01, 2001, label=attacked someone);
%delinqdli2 (S1529904, drugsdli5, drugsdli01, 2001, label=sold drugs);
%delinqdli2 (S1529904, arrestdli5, arrestdli01, 2001, label=been arrested);

If S1529904 = 0 then gangdli01 = .; /*Did not complete R5*/
Else if gangev5 = 0 then gangdli01 = 0; /*Has never done ...*/
Else if gangdli5 = 0 then gangdli01 = 0; /*Has never done ...*/
Else if gangdli5 = 1 then gangdli01 = 1;  /*Had done ... since dli*/
Label gangdli01 = "R has been a member of a gang sinse DLI, 2001";
Format gangdli01 yes10no.;

/*Index*/
/*9-Item Delinquency Index (With Runaway)*/
%let dlnqscl5b = gundli01, gangdli01, despropdli01, stl50lsdli01, stl50pldli01, othprpdli01, attackdli01, drugsdli01, rundli01;
	If nmiss(&dlnqscl5b) le 2 then dlnqscl9_5= Round((sum (&dlnqscl5b)*9)/(9-(nmiss(&dlnqscl5b))));
	Label dlnqscl9_5 = "9-Item Delinquency Index (DLI), (with runaway), 2001";

/*8-Item Delinquency Index (Without Runaway)*/
%let dlnqscl5c = gundli01, gangdli01, stl50lsdli01, stl50pldli01, othprpdli01, attackdli01, drugsdli01, despropdli01;
	If nmiss(&dlnqscl5c) le 2 then dlnqscl8a_5= Round((sum (&dlnqscl5c)*8)/(8-(nmiss(&dlnqscl5c))));
	Label dlnqscl8a_5 = "8-Item Delinquency Index (DLI), (without runaway), 2001";

%everusez2 (everrun4, rundli01, everrun5, 2001, label=run away);
%everusez2 (evergun4, gundli01, evergun5, 2001, label=carry a gun);
%everusez (gangev5, evergang4, gangdli01, evergang5, 2001, label=belonged to a gang);
%everusez2 (everdesprp4, despropdli01, everdesprp5, 2001, label=destroy property);
%everusez2 (evstl50ls4, stl50lsdli01, evstl50ls5, 2001, label=steal less than fifty);
%everusez2 (evstl50pl4, stl50pldli01, evstl50pl5, 2001, label=steal more than fifty);
%everusez2 (evothprp4, othprpdli01, evothprp5, 2001, label=commit other prop crimes);
%everusez2 (evattack4, attackdli01, evattack5, 2001, label=attack someone);
%everusez2 (evdrugs4, drugsdli01, evdrugs5, 2001, label=sell drugs);
%everusez2 (evarrest4, arrestdli01, evarrest5, 2001, label=been arrested);

/*Index*/
/*9-Item Delinquency Index (withrunaway)*/
%let dlnqscl5e = evergun5, evergang5, everdesprp5, evstl50ls5, evstl50pl5, evothprp5, evattack5, evdrugs5, everrun5;
	If nmiss(&dlnqscl5e) le 2 then dlnqscl9_5b= Round((sum (&dlnqscl5e)*9)/(9-(nmiss(&dlnqscl5e))));
	Label dlnqscl9_5b = "9-Item Delinquency Index (EVER by R5) (with runaway), 2001";

/*8-Item Delinquency Index (without runaway & arrest)*/
%let dlnqscl5f = evergun5, evergang5, evstl50ls5, evstl50pl5, evothprp5, evattack5, evdrugs5, everdesprp5;
	If nmiss(&dlnqscl5f) le 2 then dlnqscl8a_5b= Round((sum (&dlnqscl5f)*8)/(8-(nmiss(&dlnqscl5f))));
	Label dlnqscl8a_5b = "8-Item Delinquency Index (EVER by R5) (without runaway), 2001";

/*2002*/
/*The first thing we have to do is change all the DLI's to Evers*/
/*Run away from home - only asked if R was under 17*/
/*Starting in 2001, except for gang membership respondents were not asked, "ever". They were only asked the "DLI" question.*/

Array old6(11) S0924500 S0925000 S0925600 S0926600 S0926900 S0927100 S0927300 S0927500 S0927800 S0928000 S0926300;
Array new6(11) over17r6 rundlir6 gundli6 gangdli6 propdli6 stl50lsdli6 stl50pldli6 othprpdli6 attackdli6 drugsdli6  gangev6;

Do i = 1 to 11;
	If old6(i) lt 0 then new6(i) = .;
	Else new6(i) = old6(i);
End;
Label gangev6 = "R has belonged to a gang , 2002";
Label over17r6 = "R was 17 or over at interview, 2002";
Label rundlir6 = "R has run away since DLI, 2002";
Label gundli6 = "R has carried a gun since DLI, 2002";
Label gangdli6 = "R has belonged to a gang since DLI, 2002";
Label propdli6 = "R has destroyed property since DLI, 2002";
Label stl50lsdli6 = "R has stolen something worth less than $50 since DLI, 2002";
Label stl50pldli6 = "R hasstolen something worth more than $50 since DLI, 2002";
Label othprpdli6 = "R has coimmitted other property crimes since DLI, 2002";
Label attackdli6 = "R has attacked someone since DLI, 2002";
Label drugsdli6 = "R has sold drugs since DLI, 2002";

%delinqdli2 (S1529905, rundlir6, rundli02, 2002, label=run away);
%delinqdli2 (S1529905, gundli6, gundli02, 2002, label=carried a gun);
%delinqdli2 (S1529905, propdli6, despropdli02, 2002, label=destroyed property);
%delinqdli2 (S1529905, stl50lsdli6, stl50lsdli02, 2002, label=stolen less than fifty);
%delinqdli2 (S1529905, stl50pldli6, stl50pldli02, 2002, label=stolen more than fifty);
%delinqdli2 (S1529905, othprpdli6, othprpdli02, 2002, label=commited other prop crimes);
%delinqdli2 (S1529905, attackdli6, attackdli02, 2002, label=attacked someone);
%delinqdli2 (S1529905, drugsdli6, drugsdli02, 2002, label=sold drugs);

If S1529905 = 0 then gangdli02 = .; /*Did not complete R6*/
Else if gangev6 = 0 then gangdli02 = 0; /*Has never done ...*/
Else if gangdli6 = 0 then gangdli02 = 0; /*Has never done ...*/
Else if gangdli6 = 1 then gangdli02 = 1;  /*Had done ... since dli*/
Label gangdli02 = "R has been a member of a gang sinse DLI, 2002";
Format gangdli02 yes10no.;

/*Index*/
/*9-Item Delinquency Index (With Runaway)*/
%let dlnqscl6b = gundli02, gangdli02, despropdli02, stl50lsdli02, stl50pldli02, othprpdli02, attackdli02, drugsdli02, rundli02;
	If nmiss(&dlnqscl6b) le 2 then dlnqscl9_6= Round((sum (&dlnqscl6b)*9)/(9-(nmiss(&dlnqscl6b))));
	Label dlnqscl9_6 = "9-Item Delinquency Index (DLI), (with runaway), 2002";

/*8-Item Delinquency Index (Without Runaway)*/
%let dlnqscl6c = gundli02, gangdli02, stl50lsdli02, stl50pldli02, othprpdli02, attackdli02, drugsdli02, despropdli02;
	If nmiss(&dlnqscl6c) le 2 then dlnqscl8a_6= Round((sum (&dlnqscl6c)*8)/(8-(nmiss(&dlnqscl6c))));
	Label dlnqscl8a_6 = "8-Item Delinquency Index (DLI), (without runaway), 2002";

/*This variable is EVER BY Round 3 meaning, if they did it in R1 and not in R2, they still have a value of YES for this 
Variable, not just SDLI******************************************************/

%everusez2 (everrun5, rundli02, everrun6, 2002, label=run away);
%everusez2 (evergun5, gundli02, evergun6, 2002, label=carry a gun);
%everusez (gangev6, evergang5, gangdli02, evergang6, 2002, label=belonged to a gang);
%everusez2 (everdesprp5, despropdli02, everdesprp6, 2002, label=destroy property);
%everusez2 (evstl50ls5, stl50lsdli02, evstl50ls6, 2002, label=steal less than fifty);
%everusez2 (evstl50pl5, stl50pldli02, evstl50pl6, 2002, label=steal more than fifty);
%everusez2 (evothprp5, othprpdli02, evothprp6, 2002, label=commit other prop crimes);
%everusez2 (evattack5, attackdli02, evattack6, 2002, label=attack someone);
%everusez2 (evdrugs5, drugsdli02, evdrugs6, 2002, label=sell drugs);

/*Index*/
/*9-Item Delinquency Index (with runaway)*/
%let dlnqscl6e = evergun6, evergang6, everdesprp6, evstl50ls6, evstl50pl6, evothprp6, evattack6, evdrugs6, everrun6;
	If nmiss(&dlnqscl6e) le 2 then dlnqscl9_6b= Round((sum (&dlnqscl6e)*9)/(9-(nmiss(&dlnqscl6e))));
	Label dlnqscl9_6b = "9-Item Delinquency Index (EVER by R6) (with runaway), 2002";

/*8-Item Delinquency Index (without runaway)*/
%let dlnqscl6f = evergun6, evergang6, evstl50ls6, evstl50pl6, evothprp6, evattack6, evdrugs6, everdesprp6;
	If nmiss(&dlnqscl6f) le 2 then dlnqscl8a_6b= Round((sum (&dlnqscl6f)*8)/(8-(nmiss(&dlnqscl6f))));
	Label dlnqscl8a_6b = "8-Item Delinquency Index (EVER by R6) (without runaway), 2002";

/*2003*/
/*The first thing we have to do is change all the DLI's to Evers*/
/*Run away from home - only asked if R was under 17*/
/*Starting in 2001, except for gang membership respondents were not asked, "ever". They were only asked the "DLI" question.*/

Array old7(10)   S2991000 S2991900 S2991200 S2992200 S2992400 S2992600 S2992900 S2993400 S2993800 S2994000 ;
Array new7(10)  gunev7 gangev7 gundli7 gangdli7 propdli7 stl50lsdli7 stl50pldli7 othprpdli7 attackdli7 drugsdli7 ;

Do i = 1 to 10;
	If old7(i) lt 0 then new7(i) = .;
	Else new7(i) = old7(i);
End;
Label gunev7 = "R has ever carried a gun , 2003";
Label gangev7 = "R has belonged to a gang , 2003";
Label gundli7 = "R has carried a gun since DLI, 2003";
Label gangdli7 = "R has belonged to a gang since DLI, 2003";
Label propdli7 = "R has destroyed property since DLI, 2003";
Label stl50lsdli7 = "R has stolen something worth less than $50 since DLI, 2003";
Label stl50pldli7 = "R has stolen something worth more than $50 since DLI, 2003";
Label othprpdli7 = "R has coimmitted other property crimes since DLI, 2003";
Label attackdli7 = "R has attacked someone since DLI, 2003";
Label drugsdli7 = "R has sold drugs since DLI, 2003";

%delinqdli (S1529906, S2990800, gunev7, gundli7, gundli03, 2003, label=carried a gun);
%delinqdli2 (S1529906, propdli7, despropdli03, 2003, label=destroyed property);
%delinqdli2 (S1529906, stl50lsdli7, stl50lsdli03, 2003, label=stolen less than fifty);
%delinqdli2 (S1529906, stl50pldli7, stl50pldli03, 2003, label=stolen more than fifty);
%delinqdli2 (S1529906, othprpdli7, othprpdli03, 2003, label=commited other prop crimes);
%delinqdli2 (S1529906, attackdli7, attackdli03, 2003, label=attacked someone);
%delinqdli2 (S1529906, drugsdli7, drugsdli03, 2003, label=sold drugs);

If gangev7 = 0 then gangdli03 = 0; /*Has never done ...*/
Else if gangdli7 = 0 then gangdli03 = 0; /*Has never done ...*/
Else if gangdli7 = 1 then gangdli03 = 1;  /*Had done ... since dli*/
Label gangdli03 = "R has been a member of a gang sinse DLI, 2003";
Format gangdli03 yes10no.;

%everusez2 (everrun6, rundli03, everrun7, 2003, label=run away);
%everusez2 (evergun6, gundli03, evergun7, 2003, label=carry a gun);
%everusez (gangev7, evergang6, gangdli03, evergang7, 2003, label=belonged to a gang);
%everusez2 (everdesprp6, despropdli03, everdesprp7, 2003, label=destroy property);
%everusez2 (evstl50ls6, stl50lsdli03, evstl50ls7, 2003, label=steal less than fifty);
%everusez2 (evstl50pl6, stl50pldli03, evstl50pl7, 2003, label=steal more than fifty);
%everusez2 (evothprp6, othprpdli03, evothprp7, 2003, label=commit other prop crimes);
%everusez2 (evattack6, attackdli03, evattack7, 2003, label=attack someone);
%everusez2 (evdrugs6, drugsdli03, evdrugs7, 2003, label=sell drugs);

/*Though there is no Run away variable for round 7, I am crating rundli03 so that when the rounds are converted to
ages there are equal numbers of variables for each round*/

rundli03 = .;
Label rundli03 = "R has run away since DLI, 2003";
Format rundli03 yes10no.;

/*Index*/
/*No 9-item index because there is no runaway measure in R7, but making dlnqscl10_7 = missing so that when
we convert rounds to ages the number of variables are equal for each age.*/
dlnqscl9_7 = .;

/*8-Item Delinquency Index (Without Runaway)*/
%let dlnqscl7c = gundli03, gangdli03, stl50lsdli03, stl50pldli03, othprpdli03, attackdli03, drugsdli03, despropdli03;
	If nmiss(&dlnqscl7c) le 2 then dlnqscl8a_7= Round((sum (&dlnqscl7c)*8)/(8-(nmiss(&dlnqscl7c))));
	Label dlnqscl8a_7 = "8-Item Delinquency Index (DLI), (without runaway), 2003";

/*2004*/
/*The first thing we have to do is change all the DLI's to Evers*/
/*Run away from home - only asked if R was under 17*/
/*Starting in 2001, except for gang membership respondents were not asked, "ever". They were only asked the "DLI" question.*/

Array old8(10)  S4686200 S4687100 S4686400 S4687400 S4687700 S4687900 S4688200 S4688700 S4689100 S4689300;
Array new8(10)  gunev8 gangev8 gundli8 gangdli8 propdli8 stl50lsdli8 stl50pldli8 othprpdli8 attackdli8 drugsdli8 ;

Do i = 1 to 10;
	If old8(i) lt 0 then new7(i) = .;
	Else new8(i) = old7(i);
End;
Label gunev8 = "R has ever carried a gun , 2004";
Label gangev8 = "R has belonged to a gang , 2004";
Label gundli8 = "R has carried a gun since DLI, 2004";
Label gangdli8 = "R has belonged to a gang since DLI, 2004";
Label propdli8 = "R has destroyed property since DLI, 2004";
Label stl50lsdli8 = "R has stolen something worth less than $50 since DLI, 2004";
Label stl50pldli8 = "R has stolen something worth more than $50 since DLI, 2004";
Label othprpdli8 = "R has committed other property crimes since DLI, 2004";
Label attackdli8 = "R has attacked someone since DLI, 2004";
Label drugsdli8 = "R has sold drugs since DLI, 2004";

%delinqdli (S1529907, S4686000, gunev8, gundli8, gundli04, 2004, label=carried a gun);
%delinqdli2 (S1529907, propdli8, despropdli04, 2004, label=destroyed property);
%delinqdli2 (S1529907, stl50lsdli8, stl50lsdli04, 2004, label=stolen less than fifty);
%delinqdli2 (S1529907, stl50pldli8, stl50pldli04, 2004, label=stolen more than fifty);
%delinqdli2 (S1529907, othprpdli8, othprpdli04, 2004, label=commited other prop crimes);
%delinqdli2 (S1529907, attackdli8, attackdli04, 2004, label=attacked someone);
%delinqdli2 (S1529907, drugsdli8, drugsdli04, 2004, label=sold drugs);

If gangev8 = 0 then gangdli04 = 0; /*Has never done ...*/
Else if gangdli8 = 0 then gangdli04 = 0; /*Has never done ...*/
Else if gangdli8 = 1 then gangdli04 = 1;  /*Had done ... since dli*/
Label gangdli04 = "R has been a member of a gang sinse DLI, 2004";
Format gangdli04 yes10no.;

%everusez2 (everrun7, rundli04, everrun8, 2004, label=run away);
%everusez2 (evergun7, gundli04, evergun8, 2004, label=carry a gun);
%everusez (gangev8, evergang7, gangdli04, evergang8, 2004, label=belonged to a gang);
%everusez2 (everdesprp7, despropdli04, everdesprp8, 2004, label=destroy property);
%everusez2 (evstl50ls7, stl50lsdli04, evstl50ls8, 2004, label=steal less than fifty);
%everusez2 (evstl50pl7, stl50pldli04, evstl50pl8, 2004, label=steal more than fifty);
%everusez2 (evothprp7, othprpdli04, evothprp8, 2004, label=commit other prop crimes);
%everusez2 (evattack7, attackdli04, evattack8, 2004, label=attack someone);
%everusez2 (evdrugs7, drugsdli04, evdrugs8, 2004, label=sell drugs);

/*Though there is no Run away variable for round 7, I am crating rundli04 so that when the rounds are converted to
ages there are equal numbers of variables for each round*/

rundli04 = .;
Label rundli04 = "R has run away since DLI, 2004";
Format rundli04 yes10no.;

/*Index*/
/*No 10-item index because there is no runaway measure in R7, but making dlnqscl10_8 = missing so that when
we convert rounds to ages the number of variables are equal for each age.*/
dlnqscl10_8 = .;

/*8-Item Delinquency Index (Without Runaway)*/
%let dlnqscl7c = gundli04, gangdli04, stl50lsdli04, stl50pldli04, othprpdli04, attackdli04, drugsdli04, despropdli04;
	If nmiss(&dlnqscl7c) le 2 then dlnqscl8a_7= Round((sum (&dlnqscl7c)*8)/(8-(nmiss(&dlnqscl7c))));
	Label dlnqscl8a_7 = "8-Item Delinquency Index (DLI), (without runaway), 2004";

/******Delinquency variables by age @ interview******/

Array delvars_rnd1(11) runawy1 gun1 gang1 destprop1 steal50less1 steal50plus1 othprop1 attack1 selldrgs1 
dlnqscl9_1 dlnqscl8a_1;
Array delvars_rnd2(11) rundli98 gundli98 gangdli98 despropdli98 stl50lsdli98 stl50pldli98 stlprpdli98 attackdli98 drugsdli98  
dlnqscl9_2 dlnqscl8a_2;
Array delvars_rnd3(11) rundli99 gundli99 gangdli99 despropdli99 stl50lsdli99 stl50pldli99 stlprpdli99 attackdli99 drugsdli99 
dlnqscl9_3 dlnqscl8a_3;
Array delvars_rnd4(11) rundli00 gundli00 gangdli00 despropdli00 stl50lsdli00 stl50pldli00 stlprpdli00 attackdli00 drugsdli00 
dlnqscl9_4 dlnqscl8a_4;
Array delvars_rnd5(11) rundli01 gundli01 gangdli01 despropdli01 stl50lsdli01 stl50pldli01 stlprpdli01 attackdli01 drugsdli01
dlnqscl9_5 dlnqscl8a_5;
Array delvars_rnd6(11) rundli02 gundli02 gangdli02 despropdli02 stl50lsdli02 stl50pldli02 stlprpdli02 attackdli02 drugsdli02
dlnqscl9_6 dlnqscl8a_6;
Array delvars_rnd7(11) rundli03 gundli03 gangdli03 despropdli03 stl50lsdli03 stl50pldli03 stlprpdli03 attackdli03 drugsdli03 
dlnqscl9_7 dlnqscl8a_7;
Array delvars_rnd8(11) rundli04 gundli04 gangdli04 despropdli04 stl50lsdli04 stl50pldli04 stlprpdli04 attackdli04 drugsdli04 
dlnqscl9_8 dlnqscl8a_8;

Array delvars_12(11) run12 gun12 gang12 desprop12 stl50ls12 stl50pl12 othprp12 attack12 drugs12
dlnqscl9_12 dlnqscl8a_12;
Array delvars_13(11) run13 gun13 gang13 desprop13 stl50ls13 stl50pl13 othprp13 attack13 drugs13
dlnqscl9_13 dlnqscl8a_13;
Array delvars_14(11) run14 gun14 gang14 desprop14 stl50ls14 stl50pl14 othprp14 attack14 drugs14
dlnqscl9_14 dlnqscl8a_14;
Array delvars_15(11) run15 gun15 gang15 desprop15 stl50ls15 stl50pl15 othprp15 attack15 drugs15
 dlnqscl9_15 dlnqscl8a_15;
Array delvars_16(11) run16 gun16 gang16 desprop16 stl50ls16 stl50pl16 othprp16 attack16 drugs16
 dlnqscl9_16 dlnqscl8a_16;
Array delvars_17(11) run17 gun17 gang17 desprop17 stl50ls17 stl50pl17 othprp17 attack17 drugs17
dlnqscl9_17 dlnqscl8a_17;
Array delvars_18(11) run18 gun18 gang18 desprop18 stl50ls18 stl50pl18 othprp18 attack18 drugs18
 dlnqscl9_18 dlnqscl8a_18;
Array delvars_19(11) run19 gun19 gang19 desprop19 stl50ls19 stl50pl19 othprp19 attack19 drugs19
 dlnqscl9_19 dlnqscl8a_19;
Array delvars_20(11) run20 gun20 gang20 desprop20 stl50ls20 stl50pl20 othprp20 attack20 drugs20
 dlnqscl9_20 dlnqscl8a_20;
Array delvars_21(11) run21 gun21 gang21 desprop21 stl50ls21 stl50pl21 othprp21 attack21 drugs20
 dlnqscl9_21 dlnqscl8a_21;
Array delvars_22(11) run22 gun22 gang22 desprop22 stl50ls22 stl50pl22 othprp22 attack22 drugs22 
dlnqscl9_22 dlnqscl8a_22;
Array delvars_23(11) run23 gun23 gang23 desprop23 stl50ls23 stl50pl23 othprp23 attack23 drugs23 
 dlnqscl9_23 dlnqscl8a_23;
Array delvars_24(11) run24 gun24 gang24 desprop24 stl50ls24 stl50pl24 othprp24 attack24 drugs24 
dlnqscl9_24 dlnqscl8a_24;

%macro ageyrs1 (agevar, age, delagearray);
	Do i = 1 to 8 until (agenew(i) = &age);
		If agenew(i) = &age then &agevar = i;
	End;
	
	Do i = 1 to 11;
		If &agevar = 1 then &delagearray(i) = delvars_rnd1(i);
		If &agevar = 2 then &delagearray(i) = delvars_rnd2(i);
		If &agevar = 3 then &delagearray(i) = delvars_rnd3(i);
		If &agevar = 4 then &delagearray(i) = delvars_rnd4(i);
		If &agevar = 5 then &delagearray(i) = delvars_rnd5(i);
		If &agevar = 6 then &delagearray(i) = delvars_rnd6(i);
		If &agevar = 7 then &delagearray(i) = delvars_rnd7(i);
		If &agevar = 8 then &delagearray(i) = delvars_rnd8(i);
	End;
%mend;

%ageyrs1 (a12, 12, delvars_12);
%ageyrs1 (a13, 13, delvars_13);
%ageyrs1 (a14, 14, delvars_14);
%ageyrs1 (a15, 15, delvars_15);
%ageyrs1 (a16, 16, delvars_16);
%ageyrs1 (a17, 17, delvars_17);
%ageyrs1 (a18, 18, delvars_18);
%ageyrs1 (a19, 19, delvars_19);
%ageyrs1 (a20, 20, delvars_20);
%ageyrs1 (a21, 21, delvars_21);
%ageyrs1 (a22, 22, delvars_22);
%ageyrs1 (a23, 23, delvars_23);
%ageyrs1 (a24, 24, delvars_24);

format run16 gun16 gang16 desprop16 stl50ls16 stl50pl16 othprp16 attack16 drugs16 
run20 gun20 gang20 desprop20 stl50ls20 stl50pl20 othprp20 attack20 drugs20 yes10no.;
Label dlnqscl9_16 = "9-Item Delinquency Index (DLI) at age 16 (with runaway)";
Label dlnqscl9_20 = "9-Item Delinquency Index (DLI) at age 20 (with runaway)";
Label dlnqscl8a_16 = "8-Item Delinquency Index (DLI) at age 16 (without runaway)";
label dlnqscl8a_20= "8-Item Delinquency Index (DLI) at age 20 (without runaway)";
Label run16 = "R has run away since DLI, at age 16";
Label run20 = "R has run away since DLI, at age 20";
Label gun16 = "R has carried a gun since DLI, at age 16";
label gun20 = "R has carried a gun since DLI, at age 20";
label gang16 = "R has belonged to a gang since DLI, at age 16";
label gang20 = "R has belonged to a gang since DLI, at age 20";
label desprop16 = "R has destroyed property since DLI, at age 16";
label desprop20 = "R has destroyed property since DLI, at age 20";
label stl50ls16 = "R has stolen something worth less than $50 since DLI, at age 16";
label stl50ls20 = "R has stolen something worth less than $50 since DLI, at age 20";
label stl50pl16 = "R has stolen something worth more than $50 since DLI, at age 16"; 
label stl50pl20 = "R has stolen something worth more than $50 since DLI, at age 20"; 
label othprp16 = "R has coimmitted other property crimes since DLI, at age 16";
label othprp20 = "R has coimmitted other property crimes since DLI, at age 20";
label attack16 = "R has attacked someone since DLI, at age 16";
label attack20 = "R has attacked someone since DLI, at age 20";
label drugs16 = "R has sold drugs since DLI, at age 16";
label drugs20 = "R has sold drugs since DLI, at age 20";

/*DUMMY MACRO*/
%macro dummy(oldvar, newdums);
array dum_&oldvar(*) &newdums;
do i=1 to dim(dum_&oldvar);
if &oldvar=i then do;
dum_&oldvar(i)=1;
end;
else if &oldvar ne . then dum_&oldvar(i)=0;
end;
%mend;

/*time in most recent marriage, number of marriages*/

M2=R1210601; /* mth of parent int*/
Y2=R1210602; /*yr of parent int*/

/*6 marriages from 1 to 6*/

array years (6)R0566101 R0566201 R0566301 R0566401 R0566501 R0566601;
count=0;
do i=1 to 6;
if  years(i)>0 then y1=years(i);
if years(i) ne .B then count=count+1;
end;

yrsmarr=Y2-y1;
Rpmarr97=yrsmarr;
if R0566101=.B and R0566201=.B and R0566301=.B
and R0566401=.B and R0566501=.B and R0566601=.B then Rpmarr97=-4;
Pmarnum97=count;
if Rpmarr97=-4 then Pmarnum97=0;
label Rpmarr97="Resp parent yrs in current marriage 1997";
label Pmarnum97="Resp parent number of marriages 1997";

/********************************Parent Education**********************************/
/*Created from SG program 12-30-02*/

resmomed = .;
if R1302700 in (., 95) then resmomed =.; /*Missing*/
if R1302700 ne . and R1302700 le 11 then resmomed = 1; /*Zero through 11th grade of High school*/
if R1302700 = 12 then resmomed =2; /*Graduated from HS*/
if R1302700 in (13, 14, 15) then resmomed =3; /*Completed 3 or fewer years of college*/
if R1302700 in (16, 17, 18, 19, 20) then resmomed = 4; /*Completed 4 or more years of college*/
label resmomed = 'Res Mothers highest level of education completed (missing = .)';
format resmomed edulvl.;

momedmis = .;
if resmomed = . then momedmis = 1;
else momedmis = 0;
Label momedmis = "Missing on Mother's education level";
Format momedmis yes01no.;

resdaded = .;
if R1302600 in (., 95) then resdaded =.; /*Missing*/
if R1302600 ne . and R1302600 le 11 then resdaded = 1; /*None-11th grade of High school*/
if R1302600 = 12 then resdaded =2; /*Graduated from HS*/
if R1302600 in (13, 14, 15) then resdaded =3; /*Completed 3 or fewer years of college*/
if R1302600 in (16, 17, 18, 19, 20) then resdaded = 4; /*Completed 4 or more years of college*/
label resdaded = 'Res Fathers highest level of education completed (missing = .)';
format resdaded edulvl.;

dadedmis = .;
if resdaded = . then dadedmis = 1;
else dadedmis = 0;
Label dadedmis = "Missing on Father's education level";
Format dadedmis yes01no.;

/******* Resident Parent Education Levels *************/
respared = .;
respared = max(resmomed, resdaded);
label respared = 'Highest resident parent education between both (missing = .)';
format respared edulvl.;
%dummy (respared, lesshs hsgrad somecoll collgrad);

/*************Marital Status*************************/

resprel=r0734800;
respms = .;
if resprel in (3,4,5,6,7,8,9,10) then do; /*****mother father step parent adoptive parent foster parent of r********/
if r0735000 = 1 then respms = r0704600;
else if r0735000 = 2 then respms = r0704700;
else if r0735000 = 3 then respms = r0704800;
else if r0735000 = 4 then respms = r0704900;
else if r0735000 = 5 then respms = r0705000;
else if r0735000 = 6 then respms = r0705100;
else if r0735000 = 7 then respms = r0705200;
else if r0735000 = 8 then respms = r0705300;
else if r0735000 = 9 then respms = r0705400;
end; 

if respms lt 0 then respms=.;

if respms=1 then parmar=1;
if respms in (0,2,3,4) then parmar=0;
else if respms<0 then parmar=.;

/***************************************************************************************/
/********************************Family Structure**************************************/;
/*FAM STRUCTURE*/
array famstruc_(7)R1205300 R2563600 R3885200 R5464400 R7228100 S1542000 S2011800;
array famstrucnew(7)fmstrc97 fmstrc98 fmstrc99 FMSTRC00 FMSTRC01 FMSTRC02 FMSTRC03;
 do a= 1 to 7;
      if famstruc_(a) LT 0 THEN famstrucnew(a) = .;
      if famstruc_(a) = 1 THEN famstrucnew(a) = 1; /*2 bio parents*/
      if famstruc_(a) in (2,3) THEN famstrucnew(a) = 2; /*One bio parent, one step*/
      if famstruc_(a) = 6 THEN famstrucnew(a) = 3; /*Adoptive parent(s)*/
	  if famstruc_(a) in (4,5) THEN famstrucnew(a) = 4; /*One single bio parent/one adoptive*/
	  if famstruc_(a) GE 7 THEN famstrucnew(a) = 5; /*Other family type*/
end;

label FMSTRC97 = 'Family Structure youth report -- 1997';
format fmstrc97 famstrc.;
label FMSTRC98  = 'Family Structure youth report -- 1998';
format fmstrc98 famstrc.;
label FMSTRC99 = 'Family Structure youth report -- 1999';
format fmstrc99 famstrc.;
label FMSTRC00 = 'Family Structure youth report -- 2000';
format fmstrc00 famstrc.;
label FMSTRC01 = 'Family Structure youth report -- 2001';
format fmstrc01 famstrc.;
label FMSTRC02 = 'Family Structure youth report -- 2002';
format fmstrc02 famstrc.;
label FMSTRC03 = 'Family Structure youth report -- 2003';
format fmstrc03 famstrc.;

%dummy (fmstrc97, biomry97 step97 singpar97 othfam97);
%dummy (fmstrc98, biomry98 step98 singpar98 othfam98);
%dummy (fmstrc99, biomry99 step99 singpar99 othfam99);

MARLATER = .;
IF fmstrc97 IN (1,2) THEN MARLATER = .m; /*already in sample since they were married in round 1*/
IF (fmstrc97 = .) OR (fmstrc97 GT 2) THEN do; /*not married or missing round 1*/
	IF fmstrc98 IN (1,2)THEN MARLATER = 1; /*married round 2*/
	ELSE IF (fmstrc98 = .) OR (fmstrc98 GT 2) THEN do; /*not married in either round*/
	IF fmstrc99 IN (1,2)THEN MARLATER = 1; /*not married in prev rounds, married in round 3*/
	ELSE IF (fmstrc99 = .) OR (fmstrc99 GT 2)THEN MARLATER = 0;
	end;
  end;
Label MARLATER = '# of families who were not married at r1 but married later - .m=married at r1';

/**preliminary sample var**/

MARRIED1 = .;
IF y_age IN (12,13,14) THEN DO;
	IF fmstrc97 IN (1,2,3) THEN MARRIED1 = 1; /*already in sample since they were married in round 1*/
	IF fmstrc97 GT 3 THEN MARRIED1 = 0; /*not married or missing round 1*/
	end;
ELSE MARRIED1 = .;
Label MARRIED1 = 'Families married at r1 (limited to Y aged 12-14) 1=married 0=not married';

marrsamp=married1;
if parmar=0 and married1=1 then marrsamp=0;
if parmar=1 and married1=0 and fmstrc97=4 and resprel in (5,6) then marrsamp=1;

if married1=0 and parmar=1 and y_age in (12,13,14) and resprel in (3,4,5,6)then marrsamp=1;
if married1=0 and parmar=. and y_age in (12,13,14) and resprel in (.D,.I,14,3) then marrsamp=1;

/*marital disruption */

disrup9798 = .;
if fmstrc97 = 1 and fmstrc98 = 1 then disrup9798 = 0;
if fmstrc97 = 1 and fmstrc98  in (2,3,4) then disrup9798 = 1;
if fmstrc97 = 1 and fmstrc98 = . then disrup9798 = .;
if fmstrc97 = 2 and fmstrc98 = 2 then disrup9798 = 0;
if fmstrc97 = 2 and fmstrc98  in (1,3,4) then disrup9798 = 1;
if fmstrc97 = 2 and fmstrc98 = . then disrup9798 = .;

disrup9899 = .;
if fmstrc98 = 1 and fmstrc99 = 1 then disrup9899 = 0;
if fmstrc98 = 1 and fmstrc99  in (2,3,4) then disrup9899 = 1;
if fmstrc98 = 1 and fmstrc99 = . then disrup9899 = .;
if fmstrc98 = 2 and fmstrc99 = 2 then disrup9899 = 0;
if fmstrc98 = 2 and fmstrc99  in (1,3,4) then disrup9899 = 1;
if fmstrc98 = 2 and fmstrc99 = . then disrup9899 = .;

disrup9900 = .;
if fmstrc99 = 1 and fmstrc00 = 1 then disrup9900 = 0;
if fmstrc99 = 1 and fmstrc00  in (2,3,4) then disrup9900 = 1;
if fmstrc99 = 1 and fmstrc00 = . then disrup9900 = .;
if fmstrc99 = 2 and fmstrc00 = 2 then disrup9900 = 0;
if fmstrc99 = 2 and fmstrc00  in (1,3,4) then disrup9900 = 1;
if fmstrc99 = 2 and fmstrc00 = . then disrup9900 = .;

disrup0001 = .;
if fmstrc00 = 1 and fmstrc01 = 1 then disrup0001 = 0;
if fmstrc00 = 1 and fmstrc01  in (2,3,4) then disrup0001 = 1;
if fmstrc00 = 1 and fmstrc01 = . then disrup0001 = .;
if fmstrc00 = 2 and fmstrc01 = 2 then disrup0001 = 0;
if fmstrc00 = 2 and fmstrc01  in (1,3,4) then disrup0001 = 1;
if fmstrc00 = 2 and fmstrc01 = . then disrup0001 = .;

disrup0102 = .;
if fmstrc01 = 1 and fmstrc02 = 1 then disrup0102 = 0;
if fmstrc01 = 1 and fmstrc02  in (2,3,4) then disrup0102 = 1;
if fmstrc01 = 1 and fmstrc02 = . then disrup0102 = .;
if fmstrc01 = 2 and fmstrc02 = 2 then disrup0102 = 0;
if fmstrc01 = 2 and fmstrc02  in (1,3,4) then disrup0102 = 1;
if fmstrc01 = 2 and fmstrc02 = . then disrup0102 = .;

disrup0203 = .;
if fmstrc02 = 1 and fmstrc03 = 1 then disrup0203 = 0;
if fmstrc02 = 1 and fmstrc03  in (2,3,4) then disrup0203 = 1;
if fmstrc02 = 1 and fmstrc03 = . then disrup0203 = .;
if fmstrc02 = 2 and fmstrc03 = 2 then disrup0203 = 0;
if fmstrc02 = 2 and fmstrc03  in (1,3,4) then disrup0203 = 1;
if fmstrc02 = 2 and fmstrc03 = . then disrup0203 = .;

/****disruption over first 3 rounds*****/

disrup9799=.;
if fmstrc97=fmstrc98=fmstrc99 then disrup9799=0;
else if fmstrc97=fmstrc99=fmstrc00 and fmstrc98=. then disrup9799=0;
else if fmstrc97=fmstrc98=fmstrc00 and fmstrc99=. then disrup9799=0;

else if fmstrc98=. and fmstrc99=. and fmstrc00=. then disrup9799=.;

else if fmstrc97=fmstrc99 and fmstrc98=. then disrup9799=0;
else if fmstrc97=fmstrc00 and fmstrc98=. and fmstrc99=. then disrup9799=0;

else if fmstrc97 ne fmstrc00 and fmstrc98=. and fmstrc99=. then disrup9799=.;

else if fmstrc97=fmstrc98 and fmstrc99=. and fmstrc00=. then disrup9799=.;
else if fmstrc97=fmstrc98 and fmstrc99=. and fmstrc00 ne fmstrc97 then disrup9799=.;

else if fmstrc97 ne fmstrc98 or fmstrc98 ne fmstrc99 or fmstrc97 ne fmstrc99 then disrup9799=1;

TURBLENC = .;
IF fmstrc97 = 1 THEN do;
	IF fmstrc98 = 1 then do;
		IF fmstrc99=fmstrc98 THEN TURBLENC = 0; /*no change*/
		ELSE IF fmstrc99 =.  THEN TURBLENC = 0; /*no change btw reported rounds*/
		ELSE IF fmstrc99 NE fmstrc98 THEN TURBLENC = 1; /*1 change*/
		end;
	IF fmstrc98 GT 1 then do;
		IF fmstrc99=fmstrc98 THEN TURBLENC = 1; /*1 change*/
		ELSE IF fmstrc99 =.  THEN TURBLENC = 1; /*1 change*/
		ELSE IF fmstrc99 NE fmstrc98 THEN TURBLENC = 2; /*2 changes*/
		end;
	IF fmstrc98 =. then do;
		IF fmstrc99 =. then TURBLENC =0;
		ELSE IF fmstrc99 = fmstrc97 THEN TURBLENC =0; /*no change btw reported rounds*/
		ELSE IF fmstrc99 NE fmstrc97 THEN TURBLENC = 1; /*1 changes*/
		end;
	end;
IF fmstrc97 = 2 THEN do;
	IF fmstrc98 = 2 then do;
		IF fmstrc99=fmstrc98 THEN TURBLENC = 0; /*no change*/
		ELSE IF fmstrc99 =.  THEN TURBLENC = 0; /*no change btw reported rounds*/
		ELSE IF fmstrc99 NE fmstrc98 THEN TURBLENC = 1; /*1 change*/
		end;
	IF (fmstrc98 NE 2) AND (fmstrc98 NE .) then do;
		IF fmstrc99=fmstrc98 THEN TURBLENC = 1; /*1 change*/
		ELSE IF fmstrc99 =.  THEN TURBLENC = 1; /*1 change*/
		ELSE IF fmstrc99 NE fmstrc98 THEN TURBLENC = 2; /*2 changes*/
		end;
	IF fmstrc98 =. then do;
		IF fmstrc99 =. then TURBLENC =0;
		ELSE IF fmstrc99 = fmstrc97 THEN TURBLENC =0; /*no change btw reported rounds*/
		ELSE IF fmstrc99 NE fmstrc97 THEN TURBLENC = 1; /*1 changes*/
		end;
	end;
IF fmstrc97 = 3 THEN do;
	IF fmstrc98 = 3 then do;
		IF fmstrc99=fmstrc98 THEN TURBLENC = 0; /*no change*/
		ELSE IF fmstrc99 =.  THEN TURBLENC = 0; /*no change btw reported rounds*/
		ELSE IF fmstrc99 NE fmstrc98 THEN TURBLENC = 1; /*1 change*/
		end;
	IF (fmstrc98 NE 3) AND (fmstrc98 NE .) then do;
		IF fmstrc99=fmstrc98 THEN TURBLENC = 1; /*1 change*/
		ELSE IF fmstrc99 =.  THEN TURBLENC = 1; /*1 change*/
		ELSE IF fmstrc99 NE fmstrc98 THEN TURBLENC = 2; /*2 changes*/
		end;
	IF fmstrc98 =. then do;
		IF fmstrc99 =. then TURBLENC =0;
		ELSE IF fmstrc99 = fmstrc97 THEN TURBLENC =0; /*no change btw reported rounds*/
		ELSE IF fmstrc99 NE fmstrc97 THEN TURBLENC = 1; /*1 changes*/
		end;
	end;
IF fmstrc97 = 4 THEN do;
	IF fmstrc98 = 4 then do;
		IF fmstrc99=fmstrc98 THEN TURBLENC = 0; /*no change*/
		ELSE IF fmstrc99 =.  THEN TURBLENC = 0; /*no change btw reported rounds*/
		ELSE IF fmstrc99 NE fmstrc98 THEN TURBLENC = 1; /*1 change*/
		end;
	IF (fmstrc98 NE 4) AND (fmstrc98 NE .) then do;
		IF fmstrc99=fmstrc98 THEN TURBLENC = 1; /*1 change*/
		ELSE IF fmstrc99 =.  THEN TURBLENC = 1; /*1 change*/
		ELSE IF fmstrc99 NE fmstrc98 THEN TURBLENC = 2; /*2 changes*/
		end;
	IF fmstrc98 =. then do;
		IF fmstrc99 =. then TURBLENC =0;
		ELSE IF fmstrc99 = fmstrc97 THEN TURBLENC =0; /*no change btw reported rounds*/
		ELSE IF fmstrc99 NE fmstrc97 THEN TURBLENC = 1; /*1 changes*/
		end;
	end;
IF fmstrc97 = . THEN do;
		IF fmstrc99 =. then TURBLENC = 0; /*only one round reported*/
		ELSE IF (fmstrc98 GT 0) AND (fmstrc98 NE fmstrc99) THEN TURBLENC = 1; /*1 changes*/
		ELSE IF fmstrc98 = fmstrc99 THEN TURBLENC = 0; /*no change btw reported rounds*/
	end;
Label TURBLENC = 'Number of changes in adolescent reported marital status rounds 1-3';

/*****************************mental health 00********/
R489360r=R4893600-1;
R489370r=4-R4893700;
R489380r=R4893800-1;
R489390r=4-R4893900;
R489400r=R4894000-1;

array ment00{5} R489360r R489370r R489380r R489390r R489400r;
menh00=0;
    do a= 1 to 5;
      if ment00{a}=. then menh00=menh00+1;
    end;
       if menh00 le 1 then do;
        menhel00 = sum (R489360r, R489370r, R489380r, R489390r, R489400r)*(5/(5-menh00));
        end;
label menhel00 ='5-Item Mental health Scale 2000';

/*****************************mental health 02********/
S092080r=S0920800-1;
S092090r=4-S0920900;
S092100r=S0921000-1;
S092110r=4-S0921100;
S092120r=S0921200-1;

array ment02{5} S092080r S092090r S092100r S092110r S092120r;
menh02=0;
    do a= 1 to 5;
      if ment02{a}=. then menh02=menh02+1;
    end;
       if menh02 le 1 then do;
        menhel02 = sum (S092080r, S092090r, S092100r, S092110r, S092120r)*(5/(5-menh02));
        end;
label menhel02 ='5-Item Mental health Scale 2002';

/*****************************mental health 04********/
S468190r=S4681900-1;
S468200r=4-S4682000;
S468210r=S4682100-1;
S468220r=4-S4682200;
S468230r=S4682300-1;

array ment04{5} S468190r S468200r S468210r S468220r S468230r;
menh04=0;
    do a= 1 to 5;
      if ment04{a}=. then menh04=menh04+1;
    end;
       if menh04 le 1 then do;
        menhel04 = sum (S468190r, S468200r, S468210r, S468220r, S468230r)*(5/(5-menh04));
        end;
label menhel04 ='5-Item Mental health Scale 2004';

/*****************************combined mental health rounds 6 and 8*****************************/
array adment {10} S092080r S092090r S092100r S092110r S092120r S468190r S468200r S468210r S468220r S468230r;
adltmh = 0;
	do a= 1 to 10;
		if adment {a}=. then adltmh=adltmh+1;
	end;
		if adltmh le 2 then do;
		adultmh = sum (S092080r, S092090r, S092100r, S092110r, S092120r, S468190r, S468200r, S468210r, 
		S468220r, S468230r)*(10/(10-adltmh));
		end;
label adultmh = 'Composite adult mental health score across Rounds 6 and 8';

/*****************************general health********/
poshel97=.;
poshel98=.;
poshel99=.;
poshel00=.;
poshel01=.;
poshel02=.;
poshel03=.;
poshel04=.;

/*********positive health = very good, excellent******/
R032060r=5-R0320600;
if R032060r ge 3 then poshel97=1;
if 0<= R032060r <=2 then poshel97=0;

R216400r=5-R2164000;
if R216400r ge 3 then poshel98=1;
if 0<= R216400r <=2 then poshel98=0;

R348190r=5-R3481900;
if R348190r ge 3 then poshel99=1;
if 0<= R348190r <=2 then poshel99=0;

R488010r=5-R4880100;
if R488010r ge 3 then poshel00=1;
if 0<= R488010r <=2 then poshel00=0;

R649750r=5-R6497500;
if R649750r ge 3 then poshel01=1;
if 0<= R649750r <=2 then poshel01=0;

S122500r=5-S1225000;
if S122500r ge 3 then poshel02=1;
if 0<= S122500r <=2 then poshel02=0;

S330250r=5-S3302500;
if S330250r ge 3 then poshel03=1;
if 0<= S330250r <=2 then poshel03=0;

S491950r=5-S4919500;
if S491950r ge 3 then poshel04=1;
if 0<= S491950r <=2 then poshel04=0;

/********************/

neghel97=.;
neghel98=.;
neghel99=.;
neghel00=.;
neghel01=.;
neghel02=.;
neghel03=.;
neghel04=.;

/*********negative health = fair or poor******/

if R032060r ge 2 then neghel97=0;
if 0<= R032060r <=1 then neghel97=1;

if R216400r ge 2 then neghel98=0;
if 0<= R216400r <=1 then neghel98=1;

if R348190r ge 2 then neghel99=0;
if 0<= R348190r <=1 then neghel99=1;

if R488010r ge 2 then neghel00=0;
if 0<= R488010r <=1 then neghel00=1;

if R649750r ge 2 then neghel01=0;
if 0<= R649750r <=1 then neghel01=1;

if S122500r ge 2 then neghel02=0;
if 0<= S122500r <=1 then neghel02=1;

if S330250r ge 2 then neghel03=0;
if 0<= S330250r <=1 then neghel03=1;

if S491950r ge 2 then neghel04=0;
if 0<= S491950r <=1 then neghel04=1;

/*************general health scale********/
array heal{8} R032060r R216400r R348190r R488010r R649750r S122500r S330250r S491950r;
healm=0;
    do a= 1 to 8;
      if heal{a}=. then healm=healm+1;
    end;
       if healm le 2 then do;
        genheal = sum (R032060r, R216400r, R348190r, R488010r, R649750r, S122500r, S330250r, S491950r)*(8/(8-healm));
        end;
label genheal ='8-Item general health Scale, 32 point scale, 1997-2004';

/*************negative health scale********/
array hel1{8} neghel97 neghel98 neghel99 neghel00 neghel01 neghel02 neghel03 neghel04;
hel1m=0;
    do a= 1 to 8;
      if hel1{a}=. then hel1m=hel1m+1;
    end;
       if hel1m le 2 then do;
        sumneghl = sum (neghel97, neghel98, neghel99, neghel00, neghel01, neghel02, neghel03, neghel04)*(8/(8-hel1m));
        end;
label sumneghl ='8-Item negative health Scale, 8 point scale, 1997-2004';

neghel=.;
if sumneghl>=6 then neghel=1;
if 0<=sumneghl<6 then neghel=0;
label neghel = 'Negative Health = Score of 6 or greater on 8-item negative health scale';

/*************positive health scale********/
array hel2{8} poshel97 poshel98 poshel99 poshel00 poshel01 poshel02 poshel03 poshel04;
hel2m=0;
    do a= 1 to 8;
      if hel2{a}=. then hel2m=hel2m+1;
    end;
       if hel2m le 2 then do;
        sumposhl = sum (poshel97, poshel98, poshel99, poshel00, poshel01, poshel02, poshel03, poshel04)*(8/(8-hel2m));
        end;
label sumposhl = '8 item Positive health scale, 8 point scale, 1997-2004';

poshel=.;
if sumposhl>=6 then poshel=1;
if 0<=sumposhl<6 then poshel=0;
label poshel = 'Positive Health = Score of 6 or greater on 8-item positive health scale';

/**************best friend relationship*********/
/**2002**/
bestfr02=S1223400;		/******who is your best friend*******/
frclos02=S1224300;		/******1-10 how close with best friend*******/
label frclos02 = 'How close is R to best friend 1 = not close at all to 10 = very close';
frcare02=S1224400;		/******1-10 how much best friend cares about you*******/
label frcare02 = 'How much does Rs best friend care about R 1 = not at all to 10 = a lot';
frcomm02=S1224500;		/******how often communicate with best friend*******/
fredu02=S1224600;		/******how often discuss edu training job with best friend*******/
frrel02=S1224700;		/******how often discuss relationships with best friend*******/

/**2004**/
bestfr04=S4920400;
frclos04=S4920500;
frcare04=S4920600;
frcomm04=S4920700;
fredu04=S4920800;
frrel04=S4920900;

/*************romantic relationship*********/
spclos00=R4967000;		/*******1-10 how close to spouse dating partner**********/
spcare00=R4967100;		/*******1-10 how much spouse dating partner cares about you******/
spconf00=10-R4967200;	/*******1-10 how much conflict with spouse dating partner*******/

/*************romantic relationship scale********/
array ro00{3} spclos00 spcare00 spconf00;
rom0=0;
    do a= 1 to 3;
      if ro00{a}<0 then rom0=rom0+1;
    end;
       if rom0 =0 then do;
        romrel00 = sum (spclos00, spcare00, spconf00);
        end;
label romrel00 = '3-item romantic relationship scale 2000';

roman00=.;
if romrel00>22 then roman00=1;
if 0<=romrel00<=22 then roman00=0;
label roman00 = 'Score of 23 or greater on Romantic relationship scale 2000';

spclos01=R6599900;
spcare01=R6600000;
spconf01=10-R6600100;

/*************romantic relationship scale********/
array ro01{3} spclos01 spcare01 spconf01;
rom1=0;
    do a= 1 to 3;
      if ro01{a}<0 then rom1=rom1+1;
    end;
       if rom1 =0 then do;
        romrel01 = sum (spclos01, spcare01, spconf01);
        end;
label romrel01 = '3-item romantic relationship scale 2001';

roman01=.;
if romrel01>22 then roman01=1;
if 0<=romrel01<=22 then roman01=0;
label roman01 = 'Score of 23 or greater on Romantic relationship scale 2001';

spclos02=S0991700;			/**************S1195800 same thing??*****************/
spcare02=S0991800;
spconf02=10-S0991900;
sptoge02=S1196100;		/**********1-10 how likely together in 6 months*******/

/*************romantic relationship scale********/
array ro02{4} spclos02 spcare02 spconf02 sptoge02;
rom2=0;
    do a= 1 to 4;
      if ro02{a}<0 then rom2=rom2+1;
    end;
       if 0<= rom2 <=1 then do;
        romrel02 = sum (spclos02, spcare02, spconf02, sptoge02)*(4/(4-rom2));
        end;
label romrel02 = '4-item romantic relationship scale 2002';

roman02=.;
if romrel02>=30 then roman02=1;
if 0<=romrel02<30 then roman02=0;
label roman02 = 'Score of 30 or greater on Romantic relationship scale 2002';

spclos03=S3028300;					/**********S3278200*********/
spcare03=S3028400;
spconf03=10-S3028500;
sptoge03=S3278500;

/*************romantic relationship scale********/
array ro03{4} spclos03 spcare03 spconf03 sptoge03;
rom3=0;
    do a= 1 to 4;
      if ro03{a}<0 then rom3=rom3+1;
    end;
       if 0<= rom3 <= 1 then do;
        romrel03 = sum (spclos03, spcare03, spconf03, sptoge03)*(4/(4-rom3));
        end;
label romrel03 = '4-item romantic relationship scale 2003';

roman03=.;
if romrel03>=30 then roman03=1;
if 0<=romrel03<30 then roman03=0;
label roman03 = 'Score of 30 or greater on Romantic relationship scale 2003';

spclos04=S4712600;			/************S49010.00**************/
spcare04=S4712700;
spconf04=10-S4712800;
sptoge04=S4901300;

/*************romantic relationship scale********/
array ro04{4} spclos04 spcare04 spconf04 sptoge04;
rom4=0;
    do a= 1 to 4;
      if ro04{a}<0 then rom4=rom4+1;
    end;
       if 0<= rom4 <=1 then do;
        romrel04 = sum (spclos04, spcare04, spconf04, sptoge04)*(4/(4-rom4));
        end;
label romrel04 = '4-item romantic relationship scale 2004';

roman04=.;
if romrel04>=30 then roman04=1;
if 0<=romrel04<30 then roman04=0;
label roman04 = 'Score of 30 or greater on Romantic relationship scale 2004';

/*********parental relationship*******/

/**2001**/
momclo01=R6505900;		/****1-10 how close to mother***/
dadclo01=R6507500;		/****1-10 how close to father***/
biomomclo01=R6515500;	/****1-10 how close to bio mother***/
momfigclo01=R6515600;	/****1-10 how close to mother figure ***/
biodadclo01=R6515700;	/****1-10 how close to bio father***/
dadfigclo01=R6515800;	/****1-10 how close to father figure***/

biomomcom01=R6512700;	/****how often communicate with bio mother***/
momfigcom01=R6512800;	/****how often communicate with mother figure***/
biodadcom01=R6512900;	/****how often communicate with bio father***/
dadfigcom01=R6513000;	/****how often communicate with father figure***/

/**2002**/
biomomcom02=S0916300;
momfigcom02=S0916400;
biodadcom02=S0916500;
dadfigcom02=S0916600;

/**2003**/
biomomclo03=S2984300;
momfigclo03=S2984400;
biodadclo03=S2984500;
dadfigclo03=S2984600;

biomomcom03=S2980700;
momfigcom03=S2980800;
biodadcom03=S2980900;
dadfigcom03=S2981000;

/**2004**/
biomomcom04=S4679500;
momfigcom04=S4679600;
biodadcom04=S4679700;
dadfigcom04=S4679800;

/********bio mom communication scale*********/
array bmomc{4} biomomcom04 biomomcom03 biomomcom02 biomomcom01;
bmcm=0;
    do a= 1 to 4;
      if bmomc{a}<0 then bmcm=bmcm+1;
    end;
       if 0<= bmcm <=1 then do;
        biomomcm = sum (biomomcom04, biomomcom03, biomomcom02, biomomcom01)*(4/(4-bmcm));
        end;
label biomomcm = '4 item biological mother communication scale, 2001-2004';

/********mother figure communication scale*********/
array momfc{4} momfigcom04 momfigcom03 momfigcom02 momfigcom01;
mfcm=0;
    do a= 1 to 4;
      if momfc{a}<0 then mfcm=mfcm+1;
    end;
       if 0<= mfcm <=1 then do;
        momfigcm = sum (momfigcom04, momfigcom03, momfigcom02, momfigcom01)*(4/(4-mfcm));
        end;
label momfigcm = '4 item mother figure communication scale, 2001-2004';

/********bio dad communication scale*********/
array bdadc{4} biodadcom04 biodadcom03 biodadcom02 biodadcom01;
bdcm=0;
    do a= 1 to 4;
      if bdadc{a}<0 then bdcm=bdcm+1;
    end;
       if 0<= bdcm <=1 then do;
        biodadcm = sum (biodadcom04, biodadcom03, biodadcom02, biodadcom01)*(4/(4-bdcm));
        end;
label biodadcm = '4 item biological father communication scale, 2001-2004';

/********father figure communication scale*********/
array dadfc{4} dadfigcom04 dadfigcom03 dadfigcom02 dadfigcom01;
dfcm=0;
    do a= 1 to 4;
      if dadfc{a}<0 then dfcm=dfcm+1;
    end;
       if 0<= dfcm <=1 then do;
        dadfigcm = sum (dadfigcom04, dadfigcom03, dadfigcom02, dadfigcom01)*(4/(4-dfcm));
        end;
label dadfigcm = '4 item father figure communication scale, 2001-2004';

/*********voting******/

regvote04=.;
if S4921400=1 then regvote04=1;
if S4921400=0 then regvote04=0;
label regvote04='was respondent registered to vote in 2004 election: no=0 yes=1'; 

vote04=.;
if S4921100=4 then vote04=1;
if 1<=S4921100<=3 or S4921100=5 then vote04=0;
label vote04='did respondent vote in 2004 election: no=0 yes=1';

compvote=.;
if vote04=1 then compvote=1;
if vote04=0 and regvote04=1 then compvote=2;
if regvote04=1 and vote04 = . then compvote=2;
if vote04=0 and regvote04 = . then compvote=3;
if regvote04=0 then compvote=3;
label compvote='combined vote and registration status 2004: voted=1, registered but did not vote=2, not registered=3';

/*****relgiosity*****/
relvalue=1-S0919400;		/****dont need religion to have good values****/
relobey=S0919500;		/****religion should be obeyed exactly as written***/
reldecid=S0919600;		/****ask god to make decisions****/
relnothi=1-S0919700;		/****god has nothing to do with what happens personally***/
relpray=S0919800;		/****pray more than once a day***/

array re{5} relvalue relobey reldecid relnothi relpray;
relm=0;
    do a= 1 to 5;
      if re{a}=. then relm=relm+1;
    end;
       if relm le 1 then do;
        relig02 = sum (relvalue, relobey, reldecid, relnothi, relpray)*(5/(5-relm));
        end;
label relig02 = '5-item scale of religiosity, 5 point scale, 2002';

label bestfr02 = 'who is your best friend';
label frclos02 = '1-10 how close with best friend';
label frcare02 = '1-10 how much best friend cares about you';
label frcomm02 = 'how often communicate with best friend ';
label fredu02 = 'how often discuss edu training job with best friend ';
label frrel02 = 'how often discuss relationships with best friend ';
label spclos00= '1-10 how close to spouse dating partner ';
label spcare00= '1-10 how much spouse dating partner cares about you ';
label spconf00= '1-10 how much conflict with spouse dating partner ';

/*******************NORC education and disability variables*************************/
/* This program contains the code to create several variables:
including r's gender,r's race, ever arrested, disability status (and severity),
enrollment in hs, highest degree ever received by age 20, parents' home ownership,
parents' networth, poverty status, citizenship
(raceth97 grade evarrest16 evarrest20
disable16 disable20 sevdisableby16 sevdisableby20
enroll16 highever20 RPhome97 RPnetworth97
pov20016 pov20020 citizenship97)*/
/*This program creates two datasets:
analytical 
final

Analytical is a larger dataset which is used to create variables, and final is a smaller 
dataset created from Analytical using a keep statement*/

*creating dataset with all variables (base+analytical+intermediate);

***creating analytical demographic + grade variables;
if sex97 not in (-5,-4,.C,.D,.E,.) then sex97=sex97-1;

if raceth97 not in (-5,-4,.C,.D,.E,.) then raceth97=raceth97+1; 
if raceth97=3 then raceth97=1;
if raceth97=5 then raceth97=3;
format raceth97 racethnicity.;

array grades grade97 grade98 grade99 grade00 grade01 grade02 grade03 grade04;

do over grades;
  if grades not in (-5,-4,.C,.D,.E,.,999) then gradetemp=grades;
end;

if gradetemp='.' then do over grades;
  if grades in (.C, .D, .E,.) then gradetemp=grades;
end;

if gradetemp='.' then do over grades;
  if grades in (-5,-4) then gradetemp=grades;
end;

if gradetemp in (-5,-4,.C,.D,.E,.) then grade=gradetemp;
else if gradetemp in (1,2,3,4,5,9,10) then grade=0;
else if gradetemp in (6,7,8) then grade=1;
else if gradetemp in (11,12,13) then grade=0;

label grade = "High School Grades Mostly Bs or Above = 1, Not Mostly B's or Above = 0";

***creating analytical arrest variables;
if everarr98=-4 then arrest98=everarrsd98;
else arrest98=everarr98;
  *R answers either everarr or everarrsd but not both;
if everarr99=-4 then arrest99=everarrsd99;
else arrest99=everarr99;

if everarr00=-4 then arrest00=everarrsd00;
else arrest00=everarr00;

if age97<=16 then evarrest1697=arrest97 ;
if age98<=16 then evarrest1698=arrest98;
if age99<=16 then evarrest1699=arrest99;
if age00<=16 then evarrest1600=arrest00;
if age01<=16 then evarrest1601=everarrsd01; 
if age02<=16 then evarrest1602=everarrsd02; 
if age03<=16 then evarrest1603=everarrsd03; 
if age04<=16 then evarrest1604=everarrsd04;
  *agexx only have -5, no -4, .C, .D, .E values; 

array evarr16{8} evarrest1697 evarrest1698 evarrest1699 evarrest1600  
  evarrest1601 evarrest1602 evarrest1603 evarrest1604;
evarr16m=0;
    do a= 1 to 8;
      if evarr16{a}=. then evarr16m=evarr16m+1;
    end;
       if evarr16m > 2 then evarrest16=.;
       if evarr16m <= 2 then do; 
if evarrest1697=1 or evarrest1698=1 or evarrest1699=1 or evarrest1600=1 or 
  evarrest1601=1 or evarrest1602=1 or evarrest1603=1 or evarrest1604=1 
  then evarrest16=1;
	else evarrest16=0;
	end;
 
if age97<=20 then evarrest2097=arrest97;
if age98<=20 then evarrest2098=arrest98;
if age99<=20 then evarrest2099=arrest99;
if age00<=20 then evarrest2000=arrest00;
if age01<=20 then evarrest2001=everarrsd01; 
if age02<=20 then evarrest2002=everarrsd02; 
if age03<=20 then evarrest2003=everarrsd03; 
if age04<=20 then evarrest2004=everarrsd04;

array evarr{8} evarrest2097 evarrest2098 evarrest2099 evarrest2000
  evarrest2001 evarrest2002 evarrest2003 evarrest2004;
evarrm=0;
    do a= 1 to 8;
      if evarr{a}=. then evarrm=evarrm+1;
    end;
       if evarrm > 2 then evarrest20=.;
       if evarrm <= 2 then do; 
	   		if evarrest2097=1 or evarrest2098=1 or evarrest2099=1 or evarrest2000=1 or 
  				evarrest2001=1 or evarrest2002=1 or evarrest2003=1 or evarrest2004=1 
  				then evarrest20=1;
	   else evarrest20=0;
	end;
label evarrest16="R Ever Arrested Before or At Age 16";
label evarrest20="R Ever Arrested Before or At Age 20";

*creating analytical disability age variables;
array disabled(25) 
  GeneticAge1 
  GeneticAge2 
  GeneticAge3 
  GeneticAge4 
  GeneticAge5 
  DeformityAge1
  DeformityAge2
  DeformityAge3
  DeformityAge4
  ChronicAge1 
  ChronicAge2 
  ChronicAge3 
  ChronicAge4 
  ChronicAge5 
  ChronicAge6 
  ChronicAge7 
  ChronicAge8 
  ChronicAge9 
  senscondage1
  senscondage2
  senscondage3
  senscondage4
  senscondage5
  senscondage6
  senscondage7;

array Disable16Dum (25); 
array Disable20Dum (25);

Do i =1 to 25; 
  if disabled(i)>20 then do;
    Disable16Dum(i)=0;
	Disable20Dum(i)=0;
  end;
  else if disabled(i)>16 then do;
    Disable16Dum(i)=0;
	Disable20Dum(i)=1;
  end;
  else if disabled(i)>=0 then do;
    Disable16Dum(i)=1;
	Disable20Dum(i)=1;
  end;
  else do;
    Disable16Dum(i)=disabled(i);
	Disable20Dum(i)=disabled(i);
  end;

end;

if Disable16Dum(1)=1 or Disable16Dum(2)=1 or Disable16Dum(3)=1 or Disable16Dum(4)=1 or Disable16Dum(5)=1 or 
  Disable16Dum(6)=1 or Disable16Dum(7)=1 or Disable16Dum(8)=1 or Disable16Dum(9)=1 or Disable16Dum(10)=1 or 
  Disable16Dum(11)=1 or Disable16Dum(12)=1 or Disable16Dum(13)=1 or Disable16Dum(14)=1 or Disable16Dum(15)=1 or 
  Disable16Dum(16)=1 or Disable16Dum(17)=1 or Disable16Dum(18)=1 or Disable16Dum(19)=1 or Disable16Dum(20)=1 or 
  Disable16Dum(21)=1 or Disable16Dum(22)=1 or Disable16Dum(23)=1 or Disable16Dum(24)=1 or Disable16Dum(25)=1
  then Disable16=1;
else if Disable16Dum(1)=0 or Disable16Dum(2)=0 or Disable16Dum(3)=0 or Disable16Dum(4)=0 or Disable16Dum(5)=0 or 
  Disable16Dum(6)=0 or Disable16Dum(7)=0 or Disable16Dum(8)=0 or Disable16Dum(9)=0 or Disable16Dum(10)=0 or 
  Disable16Dum(11)=0 or Disable16Dum(12)=0 or Disable16Dum(13)=0 or Disable16Dum(14)=0 or Disable16Dum(15)=0 or 
  Disable16Dum(16)=0 or Disable16Dum(17)=0 or Disable16Dum(18)=0 or Disable16Dum(19)=0 or Disable16Dum(20)=0 or 
  Disable16Dum(21)=0 or Disable16Dum(22)=0 or Disable16Dum(23)=0 or Disable16Dum(24)=0 or Disable16Dum(25)=0
  then Disable16=0; 
else if Disable16Dum(1) in (.C, .D, .E,.) or Disable16Dum(2) in (.C, .D, .E,.) or Disable16Dum(3) in (.C, .D, .E,.) or Disable16Dum(4) in (.C, .D, .E,.) or Disable16Dum(5) in (.C, .D, .E,.) or 
  Disable16Dum(6) in (.C, .D, .E,.) or Disable16Dum(7) in (.C, .D, .E,.) or Disable16Dum(8) in (.C, .D, .E,.) or Disable16Dum(9) in (.C, .D, .E,.) or Disable16Dum(10) in (.C, .D, .E,.) or 
  Disable16Dum(11) in (.C, .D, .E,.) or Disable16Dum(12) in (.C, .D, .E,.) or Disable16Dum(13) in (.C, .D, .E,.) or Disable16Dum(14) in (.C, .D, .E,.) or Disable16Dum(15) in (.C, .D, .E,.) or 
  Disable16Dum(16) in (.C, .D, .E,.) or Disable16Dum(17) in (.C, .D, .E,.) or Disable16Dum(18) in (.C, .D, .E,.) or Disable16Dum(19) in (.C, .D, .E,.) or Disable16Dum(20) in (.C, .D, .E,.) or 
  Disable16Dum(21) in (.C, .D, .E,.) or Disable16Dum(22) in (.C, .D, .E,.) or Disable16Dum(23) in (.C, .D, .E,.) or Disable16Dum(24) in (.C, .D, .E,.) or Disable16Dum(25) in (.C, .D, .E,.)
  then Disable16='.';
else if Disable16Dum(1)=-5 then Disable16=-5;
else Disable16=-4;

if Disable20Dum(1)=1 or Disable20Dum(2)=1 or Disable20Dum(3)=1 or Disable20Dum(4)=1 or Disable20Dum(5)=1 or 
  Disable20Dum(6)=1 or Disable20Dum(7)=1 or Disable20Dum(8)=1 or Disable20Dum(9)=1 or Disable20Dum(10)=1 or 
  Disable20Dum(11)=1 or Disable20Dum(12)=1 or Disable20Dum(13)=1 or Disable20Dum(14)=1 or Disable20Dum(15)=1 or 
  Disable20Dum(16)=1 or Disable20Dum(17)=1 or Disable20Dum(18)=1 or Disable20Dum(19)=1 or Disable20Dum(20)=1 or 
  Disable20Dum(21)=1 or Disable20Dum(22)=1 or Disable20Dum(23)=1 or Disable20Dum(24)=1 or Disable20Dum(25)=1
  then Disable20=1;
else if Disable20Dum(1)=0 or Disable20Dum(2)=0 or Disable20Dum(3)=0 or Disable20Dum(4)=0 or Disable20Dum(5)=0 or 
  Disable20Dum(6)=0 or Disable20Dum(7)=0 or Disable20Dum(8)=0 or Disable20Dum(9)=0 or Disable20Dum(10)=0 or 
  Disable20Dum(11)=0 or Disable20Dum(12)=0 or Disable20Dum(13)=0 or Disable20Dum(14)=0 or Disable20Dum(15)=0 or 
  Disable20Dum(16)=0 or Disable20Dum(17)=0 or Disable20Dum(18)=0 or Disable20Dum(19)=0 or Disable20Dum(20)=0 or 
  Disable20Dum(21)=0 or Disable20Dum(22)=0 or Disable20Dum(23)=0 or Disable20Dum(24)=0 or Disable20Dum(25)=0
  then Disable20=0; 
else if Disable20Dum(1) in (.C, .D, .E,.) or Disable20Dum(2) in (.C, .D, .E,.) or Disable20Dum(3) in (.C, .D, .E,.) or Disable20Dum(4) in (.C, .D, .E,.) or Disable20Dum(5) in (.C, .D, .E,.) or 
  Disable20Dum(6) in (.C, .D, .E,.) or Disable20Dum(7) in (.C, .D, .E,.) or Disable20Dum(8) in (.C, .D, .E,.) or Disable20Dum(9) in (.C, .D, .E,.) or Disable20Dum(10) in (.C, .D, .E,.) or 
  Disable20Dum(11) in (.C, .D, .E,.) or Disable20Dum(12) in (.C, .D, .E,.) or Disable20Dum(13) in (.C, .D, .E,.) or Disable20Dum(14) in (.C, .D, .E,.) or Disable20Dum(15) in (.C, .D, .E,.) or 
  Disable20Dum(16) in (.C, .D, .E,.) or Disable20Dum(17) in (.C, .D, .E,.) or Disable20Dum(18) in (.C, .D, .E,.) or Disable20Dum(19) in (.C, .D, .E,.) or Disable20Dum(20) in (.C, .D, .E,.) or 
  Disable20Dum(21) in (.C, .D, .E,.) or Disable20Dum(22) in (.C, .D, .E,.) or Disable20Dum(23) in (.C, .D, .E,.) or Disable20Dum(24) in (.C, .D, .E,.) or Disable20Dum(25) in (.C, .D, .E,.)
  then Disable20='.';
else if Disable20Dum(1)=-5 then Disable20=-5;
else Disable20=-4;

array disabseverity20(25) 
  GeneticLimit1
  GeneticLimit2
  GeneticLimit3
  GeneticLimit4
  GeneticLimit5
  SensoryLimit1
  SensoryLimit2
  SensoryLimit3
  SensoryLimit4
  SensoryLimit5
  SensoryLimit6
  SensoryLimit7
  DeformityLimit1
  DeformityLimit2
  DeformityLimit3
  DeformityLimit4
  ChronicLimit1
  ChronicLimit2
  ChronicLimit3
  ChronicLimit4
  ChronicLimit5
  ChronicLimit6
  ChronicLimit7
  ChronicLimit8
  ChronicLimit9 
  ;
array disabledage(25)  
  GeneticAge1 
  GeneticAge2 
  GeneticAge3 
  GeneticAge4 
  GeneticAge5 
  senscondage1
  senscondage2
  senscondage3
  senscondage4
  senscondage5
  senscondage6
  senscondage7
  DeformityAge1
  DeformityAge2
  DeformityAge3
  DeformityAge4
  ChronicAge1
  ChronicAge2
  ChronicAge3
  ChronicAge4  
  ChronicAge5  
  ChronicAge6  
  ChronicAge7  
  ChronicAge8  
  ChronicAge9  
;

array disabsev1dum(25);  

if disable20=1 then 
do i=1 to 25; 
  if disabledage(i)=-5 then disabsev1dum(i)=-5;
  else if disabledage(i)=-4 then disabsev1dum(i)=-4;
  else if disabledage(i)<=20 then do; 
    if disabseverity20(i)=2 then disabsev1dum(i)=3; 
	else if disabseverity20(i)=1 then disabsev1dum(i)=2;
	else if disabseverity20(i)=0 then disabsev1dum(i)=1;
	else disabsev1dum(i)=disabseverity20(i);
  end;
end;

if disabsev1dum(1)=3 or disabsev1dum(2)=3 or disabsev1dum(3)=3 or disabsev1dum(4)=3 or disabsev1dum(5)=3 or 
  disabsev1dum(6)=3 or disabsev1dum(7)=3 or disabsev1dum(8)=3 or disabsev1dum(9)=3 or disabsev1dum(10)=3 or 
  disabsev1dum(11)=3 or disabsev1dum(12)=3 or disabsev1dum(13)=3 or disabsev1dum(14)=3 or disabsev1dum(15)=3 or 
  disabsev1dum(16)=3 or disabsev1dum(17)=3 or disabsev1dum(18)=3 or disabsev1dum(19)=3 or disabsev1dum(20)=3 or 
  disabsev1dum(21)=3 or disabsev1dum(22)=3 or disabsev1dum(23)=3 or disabsev1dum(24)=3 or disabsev1dum(25)=3 
  then sevdisableby20=3;
else if disabsev1dum(1)=2 or disabsev1dum(2)=2 or disabsev1dum(3)=2 or disabsev1dum(4)=2 or disabsev1dum(5)=2 or 
  disabsev1dum(6)=2 or disabsev1dum(7)=2 or disabsev1dum(8)=2 or disabsev1dum(9)=2 or disabsev1dum(10)=2 or 
  disabsev1dum(11)=2 or disabsev1dum(12)=2 or disabsev1dum(13)=2 or disabsev1dum(14)=2 or disabsev1dum(15)=2 or 
  disabsev1dum(16)=2 or disabsev1dum(17)=2 or disabsev1dum(18)=2 or disabsev1dum(19)=2 or disabsev1dum(20)=2 or 
  disabsev1dum(21)=2 or disabsev1dum(22)=2 or disabsev1dum(23)=2 or disabsev1dum(24)=2 or disabsev1dum(25)=2 
  then sevdisableby20=2;
else if disabsev1dum(1)=1 or disabsev1dum(2)=1 or disabsev1dum(3)=1 or disabsev1dum(4)=1 or disabsev1dum(5)=1 or 
  disabsev1dum(6)=1 or disabsev1dum(7)=1 or disabsev1dum(8)=1 or disabsev1dum(9)=1 or disabsev1dum(10)=1 or 
  disabsev1dum(11)=1 or disabsev1dum(12)=1 or disabsev1dum(13)=1 or disabsev1dum(14)=1 or disabsev1dum(15)=1 or 
  disabsev1dum(16)=1 or disabsev1dum(17)=1 or disabsev1dum(18)=1 or disabsev1dum(19)=1 or disabsev1dum(20)=1 or 
  disabsev1dum(21)=1 or disabsev1dum(22)=1 or disabsev1dum(23)=1 or disabsev1dum(24)=1 or disabsev1dum(25)=1 
  then sevdisableby20=1; 
else if disabsev1dum(1) in (.C, .D, .E,.) or disabsev1dum(2) in (.C, .D, .E,.) or disabsev1dum(3) in (.C, .D, .E,.) 
  or disabsev1dum(4) in (.C, .D, .E,.) or disabsev1dum(5) in (.C, .D, .E,.) or 
  disabsev1dum(6) in (.C, .D, .E,.) or disabsev1dum(7) in (.C, .D, .E,.) or 
  disabsev1dum(8) in (.C, .D, .E,.) or disabsev1dum(9) in (.C, .D, .E,.) or 
  disabsev1dum(10) in (.C, .D, .E,.) or 
  disabsev1dum(11) in (.C, .D, .E,.) or disabsev1dum(12) in (.C, .D, .E,.) or disabsev1dum(13) in (.C, .D, .E,.) 
  or disabsev1dum(14) in (.C, .D, .E,.) or disabsev1dum(15) in (.C, .D, .E,.) or 
  disabsev1dum(16) in (.C, .D, .E,.) or disabsev1dum(17) in (.C, .D, .E,.) or disabsev1dum(18) in (.C, .D, .E,.) 
  or disabsev1dum(19) in (.C, .D, .E,.) or disabsev1dum(20) in (.C, .D, .E,.) or 
  disabsev1dum(21) in (.C, .D, .E,.) or disabsev1dum(22) in (.C, .D, .E,.) or disabsev1dum(23) in (.C, .D, .E,.)
  or disabsev1dum(24) in (.C, .D, .E,.)  or disabsev1dum(25) in (.C, .D, .E,.) 
  then sevdisableby20='.';
else sevdisableby20=-4;

if disable20=0 then sevdisableby20=0;
else if disable20=-5 then sevdisableby20=-5;
else if disable20=-4 then sevdisableby20=-4;
else if disable20='.' then sevdisableby20='.';

array disabsev3dum(25);  

if disable16=1 then 
do i=1 to 25; 
  if disabledage(i)=-5 then disabsev3dum(i)=-5;
  else if disabledage(i)=-4 then disabsev3dum(i)=-4;
  else if disabledage(i)<=16 then do;
	if disabseverity20(i)=2 then disabsev3dum(i)=3; 
	else if disabseverity20(i)=1 then disabsev3dum(i)=2;
	else if disabseverity20(i)=0 then disabsev3dum(i)=1;
	else disabsev3dum(i)=disabseverity20(i);
  end;
end;

if disabsev3dum(1)=3 or disabsev3dum(2)=3 or disabsev3dum(3)=3 or disabsev3dum(4)=3 or disabsev3dum(5)=3 or 
  disabsev3dum(6)=3 or disabsev3dum(7)=3 or disabsev3dum(8)=3 or disabsev3dum(9)=3 or disabsev3dum(10)=3 or 
  disabsev3dum(11)=3 or disabsev3dum(12)=3 or disabsev3dum(13)=3 or disabsev3dum(14)=3 or disabsev3dum(15)=3 or 
  disabsev3dum(16)=3 or disabsev3dum(17)=3 or disabsev3dum(18)=3 or disabsev3dum(19)=3 or disabsev3dum(20)=3 or 
  disabsev3dum(21)=3 or disabsev3dum(22)=3 or disabsev3dum(23)=3 or disabsev3dum(24)=3 or disabsev3dum(25)=3 
  then sevdisableby16=3;
else if disabsev3dum(1)=2 or disabsev3dum(2)=2 or disabsev3dum(3)=2 or disabsev3dum(4)=2 or disabsev3dum(5)=2 or 
  disabsev3dum(6)=2 or disabsev3dum(7)=2 or disabsev3dum(8)=2 or disabsev3dum(9)=2 or disabsev3dum(10)=2 or 
  disabsev3dum(11)=2 or disabsev3dum(12)=2 or disabsev3dum(13)=2 or disabsev3dum(14)=2 or disabsev3dum(15)=2 or 
  disabsev3dum(16)=2 or disabsev3dum(17)=2 or disabsev3dum(18)=2 or disabsev3dum(19)=2 or disabsev3dum(20)=2 or 
  disabsev3dum(21)=2 or disabsev3dum(22)=2 or disabsev3dum(23)=2 or disabsev3dum(24)=2 or disabsev3dum(25)=2 
  then sevdisableby16=2;
else if disabsev3dum(1)=1 or disabsev3dum(2)=1 or disabsev3dum(3)=1 or disabsev3dum(4)=1 or disabsev3dum(5)=1 or 
  disabsev3dum(6)=1 or disabsev3dum(7)=1 or disabsev3dum(8)=1 or disabsev3dum(9)=1 or disabsev3dum(10)=1 or 
  disabsev3dum(11)=1 or disabsev3dum(12)=1 or disabsev3dum(13)=1 or disabsev3dum(14)=1 or disabsev3dum(15)=1 or 
  disabsev3dum(16)=1 or disabsev3dum(17)=1 or disabsev3dum(18)=1 or disabsev3dum(19)=1 or disabsev3dum(20)=1 or 
  disabsev3dum(21)=1 or disabsev3dum(22)=1 or disabsev3dum(23)=1 or disabsev3dum(24)=1 or disabsev3dum(25)=1 
  then sevdisableby16=1; 
else if disabsev3dum(1) in (.C, .D, .E,.) or disabsev3dum(2) in (.C, .D, .E,.) or disabsev3dum(3) in (.C, .D, .E,.) 
  or disabsev3dum(4) in (.C, .D, .E,.) or disabsev3dum(5) in (.C, .D, .E,.) or 
  disabsev3dum(6) in (.C, .D, .E,.) or disabsev3dum(7) in (.C, .D, .E,.) or 
  disabsev3dum(8) in (.C, .D, .E,.) or disabsev3dum(9) in (.C, .D, .E,.) or 
  disabsev3dum(10) in (.C, .D, .E,.) or 
  disabsev3dum(11) in (.C, .D, .E,.) or disabsev3dum(12) in (.C, .D, .E,.) or disabsev3dum(13) in (.C, .D, .E,.) 
  or disabsev3dum(14) in (.C, .D, .E,.) or disabsev3dum(15) in (.C, .D, .E,.) or 
  disabsev3dum(16) in (.C, .D, .E,.) or disabsev3dum(17) in (.C, .D, .E,.) or disabsev3dum(18) in (.C, .D, .E,.) 
  or disabsev3dum(19) in (.C, .D, .E,.) or disabsev3dum(20) in (.C, .D, .E,.) or 
  disabsev3dum(21) in (.C, .D, .E,.) or disabsev3dum(22) in (.C, .D, .E,.) or disabsev3dum(23) in (.C, .D, .E,.)
  or disabsev3dum(24) in (.C, .D, .E,.)  or disabsev3dum(25) in (.C, .D, .E,.) 
  then sevdisableby16='.';
else sevdisableby16=-4;

if disable16=0 then sevdisableby16=0;
else if disable16=-5 then sevdisableby16=-5;
else if disable16=-4 then sevdisableby16=-4;
else if disable16='.' then sevdisableby16='.';

label disable16="R Disabled Before or At Age 16";
label disable20="R Disabled Before or At Age 20";
label sevdisableby16="Severity of R's Disability Condition Before or At Age 16";
format sevdisableby16 severity.;
label sevdisableby20="Severity of R's Disability Condition Before or At Age 20";
format sevdisableby20 severity.;

*creating analytical enrollment variables;
if age97=16 then enrollment16=enroll97;
else if age98=16 then enrollment16=enroll98;
else if age99=16 then enrollment16=enroll99;
else if age00=16 then enrollment16=enroll00;
else if age01=16 then enrollment16=enroll01;
else if age02=16 then enrollment16=enroll02;
else if age03=16 then enrollment16=enroll03;
else if age04=16 then enrollment16=enroll04;

if enrollment16=1 then enroll16=1; 
else if enrollment16=2 then enroll16=2;
else if  enrollment16>=3 then enroll16=3;
else if enrollment16 in (-5,-4,.C,.D,.E,.) then enroll16=enrollment16;
if age97>16 then enroll16=.;
format enroll16 enroll16age.;
label enroll16='DROPPED OUT FROM HIGH SCHOOL BY AGE 16';

if age97=20 then highestdegever20=highestdeg97;
else if age98=20 then highestdegever20=highestdeg98;
else if age99=20 then highestdegever20=highestdeg99;
else if age00=20 then highestdegever20=highestdeg00;
else if age01=20 then highestdegever20=highestdeg01;
else if age02=20 then highestdegever20=highestdeg02;
else if age03=20 then highestdegever20=highestdeg03;
else if age04=20 or age04=19 then highestdegever20=highestdeg04;

if age97=20 then enrollment20=enroll97;
else if age98=20 then enrollment20=enroll98;
else if age99=20 then enrollment20=enroll99;
else if age00=20 then enrollment20=enroll00;
else if age01=20 then enrollment20=enroll01;
else if age02=20 then enrollment20=enroll02;
else if age03=20 then enrollment20=enroll03;
else if age04=20 or age04=19 then enrollment20=enroll04;

if highestdegever20=0 then degree20=1;
if highestdegever20=1 then degree20=2;
if highestdegever20=2 then degree20=3;
if enrollment20 in (9,10,11) or highestdegever20>2 then degree20=4;
if highestdegever20 in (-5,-4,.C,.D,.E,.) then degree20=highestdegever20;

label degree20='HIGHEST DEGREE EVER EARNED AT AGE 20';
format degree20 degree.;

IF DEGREE20 GT 1 THEN HSGED20 = 1;
IF DEGREE20 = 1 THEN HSGED20 =0;
IF DEGREE20 = . THEN HSGED20 = .;

label hsged20 ="Received at least a HS/GED by age 20";

IF DEGREE20 = 4 THEN college20 = 1;
IF DEGREE20 lt 4 THEN college20 =0;
IF DEGREE20 = . THEN college20 = .;

label college20 ="enrolled in post-secondary education by age 20";

*creating analytical parent variables;
if citizenship97 in (2,3) then citizenship97=0;

*creating analytical poverty variables;
if age97=16 then povlevel16=povratio97;
else if age98=16 then povlevel16=povratio98;
else if age99=16 then povlevel16=povratio99;
else if age00=16 then povlevel16=povratio00;
else if age01=16 then povlevel16=povratio01;
else if age02=16 then povlevel16=povratio02;
else if age03=16 then povlevel16=povratio03;
else if age04=16 then povlevel16=povratio04;

if age97=20 then povlevel20=povratio97;
else if age98=20 then povlevel20=povratio98;
else if age99=20 then povlevel20=povratio99;
else if age00=20 then povlevel20=povratio00;
else if age01=20 then povlevel20=povratio01;
else if age02=20 then povlevel20=povratio02;
else if age03=20 then povlevel20=povratio03;
else if age04=20 then povlevel20=povratio04;

if povlevel16 in (-5,-4,.C,.D,.E,.) then pov20016=povlevel16;
else if povlevel16<200 then pov20016=1;
else if povlevel16>=200 then pov20016=0;
if age97>16 then pov20016=-4;

if povlevel20 in (-5,-4,.C,.D,.E,.) then pov20020=povlevel20;
else if povlevel20<200 then pov20020=1;
else if povlevel20>=200 then pov20020=0;

label pov20016 = "Poverty Ratio Less Than 200 When 16";
label pov20020 = "Poverty Ratio Less Than 200 When 20";

*creating analytical rni variables;
if rni98>=80 then rni98=1; else if rni98>=0 then rni98=0;
if rni99>=80 then rni99=1; else if rni99>=0 then rni99=0;
if rni00>=80 then rni00=1; else if rni00>=0 then rni00=0;
if rni01>=80 then rni01=1; else if rni01>=0 then rni01=0;
if rni02>=80 then rni02=1; else if rni02>=0 then rni02=0;
if rni03>=80 then rni03=1; else if rni03>=0 then rni03=0;
if rni04>=80 then rni04=1; else if rni04>=0 then rni04=0;

*creating analytical parentmore variables;
if ownmobile in (1,2,3) or ownhouse=1 then RPhome97=1;
else if ownmobile in (4,7) or ownhouse in (2,3) then RPhome97=2;
else if ownmobile=-5 or ownhouse=-5 then RPhome97=-5;
else if ownmobile=-4 or ownmobile=-4 then RPhome97=-4;
else RPhome97=.;

if hhnetworth in (-4,-5,.C,.D,.E,.) then RPnetworth97=hhnetworth;
else if hhnetworth<=0 then RPnetworth97=1;
else if hhnetworth<=25000 then RPnetworth97=2;
else if hhnetworth<=50000 then RPnetworth97=3;
else if hhnetworth<=100000 then RPnetworth97=4;
else RPnetworth97=5;

label RPhome97 = "Responding Parent Home Ownership 1997";
label RPnetworth97 = "Net Worth of Household According to Responding Parent 1997";
format RPnetworth97 netwrth.;

/***************ADVICE**********************/

jobadvice = S3303700;
If jobadvice le 0 then jobadvice = .;
label jobadvice = 'First person R asks for job advice';
format jobadvice advceper.;

reladvice = S3303400;
If reladvice le 0 then reladvice = .;
label reladvice = 'First person R asks for relationship advice';
format reladvice advceper.;

finadvice = S3304000;
If finadvice le 0 then finadvice = .;
label finadvice = 'First person R asks for financial advice';
format finadvice advceper.;

dadfigad1 = R6513400;
If dadfigad1 le 0 then dadfigad1 = .;
label dadfigad1 = 'How often R asks father figure for help making decisions';
format dadfigad1 dechelp.;

dadfigad2 = R6513800;
If dadfigad2 le 0 then dadfigad2 = .;
label dadfigad2 = 'How often R asks father figure for advice on relationships';
format dadfigad2 dechelp.;

biodadad1 = R6513300;
If biodadad1 le 0 then biodadad1 = .;
label biodadad1 = 'How often R asks biological father for help making decisions';
format biodadad1 dechelp.;

biodadad2 = R6513700;
If biodadad2 le 0 then biodadad2 = .;
label biodadad2 = 'How often R asks biological father for advice on relationships';
format biodadad2 dechelp.;

momfigad1 = R6513200;
If momfigad1 le 0 then momfigad1 = .;
label momfigad1 = 'How often R asks mother figure for help making decisions';
format momfigad1 dechelp.;

momfigad2 = R6513600;
If momfigad2 le 0 then momfigad2 = .;
label momfigad2 = 'How often R asks mother figure for advice on relationships';
format momfigad2 dechelp.;

biomomad1 = R6513100;
If biomomad1 le 0 then biomomad1 = .;
label biomomad1 = 'How often R asks biological mom for help making decisions';
format biomomad1 dechelp.;

biomomad2 = R6513500;
If biomomad2 le 0 then biomomad2 = .;
label biomomad2 = 'How often R asks biological mom for advice on relationships';
format biomomad2 dechelp.;

age97=R1194100;
age98=R2553500;
age99=R3876300;
age00=R5453700;
age01=R7216000;
age02=S1531400;
age03=S2001000;
age04=S3801100;

label age97 = "r age at interview date 1997";
label age98 = "r age at interview date 1998";
label age99 = "r age at interview date 1999";
label age00 = "r age at interview date 2000";
label age01 = "r age at interview date 2001";
label age02 = "r age at interview date 2002";
label age03 = "r age at interview date 2003";
label age04 = "r age at interview date 2004";

poshel97=.;
poshel98=.;
poshel99=.;
poshel00=.;
poshel01=.;
poshel02=.;
poshel03=.;
poshel04=.;

/*********positive health = very good, excellent******/
R032060r=5-R0320600;
if R032060r ge 3 then poshel97=1;
if 0<= R032060r <=2 then poshel97=0;

R216400r=5-R2164000;
if R216400r ge 3 then poshel98=1;
if 0<= R216400r <=2 then poshel98=0;

R348190r=5-R3481900;
if R348190r ge 3 then poshel99=1;
if 0<= R348190r <=2 then poshel99=0;

R488010r=5-R4880100;
if R488010r ge 3 then poshel00=1;
if 0<= R488010r <=2 then poshel00=0;

R649750r=5-R6497500;
if R649750r ge 3 then poshel01=1;
if 0<= R649750r <=2 then poshel01=0;

S122500r=5-S1225000;
if S122500r ge 3 then poshel02=1;
if 0<= S122500r <=2 then poshel02=0;

S330250r=5-S3302500;
if S330250r ge 3 then poshel03=1;
if 0<= S330250r <=2 then poshel03=0;

S491950r=5-S4919500;
if S491950r ge 3 then poshel04=1;
if 0<= S491950r <=2 then poshel04=0;

if age97=16 then poshel16=poshel97;
else if age98=16 then poshel16=poshel98;
else if age99=16 then poshel16=poshel99;
else if age00=16 then poshel16=poshel00;
else if age01=16 then poshel16=poshel01;
else if age02=16 then poshel16=poshel02;
else if age03=16 then poshel16=poshel03;
else if age04=16 then poshel16=poshel04;
else poshel16=.;

if age97=17 then poshel17=poshel97;
else if age98=17 then poshel17=poshel98;
else if age99=17 then poshel17=poshel99;
else if age00=17 then poshel17=poshel00;
else if age01=17 then poshel17=poshel01;
else if age02=17 then poshel17=poshel02;
else if age03=17 then poshel17=poshel03;
else if age04=17 then poshel17=poshel04;
else poshel17=.;

if age97=18 then poshel18=poshel97;
else if age98=18 then poshel18=poshel98;
else if age99=18 then poshel18=poshel99;
else if age00=18 then poshel18=poshel00;
else if age01=18 then poshel18=poshel01;
else if age02=18 then poshel18=poshel02;
else if age03=18 then poshel18=poshel03;
else if age04=18 then poshel18=poshel04;
else poshel18=.;

if age97=19 then poshel19=poshel97;
else if age98=19 then poshel19=poshel98;
else if age99=19 then poshel19=poshel99;
else if age00=19 then poshel19=poshel00;
else if age01=19 then poshel19=poshel01;
else if age02=19 then poshel19=poshel02;
else if age03=19 then poshel19=poshel03;
else if age04=19 then poshel19=poshel04;
else poshel19=.;

if age97=20 then poshel20=poshel97;
else if age98=20 then poshel20=poshel98;
else if age99=20 then poshel20=poshel99;
else if age00=20 then poshel20=poshel00;
else if age01=20 then poshel20=poshel01;
else if age02=20 then poshel20=poshel02;
else if age03=20 then poshel20=poshel03;
else if age04=20 then poshel20=poshel04;
else poshel20=.;

label poshel16 = 'positive health at age 16';
label poshel20 = 'positive health at age 20';
format poshel16 yes10no.;
format poshel20 yes10no.;

/*************positive health scale********/
array hel3{5} poshel16 poshel17 poshel18 poshel19 poshel20;
hel3m=0;
    do a= 1 to 5;
      if hel3{a}=. then hel3m=hel3m+1;
    end;
       if hel3m le 1 then do;
        sumposhlthage = sum (poshel16, poshel17, poshel18, poshel19, poshel20)*(5/(5-hel2m));
        end;
label sumposhlthage = '5 item Positive health scale, 5 point scale, age 16-20';

poshelage=.;
if sumposhlthage>3 then poshelage=1;
if 0<=sumposhlthage<=3 then poshelage=0;
label poshelage = 'Positive Health = Score of 4 or greater on 5-item positive health scale from age 16 to 20';
format poshelage yes10no.;

/******************DISCONNECTED ROUND 6*****************/
/*Currently enrolled in school (college or hs)*/

enrol6 = .;
if S1538000 lt 0 then enrol6 = .;
else enrol6 = S1538000;

if enrol6 in (8,9,10,11) then curenroll6 = 1;
Else if enrol6 in (1,2,3,4,5,6,7) then curenroll6 = 0;
Label curenroll6 = "R is currently enrolled in school (college or HS), round 6";
Format curenroll6 yes10no.;

/*Employment Round 6*/

emp6 = .;
If S1512800 = 1 or S1512900 = 1 or S1513000 = 1 or S1513100 = 1 or S1513200 = 1 or S1513300 = 1
or S1513400 = 1 or S1513500 = 1 or S1513600 = 1 or S1513700 = 1 or S1513800 = 1 then emp6 = 1;
Else if S1512800 le 0 and S1512900 le 0 and S1513000 le 0 and S1513100 le 0 and S1513200 le 0 and S1513300 le 0
and S1513400 le 0 and S1513500 le 0 and S1513600 le 0 and S1513700 le 0 and S1513800 le 0 then emp6 = 0;
Label emp6 = 'R has at least one employer on roster, R6';
format emp6 employ.;

/*Diconnection Round 6*/

If curenroll6 = 1 or emp6 = 1 then disconnected6 = 0;
else if curenroll6=. and emp6 in (0,1) then disconnected6 = 0;
Else if curenroll6 = 0 and emp6 = 0 then disconnected6 = 1;
Label disconnected6 = "R is neither enrolled in school nor working for an employer (round 8)";
format disconnected6 discon.;

/******************DISCONNECTED ROUND 7*****************/
/*Currently enrolled in school (college or hs)*/

If S2007700 lt 0 then enrol7 = .;
Else enrol7 = S2007700;

If enrol7 in (8,9,10,11) then curenroll7 = 1;
Else if enrol7 in (1,2,3,4,5,6,7) then curenroll7 = 0;
Label curenroll7 = "R is currently enrolled in school (college or HS), round 7";
Format curenroll7 yes10no.;

Emp7 = .;

If S3579600 = 1 or S3579700 = 1 or S3579800 = 1 or S3579900 = 1 or S3580000 = 1 or S3580100 = 1 or S3580200 = 1 or S3580300 = 1 or 
S3580400 = 1 or S3580500 = 1 then emp7 = 1; /*Answered yes to one of the employers on roster*/
Else if S3579600 le 0 and S3579700 le 0 and S3579800 le 0 and S3579900 le 0 and S3580000 le 0 and S3580100 le 0 
and S3580200 le 0 and S3580300 le 0 and S3580400 le 0 and S3580500 le 0 then emp7 = 0; /*Answered no (or NA) to all employers on roster*/
Label emp7 = "R has at least one empyer on roster, round7";
Format emp7 yes10no.;

If curenroll7 = 1 or emp7 = 1 then disconnected7 = 0;
else if curenroll7=. and emp7 in (0,1) then disconnected7 = 0;
else If curenroll7 = 0 and emp7 = 0 then disconnected7 = 1;
Label disconnected7 = "R is neither enrolled in school nor working for an employer (round 7)";
format disconnected7 yes10no.;

/*********************DISCONNECTED ROUND 8*****************/

/*Currently enrolled in school (college or hs)*/

If S3808500 lt 0 then enrol8 = .;
Else enrol8 = S3808500;

If enrol8 in (8,9,10,11) then curenroll8 = 1;
Else if enrol8 in (1,2,3,4,5,6,7) then curenroll8 = 0;
Label curenroll8 = "R is currently enrolled in school (college or HS), round 8";
Format curenroll8 curenroll.;

Emp8 = .;
If S5097500 = 1 or S5097600 = 1 or S5097700 = 1 or S5097800 = 1 or S5097900 = 1 or S5098000 = 1 or S5098100 = 1 then emp8 = 1; /*Answered yes to one of the employers on roster*/
Else if S5097500 le 0 and S5097600 le 0 and S5097700 le 0 and S5097800 le 0 and S5097900 le 0 and S5098000 le 0 
and S5098100 le 0 then emp8 = 0; /*Answered no (or NA) to all employers on roster*/
Label emp8 = "R has at least one empyer on roster, round8";
Format emp8 employ.;

If curenroll8 = 1 or emp8 = 1 then disconnected8 = 0;
else if curenroll8=. and emp8 in (0,1) then disconnected8 = 0;
Else if curenroll8 = 0 and emp8 = 0 then disconnected8 = 1;
Label disconnected8 = "R is neither enrolled in school nor working for an employer (round 8)";
format disconnected8 discon.;

/************************religious attendance from age 16 to 20***************************/
age00=R5453700;
age01=R7216000;
age02=S1531400;
age03=S2001000;
age04=S3801100;
label age00 = "r age at interview date 2000";
label age01 = "r age at interview date 2001";
label age02 = "r age at interview date 2002";
label age03 = "r age at interview date 2003";
label age04 = "r age at interview date 2004";

if R4893400 ge 5 then relatt00=1;
else if 1<=R4893400<=4 then relatt00=0;
else relatt00=.;

if R6520100 ge 5 then relatt01=1;
else if 1<=R6520100<=4 then relatt01=0;
else relatt01=.;

if S0919300 ge 5 then relatt02=1;
else if 1<=S0919300<=4 then relatt02=0;
else relatt02=.;

if S2987800 ge 5 then relatt03=1;
else if 1<=S2987800<=4 then relatt03=0;
else relatt03=.;

if S4681700 ge 5 then relatt04=1;
else if 1<=S4681700<=4 then relatt04=0;
else relatt04=.;

Label relatt00 = "how often r attended worship service 2000";
Label relatt01 = "how often r attended worship service 2001";
Label relatt02 = "how often r attended worship service 2002";
Label relatt03 = "how often r attended worship service 2003";
Label relatt04 = "how often r attended worship service 2004";

if age00=16 then relatt16=relatt00;
else if age01=16 then relatt16=relatt01;
else if age02=16 then relatt16=relatt02;
else if age03=16 then relatt16=relatt03;
else if age04=16 then relatt16=relatt04;
else relatt16=.;

if age00=17 then relatt17=relatt00;
else if age01=17 then relatt17=relatt01;
else if age02=17 then relatt17=relatt02;
else if age03=17 then relatt17=relatt03;
else if age04=17 then relatt17=relatt04;
else relatt17=.;

if age00=18 then relatt18=relatt00;
else if age01=18 then relatt18=relatt01;
else if age02=18 then relatt18=relatt02;
else if age03=18 then relatt18=relatt03;
else if age04=18 then relatt18=relatt04;
else relatt18=.;

if age00=19 then relatt19=relatt00;
else if age01=19 then relatt19=relatt01;
else if age02=19 then relatt19=relatt02;
else if age03=19 then relatt19=relatt03;
else if age04=19 then relatt19=relatt04;
else relatt19=.;

if age00=20 then relatt20=relatt00;
else if age01=20 then relatt20=relatt01;
else if age02=20 then relatt20=relatt02;
else if age03=20 then relatt20=relatt03;
else if age04=20 then relatt20=relatt04;
else relatt20=.;

Array religious{5} relatt16 relatt17 relatt18 relatt19 relatt20;

/*remove missings*/
misrel=0;
    do a= 1 to 5;
      if religious{a}=. then misrel=misrel+1;
    end;
       if misrel le 1 then do;
        relsum = sum (relatt16, relatt17, relatt18, relatt19, relatt20)*(5/(5-misrel));
        end;
label relsum = 'religious attendance sum from age 16 to 20';

relcons=.;
if relsum>3 then relcons=1;
if 0<=relsum<=3 then relcons=0;
label relcons = 'consistent religious attendance from age 16 to 20';
format relcons yes10no.;

/************************family religious attendance from age 16 to 20***************************/

famrel97=.;
if R0323900 ge 1 then famrel97=1;
else if R0323900=0 then famrel97=0;
else famrel97=.;

famrel98=.;
if R2165200 ge 1 then famrel98=1;
else if R2165200=0 then famrel98=0;
else famrel98=.;

famrel99=.;
if R3483100 ge 1 then famrel99=1;
else if R3483100=0 then famrel99=0;
else famrel99=.;

famrel00=.;
if R4881300 ge 1 then famrel00=1;
else if R4881300=0 then famrel00=0;
else famrel00=.;

Label famrel97 = "Does family engage in a religious activity at least once during a typical week '97";
Label famrel98 = "Does family engage in a religious activity at least once during a typical week '98";
Label famrel99 = "Does family engage in a religious activity at least once during a typical week '99";
Label famrel00 = "Does family engage in a religious activity at least once during a typical week '00";

if age97=16 then famrel16=famrel97;
else if age98=16 then famrel16=famrel98;
else if age99=16 then famrel16=famrel99;
else if age00=16 then famrel16=famrel00;
else famrel16=.;

if age97=17 then famrel17=famrel97;
else if age98=17 then famrel17=famrel98;
else if age99=17 then famrel17=famrel99;
else if age00=17 then famrel17=famrel00;
else famrel17=.;

if age97=18 then famrel18=famrel97;
else if age98=18 then famrel18=famrel98;
else if age99=18 then famrel18=famrel99;
else if age00=18 then famrel18=famrel00;
else famrel18=.;

if age97=19 then famrel19=famrel97;
else if age98=19 then famrel19=famrel98;
else if age99=19 then famrel19=famrel99;
else if age00=19 then famrel19=famrel00;
else famrel19=.;

if age97=20 then famrel20=famrel97;
else if age98=20 then famrel20=famrel98;
else if age99=20 then famrel20=famrel99;
else if age00=20 then famrel20=famrel00;
else famrel20=.;

Array famrel{5} famrel16 famrel17 famrel18 famrel19 famrel20;

/*remove missings*/
misfamre=0;
    do a= 1 to 5;
      if famrel{a}=. then misfamre=misfamre+1;
    end;
       if misfamre le 1 then do;
        frelsum = sum (famrel16, famrel17, famrel18, famrel19, famrel20)*(5/(5-misfamre));
        end;
label frelsum = 'family religious attendance sum from age 16 to 20';

frelcons=.;
if frelsum>3 then frelcons=1;
if 0<=frelsum<=3 then frelcons=0;
label frelcons = 'consistent family religious attendance from age 16 to 20';
format frelcons yes10no.;

/*Family and R attendance - combined consistency measure*/
array famrelc {5} famrel16 famrel17 relatt18 relatt19 relatt20;
mfamrelc=0;
	do a = 1 to 5;
		if famrelc{a}=. then mfamrelc=mfamrelc+1;
	end;
		if mfamrelc le 1 then do;
		famrelcs = sum (famrel16, famrel17, relatt18, relatt19, relatt20)*(5/(5-mfamrelc));
		end;
label famrelcs = 'Sum of family and R religious attendance'; /*This combines family religious attendance
at age 16 and 17 with R's own religious attendance at ages 18, 19, and 20*/

famrelco=.;
if famrelcs ge 4 then famrelco =1;
if famrelcs le 3 then famrelco = 0;
if famrelcs = . then famrelco = .;
label famrelco = 'Consistent family and personal religious attendance age 16 to 20';

/*************************Parent employment***********************/

array empl (10) R1089800 R1089900 R1090000 R1090100
R1090200 R1090300 R1090400 R1090500 R1090600 R1090700;
momemp=.;stmomemp=.;dademp=.;stdademp=.;

do k=1 to 10;
if R0533600 eq k then momemp=empl(k);
if R0536000 eq k then stmomemp=empl(k);
if R0532300 eq k then dademp=empl(k);
if R0535900 eq k then stdademp=empl(k);

end;

momemp97=.; dademp97=.;
if momemp>=0 then momemp97=momemp;
else if stmomemp>=0 then momemp97=stmomemp;
if dademp>=0 then dademp97=dademp;
else if stdademp>=0 then dademp97=stdademp;

%macro plug(var,miss,meanmode,oldlabel,oldformat);
if &miss < 5 then do; 
	if &var =  . then p_&var = &meanmode; 
	else p_&var = &var; 
end; 
else if &miss >= 5 then do; 
	if &var =  . then do; 
		p_&var = &meanmode; 
		miss_&var = 1; 
	end; 
	else do; 
		p_&var = &var; 
		miss_&var = 2; 
	end; 
label miss_&var = "MISSING &oldlabel"; 
end; 
label p_&var = "&oldlabel (M PLUGGED)"; 
format p_&var &oldformat;
%mend; 

/****peer characteristics: positive behaviors****/
church=.;
if R0070300<0 then church=.;
else church=R0070300;
label church = "% PEERS GO TO CHURCH REGULARLY 1997";
format church peer.;

sports=.;
if R0070600<0 then sports=.;
else sports=R0070600;
label sports = "% PEERS SPORTS, CLUBS, SCH ACTS 1997";
format sports peer.;

college=.;
if R0070800<0 then college=.;
else college=R0070800;
label college = "% PEERS PLAN TO GO TO COLL 1997";
format college peer.;

volunteer=.;
if R0070900<0 then volunteer=.;
else volunteer=R0070900;
label volunteer = "% PEERS VOLUNTEER 1997";
format volunteer peer.;

%let positive = church, sports, college, volunteer;
	If nmiss(&positive) le 1 then pospeer= (sum (&positive)*4)/(4-(nmiss(&positive)));
	Label pospeer = '4-Item Positive Peer Index Without Dividing By 4';
peerpos= Round (pospeer/4);
label peerpos='4-Item Positive Peer Index 1=Almost none 2=About 25% 3=About 50% 4=About 75% 5=Almost all';
format peerpos peer.;

/****peer characteristics: substances****/
smoke=.;
if R0070400<0 then smoke=.;
else smoke=R0070400;
label smoke = "% PEERS SMOKE 1997";
format smoke peer.;

drunk=.;
if R0070500<0 then drunk=.;
else drunk=R0070500;
label drunk = "% PEERS DRUNK 1+/MO 1997";
format drunk peer.;

drugs=.;
if R0071000<0 then drugs=.;
else drugs=R0071000;
label drugs = "% PEERS USE ILLEGAL DRUGS 1997";
format drugs peer.;

peersub=Round((smoke+drunk+drugs)/3);
label peersub='3-Item Substance Use Peer Index 1=Almost none 2=About 25% 3=About 50% 4=About 75% 5=Almost all';
format peersub peer.;

/****peer characteristics: negative****/
gangs=.;
if R0070700<0 then gangs=.;
else gangs=R0070700;
label gangs = "% PEERS BELONG TO GANG 1997";
format gangs peer.;

cutclass=.;
if R0071100<0 then cutclass=.;
else cutclass=R0071100;
label cutclass = "% PEERS CUT CLASS/SCH 1997";
format cutclass peer.;

hadsex=.;
if R0071300<0 then hadsex=.;
else hadsex=R0071300;
label hadsex = "% PEERS HAD SEX 1997";
format hadsex peer.;

peerneg=Round((gangs+cutclass+hadsex)/3);
label peerneg='3-Item Negative Peer Index 1=Almost none 2=About 25% 3=About 50% 4=About 75% 5=Almost all';
format peerneg peer.;

/****taking sex out of negative peer index****/
peerneg2=Round((gangs+cutclass)/2);
label peerneg2='2-Item Negative Peer Index (without sex)';
format peerneg2 peer.;

/****combining negative peer characteristics and peer substance use scales****/
%let negsub = gangs, cutclass, smoke, drunk, drugs;
	If nmiss(&negsub) le 1 then negsubscl= (sum (&negsub)*5)/(5-(nmiss(&negsub)));
	Label negsubscl = '5-Item Negative Peer Index Without Dividing By 5';
peernegsub= Round (negsubscl/5);
label peernegsub='5-Item Negative Peer Index 1=Almost none 2=About 25% 3=About 50% 4=About 75% 5=Almost all';
format peernegsub peer.;

/****parent involvement in school reverse coded****/

ptar=.;
if R0674000<0 then ptar=.;
else ptar=(4-R0674000);
label ptar="PR/SP ATTEND MEETING PTA/PTO? 1997";
format ptar pinvolr.;

classvolr=.;
if R0674100<0 then classvolr=.;
else classvolr=(4-R0674100);
label classvolr="PR/SP VOLUNTEER HELP CLASSROOM? 1997";
format classvolr pinvolr.;

parinvolvr=ptar + classvolr - 2;
label parinvolvr='2-Item Parent Involvement Index 1=Never 2=Sometimes 3=Often';

/***************Region of Country******************/;
%dummy (region97, Northeast NCentral South West);

/***************RECODE DISABLE******************/;
if disable16 le 0 then disable16a = 0;
if disable16 = . then disable16a = 0;
if disable16 gt 0 then disable16a = 1;

/***************RECODE BIOMOMAGE******************/;
if biomomage = . then bmomage = 2;
if biomomage lt 20 then bmomage = 1;
if biomomage ge 20 and biomomage lt 30 then bmomage = 2;
if biomomage ge 30 and biomomage lt 40 then bmomage = 3;
if biomomage ge 40 then bmomage = 4;
label bmomage = 'bio moms age at birth';
%dummy (bmomage, bmomteen bmom20 bmom30 bmom40);

/***************RECODE LENGTH OF MARRIAGE******************/;
if rpmarr97 lt 10 then marlngth = 1;
if rpmarr97 ge 10 and rpmarr97 lt 20 then marlngth = 2;
if rpmarr97 ge 20 and rpmarr97 lt 30 then marlngth = 3;
if rpmarr97 ge 30 then marlngth = 4;
label marlngth = 'length of parents marriage';
%dummy (marlngth, mar0_9 mar10_19 mar20_29 mar30plu);

/***************RECODE PHYSICAL ENVIRONMENT******************/;
phyenv = .;
if R1487100 lt 0 then phyenv = 0;
if R1487100 ge 0 then phyenv = R1487100/100;
label phyenv = 'physical environment risk index 1997';

/***************RECODE PARENTAL EMPLOYMENT******************/;
parempl = .;
if momemp97 = 0 and dademp97 = 0 then parempl = 1;
if momemp97 = . and dademp97 = 0 then parempl = 1; 
if momemp97 = 0 and dademp97 = . then parempl = 1;
if momemp97 in (1, 2) or dademp97 in (1,2) then parempl = 2;
if momemp97 in (1, 2) and dademp97 in (1,2) then parempl = 3;

label parempl = 'Parent employment';
%dummy (parempl, notempl oneempl bothempl);

proc sort; by  R0000100; run; 

data yrdyr; set datalib2.yrdyr_4c;

label DINT = 'average intercept of dad youth relationship';
label DSLOPE = 'average slope of dad youth relationship';
label YRDYR_C_DINT = 'average intercept of dad youth relationship by class';
label YRDYR_C_DSLOPE = 'average slope of dad youth relationship by class';
label YRDYR_CPROB1 = 'class probability for high quality dad youth relationship over time';
label YRDYR_CPROB2 = 'class probability for low quality dad youth relationship increasing over time';
label YRDYR_CPROB3 = 'class probability for low quality dad youth relationship over time';
label YRDYR_CPROB4 = 'class probability for high quality dad youth relationship decreasing over time';
label YRDYR_CLASS = 'most likely class assignment for dad youth relationship over time';

format YRDYR_CLASS ydyr.;

proc sort; by  R0000100; run;

data yrmarqual; set datalib2.yrmql_4c_rd1;

label YRMQ_CPROB1 = 'class probability for high support high conflict mar qual rd1';
label YRMQ_CPROB2  = 'class probability for high support low conflict mar qual rd1';
label YRMQ_CPROB3  = 'class probability for low support low conflict mar qual rd1';
label YRMQ_CPROB4 = 'class probability for low support high conflict mar qual rd1';
label YRMQ_CLASS = 'most likely class assignment for yr marital quality round 1';

format YRMQ_CLASS yrmarqual.;

proc sort; by  R0000100; run;

data yrmyr; set datalib2.yrmyr_4c;

label MINT  = 'average intercept of Mom youth relationship';
label MSLOPE  = 'average slope of Mom youth relationship';
label YRMYR_C_MINT = 'average intercept of mom youth relationship by class';
label YRMYR_C_MSLOPE = 'average slope of mom youth relationship by class';
label YRMYR_CPROB1 = 'class probability for high quality mom youth relationship over time';
label YRMYR_CPROB2 = 'class probability for low quality mom youth relationship increasing over time';
label YRMYR_CPROB3  = 'class probability for high quality mom youth relationship decreasing over time';
label YRMYR_CPROB4 = 'class probability for low quality mom youth relationship over time';
label YRMYR_CLASS = 'most likely class assignment for mom youth relationship over time';

format yrmyr_class yrmyr.;

proc sort; by  R0000100; run;


data merge_profiles;
merge datalib.famstrength2 yrmyr yrmarqual yrdyr;
by R0000100;

run;


data datalib.famstr_profiles;
set merge_profiles;

%macro dummy(oldvar, newdums);
array dum_&oldvar(*) &newdums;
do i=1 to dim(dum_&oldvar);
if &oldvar=i then do;
dum_&oldvar(i)=1;
end;
else if &oldvar ne . then dum_&oldvar(i)=0;
end;
%mend;

%dummy (yrmyr_class, mhisust mlowinc mhidecr mlowsust);
%dummy (yrdyr_class, dhisust dlowinc dlowsust dhidecr);
%dummy (YRMQ_CLASS, hisup_hicon hisup_lowcon lowsup_lowcon lowsup_hicon);


label yrparadol_profiles = 'combo of y-m and y-d profiles over time';

yrparadol_profiles = .;
if YRDYR_CLASS = 1 and YRMYR_CLASS = 1 then yrparadol_profiles = 1; /*both high sustained*/
if YRDYR_CLASS = 1 and YRMYR_CLASS in (.,2,3,4) then yrparadol_profiles = 2; /*dad only high sustained*/
if YRDYR_CLASS in (.,2,3,4) and YRMYR_CLASS = 1 then yrparadol_profiles = 3; /*mom only high sustained*/
if YRDYR_CLASS = 2 and YRMYR_CLASS = 2 then yrparadol_profiles = 4; /*both low and increasing over time*/
if YRDYR_CLASS = 3 and YRMYR_CLASS = 2 then yrparadol_profiles = 4; /*low*/
if YRDYR_CLASS = 2 and YRMYR_CLASS = 4 then yrparadol_profiles = 4; /*low*/
if YRDYR_CLASS = . and YRMYR_CLASS in (2,4) then yrparadol_profiles = 4; /*low*/
if YRDYR_CLASS in (2,3) and YRMYR_CLASS = . then yrparadol_profiles = 4; /*low*/
if YRDYR_CLASS = 3 and YRMYR_CLASS =2 then yrparadol_profiles = 4; /*dad only low sustained*/
if YRDYR_CLASS = 4 and YRMYR_CLASS = 3 then yrparadol_profiles = 5; /*both high and decreasing over time*/
if YRDYR_CLASS = . and YRMYR_CLASS = 3 then yrparadol_profiles = 5; /*both high and decreasing over time*/
if YRDYR_CLASS = 4 and YRMYR_CLASS = . then yrparadol_profiles = 5; /*both high and decreasing over time*/
if YRDYR_CLASS = 4 and YRMYR_CLASS in (2,4) then yrparadol_profiles = 6; /* one high  and one low*/
if YRDYR_CLASS in (2,3) and YRMYR_CLASS = 3 then yrparadol_profiles = 6; /*one high  and one low*/
if YRDYR_CLASS = 3 and YRMYR_CLASS = 4 then yrparadol_profiles = 7; /*both low sustained*/

yrpy_profiles = .;
if yrparadol_profiles = 1 then yrpy_profiles = 1;
if yrparadol_profiles = 2 then yrpy_profiles = 2;
if yrparadol_profiles = 3 then yrpy_profiles = 3;
if yrparadol_profiles in (4,5,6,7) then yrpy_profiles = 4;
label yrpy_profiles = 'ym and yd relationship profiles over time';
format yrpy_profiles yrpycat.;

%dummy (yrpy_profiles, bothpyhi dadhi momhi pylow);


label yrmarqual_parrel = 'Combination of marital quality and parent youth relationship profiles';
yrmarqual_parrel = .;
if YRMQ_CLASS = 2 and yrpy_profiles = 1 then yrmarqual_parrel = 1; /*hi mq and good py rel with both*/
if YRMQ_CLASS = 2 and yrpy_profiles in (2,3)then yrmarqual_parrel = 2; /*hi mq and good py rel with one parent*/
if YRMQ_CLASS = 1 and yrpy_profiles in (1,2,3) then yrmarqual_parrel = 3; /*hi supp/hi conflict mq and good py rel*/
if YRMQ_CLASS in (3,4) and yrpy_profiles in (1,2,3) then yrmarqual_parrel = 4; /*low mq and good py rel*/
if YRMQ_CLASS in (2) and yrpy_profiles in (4) then yrmarqual_parrel = 5; /*hig mq and bad py rel*/
if YRMQ_CLASS in (1,3,4) and yrpy_profiles in (4) then yrmarqual_parrel = 6; /*low mq and bad py rel*/

format yrmarqual_parrel yrpymqcat.;

%dummy (yrmarqual_parrel, himq_bothhipy himq_onehipy hisupphicon_goodpy lomq_goodpy himq_badpy lowmq_badpy);

run;

data datalib.fam_profiles_final
(keep =
/*YOUTH ID*/
R0000100

/*Families married at R1, limited to Y aged 12-14*/
MARRIED1 Marrsamp

/*Family structure*/
fmstrc97 biomry97 step97 singpar97 othfam97
fmstrc98 biomry98 step98 singpar98 othfam98
fmstrc99 biomry99 step99 singpar99 othfam99

/*Gender*/
sex sex97 

/*Youth age*/
y_age

/*Youth race*/
race white black hispanic natvamer asian other

/*R's race and ethnicity*/
raceth97 

/*R's census region in R1*/
region97 Northeast NCentral South West 

/*R's urban/rural residence in R1 rural=0/urban=1*/
urban97c 

/*Parent education*/
respared lesshs hsgrad somecoll collgrad

/*Income*/
income poverty povlt100 povlt200 povlt400 povgt400 povmiss

/*delinquency outcomes*/
/*run16 gun16 gang16 desprop16 stl50ls16 stl50pl16 othprp16 attack16 drugs16 
run20 gun20 gang20 desprop20 stl50ls20 stl50pl20 othprp20 attack20 drugs20 */
dlnqscl9_16 dlnqscl9_20 dlnqscl8a_16 dlnqscl8a_20
evarrest16 evarrest20 

/*Disability status 1: any type of disability 0: not disabled*/
disable16 disable16a
disable20

/*Highest degree at age 20*/
degree20
hsged20
college20
/*School enrollment at age 16 3:enrolled 2:drop out GED 3: drop out no degree*/
enroll16 
/*High school grades 1: mostly Bs or better 0:Anything worse*/
grade 

/*BioMom's age at R's birth: age in years*/
BioMomage bmomage bmomteen bmom20 bmom30 bmom40

/*Parents age in years of resident bio or step-mom*/
momage97
dadage97
/*Number of R's siblings includes all full and half siblings*/
numsibs
/*Parent employment*/
Momemp97 Dademp97 parempl
notempl oneempl bothempl

/*R's immigrant status (born in this country or not) 1:citizen 0:unknown/not citizen*/
citizenship97 
/*Parent health*/
RPhealth97      
RPShealth97 
/*Responding parent's self assessment of spouse's health in R1*/
/*Parent Income/assets*/
/*Par. rpt of Receipt of public assist. Ever since child was born 1: yes 0:no*/
RPgovtaid97
/*Does responding parent own home/site/lot/apartment? 1: yes 0:no*/
RPhome97 
/*Net worth of responding parent*/
RPnetworth97 
/*poverty status 1: family inc >=200% of pov. level 0: below*/
pov20016 
pov20020 

/*substance abuse outcomes*/
hvysmk16 hvysmk20 smoke16 drink16 pot16 coke16 
bngdrnk16 bngdrnk20
anybng16 anybng20
smoke20 drink20 
subscl2_16 subscl2_20
pot20 coke20 
erlydrnk erlysmke erlypot erlycoke erly_idx drkund21 

/*vote*/
vote04 regvote04

/*parent advice*/
biomomad1 momfigad1 biodadad1 dadfigad1
biomomad2 momfigad2 biodadad2 dadfigad2

/* 1st to turn to     1=biomom 2=biodad 3=stepdad*/
finadvice reladvice jobadvice
/*communication with parents/parent figures*/
dadfigcm biodadcm momfigcm biomomcm /*sum scale of all 4 rounds*/

/*mental and physical health*/
menhel00 menhel02 menhel04 adultmh
sumposhl poshel 
sumneghl neghel 
genheal
poshel16 
poshel20
poshelage

/********disconnected********/
emp8
curenroll8
disconnected8
emp6
curenroll6
disconnected6
emp7
curenroll7
disconnected7

/*religiosity*/
relig02
relcons
relatt16 relatt17 relatt18 relatt19 relatt20
famrelco
famrel16
prelig02
prelatt
relatt97


/*parent education*/
respared
dadedmis
resdaded
momedmis
resmomed

/*parent number of marriages*/
/*Pmarnum97
/*parent number of years in current marriage*/
Rpmarr97 marlngth mar0_9 mar10_19 mar20_29 mar30plu

/*sex vars*/
/*safe sex at 16 and 20*/
finalsafe
finalsafe20

/*unsafe sex at 16 and 20*/

hadsex16
/*r had sex before 18*/
sexb4_18



/****advice***/
jobadvice
reladvice
finadvice
dadfigad1
dadfigad2
biodadad1
biodadad2
momfigad1
momfigad2
biomomad1
biomomad2

/*disruption*/
disrup9799

/*lies or cheats*/
cheat


/**********Parent-Youth relationship**********/
/*Youth-mom rel (raw variables to create 8 scale)*/
R0324700 R032480R R0324900 R032500R R032510R/*leave out for 7 item*/ R0324400 R0324500 R0324600 /*r1*/
R2165400 R216580R R2165500 R216600R R216610R/*leave out for 7 item*/ R2165600 R2165700 R2165900 /*r2*/
R348370R R348400R/*leave out for 7 item*/ R348390R R3483800 R3483600 R3483300 R3483400 R3483500 /*r3*/
/*youth-mother rel for all three rounds*/
YMREL797 YMREL798 YMREL799
POSYM97 POSYM98 POSYM99 MYPOSRELSUM 
/*youth-dad rel (raw variables to create 8 scale)*/
R0326500 R032660R R0326700 R032680R R032690R/*leave out for 7 item*/ R0326200 R0326300 R0326400 /*r1*/
R216740R R216760R R216770R/*leave out for 7 item*/ R2167300 R2167500 R2167000 R2167100 R2167200 /*r2*/
R348530R R348550R R348560R/*leave out for 7 item*/ R3485200 R3485400 R3484900 R3485000 R3485100 /*r3*/
/*youth-father rel for all three rounds*/
POSYD97 POSYD98 POSYD99 
YDREL797 YDREL798 YDREL799
/**********Youth report of mar qual (raw variables to create scale at r1)***/
/*mother supports father (raw variables to create scale)*/
R034590R R034610R R034630R R0345800 R0346000 R0346200 /*r1*/
R217850R R217870R R217890R R2178400 R2178600 R2178800 /*r2*/
R349640R R349660R R349680R R3496300 R3496500 R3496700 /*r3*/
/*mother-father rel (youth report) for all three rounds*/
POSMMQ97 POSMMQ98 POSMMQ99
MMARQ97 MMARQ98 MMARQ99
/*father supports mother (raw variables to create scale*/
R034650R R034670R R034690R R0346400 R0346600 R0346800 /*r1*/
R217910R R217930R R217950R R2179000 R2179200 R2179400 /*r2*/
R349700R R349720R R349740R R3496900 R3497100 R3497300 /*r3*/
/*father-mother rel (youth report) for all three rounds*/
POSDMQ97 POSDMQ98 POSDMQ99 
DMARQ97 DMARQ98 DMARQ99
/**********PARENT REPORT OF MARITAL QUALITY**********/
/**********parent (generally mom's) report of mar qual 
(raw variables to create scale at r1)***/
R062630R R062640R R062670R R0626100 R0626500 R0626600
/* parent report of marital quality*/
MARQ_PR POSMARQP

/*Physical Environment*/
R1487100 phyenv

/*Peer vars*/
peerpos peernegsub

/*parent involvement in school*/
parinvolvr

/*Profile variables */
YRMQ_CLASS 
hisup_hicon hisup_lowcon lowsup_lowcon lowsup_hicon
yrmyr_class 
mhisust mlowinc mhidecr mlowsust
yrdyr_class 
dhisust dlowinc dlowsust dhidecr
yrpy_profiles 
bothpyhi dadhi momhi pylow
yrmarqual_parrel 
himq_bothhipy himq_onehipy 
hisupphicon_goodpy lomq_goodpy himq_badpy lowmq_badpy


rename = (
/*raw vars for round 1*/
/*Physical Environment*/
/*R1487100=PHYENV /*physical environment index*/
R0324700=MMPRAIS1 /*mom praises youth*/
R032480R=MMCRIT1 /*mom criticizes youth*/
R032500R=MMBLME1 /*mom blames youth*/
R032510R=MMCNCL1 /*mom cancels plans*/
R0324900=MMHELPS1 /*mom helps r with things that are important to r*/ 
R0324400=MMTKHLY1 /*think highly of mom*/
R0324500=MMBLIKE1 /*want to be like mom*/ 
R0324600=MMENJOY1 /*enjoy time with mom*/
R0326500=DDPRAIS1 /*dad praises youth*/
R0326700=DDHELPS1 /*dad helps r with things that are important to r*/   
R0326200=DDTKHLY1 /*think highly of dad*/  
R0326300=DDBLIKE1 /*want to be like dad*/   
R0326400=DDENJOY1 /*enjoy time with dad*/
R032660R=DDCRIT1 /*dad criticizes youth*/
R032680R=DDBLME1  /*dad blames youth*/
R032690R=DDCNCL1 /*dad cancels plans*/
R062630R = SPSCREAM /*spouse screams at mom*/
R062640R = SPINSULT /*spouse insults mom*/
R062670R = SPBLAME /*spouse blames mom*/
R0626100= SPCMPRMS /*spouse compromises with mom*/
R0626500= SPAFFECT /*spouse expresses affection*/
R0626600= SPENCRGE /*spouse encourages mom*/
R034650R= DSCRMYR1 /*Youth Report: Dad screams at mom*/
R034670R= DISLTYR1  /*Youth Report: Dad insults mom*/
R034690R= DBLMEYR1 /*Youth Report: Dad blames mom*/
R0346400= DCMPRYR1  /*Youth Report: Dad compromises with mom*/
R0346600= DAFCTYR1 /*Youth Report: Dad expresses affection for mom*/
R0346800= DECRGYR1 /*Youth Report: Dad encourages mom*/
R034590R= MSCRMYR1 /*Youth Report: Mom screams at dad*/
R034610R= MISLTYR1  /*Youth Report: Mom insults dad*/
R034630R= MBLMEYR1 /*Youth Report: Mom blames dad*/
R0345800= MCMPRYR1  /*Youth Report: Mom compromises with dad*/
R0346000= MAFCTYR1 /*Youth Report: Mom expresses affection for dad*/
R0346200= MECRGYR1 /*Youth Report: Mom encourages dad*/
/*raw vars for round 2*/
R2165400 = MMTKHLY2 /*think highly of mom*/
R216580R = MMCRIT2 /*mom criticizes youth*/ 
R2165500 = MMBLIKE2 /*want to be like mom*/ 
R216600R = MMBLME2 /*mom blames youth*/ 
R216610R = MMCNCL2 /*mom cancels plans*/
R2165600 = MMENJOY2 /*enjoy time with mom*/ 
R2165700 = MMPRAIS2 /*mom praises youth*/
R2165900 = MMHELPS2 /*mom helps r with things that are important to r*/ 
R2167300=DDPRAIS2 /*dad praises youth*/
R2167500=DDHELPS2 /*dad helps r with things that are important to r*/   
R2167000=DDTKHLY2 /*think highly of dad*/  
R2167100=DDBLIKE2 /*want to be like dad*/   
R2167200=DDENJOY2 /*enjoy time with dad*/
R216740R=DDCRIT2 /*dad criticizes youth*/
R216760R=DDBLME2  /*dad blames youth*/
R216770R=DDCNCL2 /*dad cancels plans*/
R217910R= DSCRMYR2 /*Youth Report: Dad screams at mom*/
R217930R= DISLTYR2  /*Youth Report: Dad insults mom*/
R217950R= DBLMEYR2 /*Youth Report: Dad blames mom*/
R2179000= DCMPRYR2  /*Youth Report: Dad compromises with mom*/
R2179200= DAFCTYR2 /*Youth Report: Dad expresses affection for mom*/
R2179400= DECRGYR2 /*Youth Report: Dad encourages mom*/
R217850R= MSCRMYR2 /*Youth Report: Mom screams at dad*/
R217870R= MISLTYR2  /*Youth Report: Mom insults dad*/
R217890R= MBLMEYR2 /*Youth Report: Mom blames dad*/
R2178400= MCMPRYR2  /*Youth Report: Mom compromises with dad*/
R2178600= MAFCTYR2 /*Youth Report: Mom expresses affection for dad*/
R2178800= MECRGYR2 /*Youth Report: Mom encourages dad*/
/*raw vars for round 3*/
R3483300 = MMTKHLY3 /*think highly of mom*/
R348400R = MMCRIT3 /*mom criticizes youth*/ 
R3483400 = MMBLIKE3 /*want to be like mom*/ 
R348390R = MMBLME3 /*mom blames youth*/ 
R348370R = MMCNCL3 /*mom cancels plans*/
R3483500 = MMENJOY3 /*enjoy time with mom*/ 
R3483600 = MMPRAIS3 /*mom praises youth*/
R3483800 = MMHELPS3 /*mom helps r with things that are important to r*/ 
R3485200 =DDPRAIS3 /*dad praises youth*/
R3485400 =DDHELPS3 /*dad helps r with things that are important to r*/   
R3484900 =DDTKHLY3 /*think highly of dad*/  
R3485000 =DDBLIKE3 /*want to be like dad*/   
R3485100 =DDENJOY3 /*enjoy time with dad*/
R348530R =DDCRIT3 /*dad criticizes youth*/
R348550R =DDBLME3  /*dad blames youth*/
R348560R =DDCNCL3 /*dad cancels plans*/
R349700R= DSCRMYR3 /*Youth Report: Dad screams at mom*/
R349720R= DISLTYR3  /*Youth Report: Dad insults mom*/
R349740R= DBLMEYR3 /*Youth Report: Dad blames mom*/
R3496900= DCMPRYR3  /*Youth Report: Dad compromises with mom*/
R3497100= DAFCTYR3 /*Youth Report: Dad expresses affection for mom*/
R3497300= DECRGYR3 /*Youth Report: Dad encourages mom*/
R349640R= MSCRMYR3 /*Youth Report: Mom screams at dad*/
R349660R= MISLTYR3  /*Youth Report: Mom insults dad*/
R349680R= MBLMEYR3 /*Youth Report: Mom blames dad*/
R3496300= MCMPRYR3  /*Youth Report: Mom compromises with dad*/
R3496500= MAFCTYR3 /*Youth Report: Mom expresses affection for dad*/
R3496700= MECRGYR3 /*Youth Report: Mom encourages dad*/

disconnected6 = discon6
disconnected7 = discon7
disconnected8 = discon8
dlnqscl9_16 = dlnqsc16 
evarrest16 = arrest16 
evarrest20 = arrest20 
subscl2_16 = subscl16 
subscl2_20 = subscl20
finalsafe = safsex16
finalsafe20 = safsex20

RPGOVTAID97 = govtaid
RPHEALTH97 = rphlth
RPSHEALTH97 = rpshlth
BIOMOMAGE = momage
CITIZENSHIP97 = citizen
MYPOSRELSUM = myposrel
BNGDRNK16 = binge16
BNGDRNK20 = binge20
DLNQSCL8A_16 = dlnq16
DLNQSCL9_20 = dlnq9_20
DLNQSCL8A_20 = dlnq20
SINGPAR97 = snglp97
SINGPAR98 = snglp98
SINGPAR99 = snglp99
DISRUP9799 = disr9799
REGVOTE04 = regvote
DISABLE16 = disabl16
DISABLE20 = disabl20
RPNETWORTH97 = netwrth
JOBADVICE = jobadvc
RELADVICE = reladvc
FINADVICE = finadvc
DADFIGAD1 = dadfadv1
DADFIGAD2 = dadfadv2
BIODADAD1 = bdadadv1
BIODADAD2 = bdadadv2
MOMFIGAD1 = momfadv1
MOMFIGAD2 = momfadv2
BIOMOMAD1 = bmomadv1
BIOMOMAD2 = bmomadv2
POSHELAGE = hlth1620
CURENROLL6 = enrollr6
CURENROLL7 = enrollr7
CURENROLL8 = enrollr8
NORTHEAST = neast
DISABLE16A = disab16a
peernegsub = peerneg
parinvolvr = parinvl
college20 = colleg20


YRMQ_CLASS = yrmq_c
hisup_hicon = hisphico
hisup_lowcon =hisploco
lowsup_lowcon = losploco
lowsup_hicon = losphico
yrmyr_class =yrmyr_c
yrdyr_class = yrdyr_c
yrpy_profiles = yrpy_c
yrmarqual_parrel = yrmqpy_c
himq_bothhipy = himq2gpy
himq_onehipy =himq1gpy
hisupphicon_goodpy = hispcgpy
lomq_goodpy = lomqgdpy
himq_badpy =himqbdpy
lowmq_badpy = lomqbdpy
));
Set datalib.famstr_profiles;


proc contents; run;
